/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.webhook;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.CaseFormat;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.internal.event.EventType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class Webhook
extends UserPermissionModel {
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance("SchedulerText");
    @Schema(description="Webhook ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Webhook Name", example="Power Apps On Job Created")
    private String name;
    @Schema(description="Webhook Signature Key", example="I7zG7gm1O8EGIbv8bpRA2qYZkJsCBUMM")
    private String signatureKey;
    @Schema(description="Is Webhook Active?", example="true")
    private Boolean active;
    @Schema(description="Webhook Triggers")
    private SortedSet<EventType.Type> triggers;
    @Schema(description="Webhook Status")
    private Status status;
    @Schema(description="Webhook Callback Address", example="https://example.com/webhooks?id=1")
    private String callbackAddress;
    @Schema(description="Is Webhook History?", example="true")
    private Boolean historyEnabled;
    @Schema(description="Webhook Whitelisted Certificates Fingerprints (SHA-512)", example="[\"e62dd01ca608c10402d07714cfd626bfc6b1001e5a16ca039d1050a71f73ee24\",\"d5129635a050f63dd607ffa9271eefaab597c0975809765dad253973fc554d25\"]")
    private SortedSet<String> whitelistedCertFingerprints;
    @Schema(description="Webhook Audit Log")
    private List<AuditEvent> auditLog;

    @Override
    public Webhook clone() {
        Webhook clone = (Webhook)super.clone();
        clone.triggers = new TreeSet<EventType.Type>();
        if (this.triggers != null) {
            clone.triggers.addAll(this.triggers);
        }
        clone.whitelistedCertFingerprints = new TreeSet<String>();
        if (this.whitelistedCertFingerprints != null) {
            clone.whitelistedCertFingerprints.addAll(this.whitelistedCertFingerprints);
        }
        clone.setStatus(this.status);
        return clone;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getCallbackAddress() {
        return this.callbackAddress;
    }

    public void setCallbackAddress(String callbackAddress) {
        this.callbackAddress = callbackAddress;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Boolean getHistoryEnabled() {
        return this.historyEnabled;
    }

    public void setHistoryEnabled(Boolean historyEnabled) {
        this.historyEnabled = historyEnabled;
    }

    public SortedSet<String> getWhitelistedCertFingerprints() {
        return this.whitelistedCertFingerprints;
    }

    public void setWhitelistedCertFingerprints(SortedSet<String> whitelistedCertFingerprints) {
        this.whitelistedCertFingerprints = whitelistedCertFingerprints;
    }

    public List<AuditEvent> getAuditLog() {
        if (this.auditLog == null) {
            this.auditLog = new ArrayList<AuditEvent>();
        }
        return this.auditLog;
    }

    public void setAuditLog(List<AuditEvent> auditLog) {
        this.auditLog = auditLog;
    }

    public SortedSet<EventType.Type> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(SortedSet<EventType.Type> triggers) {
        this.triggers = triggers;
    }

    public String getSignatureKey() {
        return this.signatureKey;
    }

    public void setSignatureKey(String signatureKey) {
        this.signatureKey = signatureKey;
    }

    @JsonIgnore
    public String getShortSessionId() {
        if (this.id != null) {
            return UidUtils.getShortId(this.id);
        }
        return "null";
    }

    public String toString() {
        return "Webhook " + this.name + " (" + this.getShortSessionId() + ")";
    }

    public void setDefaults() {
        if (this.getActive() == null) {
            this.setActive(true);
        }
        if (this.getHistoryEnabled() == null) {
            this.setHistoryEnabled(true);
        }
        if (this.triggers == null) {
            this.triggers = new TreeSet<EventType.Type>();
        }
        String triggersName = "None";
        if (this.triggers.size() == 1) {
            triggersName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.triggers.first().name());
        } else if (this.triggers.size() > 1) {
            triggersName = "MultipleEvents";
        }
        String eventName = "On" + triggersName;
        if (this.getName() == null) {
            try {
                URL aURL = new URL(this.getCallbackAddress());
                this.setName(eventName + " - " + aURL.getHost());
            }
            catch (MalformedURLException e) {
                this.setName(eventName);
            }
        }
    }

    public Webhook cloneLimited() {
        Webhook limited = new Webhook();
        limited.id = this.id;
        limited.name = this.name;
        limited.setUserPermissions(this.cloneUserPermissions());
        if (this.status != null) {
            limited.setStatus(this.status.cloneLimited());
        }
        limited.triggers = new TreeSet<EventType.Type>();
        return limited;
    }
}

