/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.workflowlibrary;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.workflow.ExecutionMode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Workflow
extends UserPermissionModel
implements Serializable,
Cloneable {
    @Schema(description="Workflow ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Workflow Name", example="Standard Processing")
    private String name;
    @Schema(description="Workflow Description", example="This workflow processes data using standard settings")
    private String description;
    @Schema(description="Workflow Usage", example="This workflow is used to process data")
    private String usage;
    @Schema(description="Library ID", example="11111111-1111-1111-1111-111111111111")
    private String libraryId;
    @Schema(description="Is Workflow Enabled?", example="true")
    private Boolean enabled;
    @Schema(description="Workflow Operations (RFN XML format)")
    private String operationsXml;
    @Schema(description="Allowed Parameter Values", ref="#/components/schemas/ParametersAllowedValues")
    private Map<String, List<String>> allowedParameterValues;
    @Schema(description="Workflow Execution Mode")
    private ExecutionMode explicitExecutionMode;
    @Schema(description="Engine Execution Mode")
    private ExecutionMode executionMode;
    @Schema(description="Last Modified (Epoch)", example="1641034800000")
    private Long lastModified = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
    @Schema(description="Session Parameters")
    private List<Parameter> sessionParameters;
    @Schema(description="Workflow Prerequisites", example="[\"Automate 7.0 or later\", \"Premium-edition license\"]")
    private List<String> prerequisites;
    @Schema(description="Workflow Icon")
    private String icon;

    @Override
    public Workflow clone() {
        Workflow clonedObject = (Workflow)super.clone();
        clonedObject.sessionParameters = new ArrayList<Parameter>();
        if (this.sessionParameters != null) {
            for (Parameter parameter : this.sessionParameters) {
                clonedObject.sessionParameters.add(new Parameter(parameter));
            }
        }
        clonedObject.prerequisites = new ArrayList<String>();
        if (this.prerequisites != null) {
            for (String prerequisite : this.prerequisites) {
                clonedObject.prerequisites.add(prerequisite);
            }
        }
        return clonedObject;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLibraryId() {
        return this.libraryId;
    }

    public void setLibraryId(String libraryId) {
        this.libraryId = libraryId;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getOperationsXml() {
        return this.operationsXml;
    }

    public void setOperationsXml(String operationsXml) {
        this.operationsXml = operationsXml;
    }

    public Map<String, List<String>> getAllowedParameterValues() {
        return this.allowedParameterValues;
    }

    public void setAllowedParameterValues(Map<String, List<String>> allowedParameterValues) {
        this.allowedParameterValues = allowedParameterValues;
    }

    public List<Parameter> getSessionParameters() {
        if (this.sessionParameters == null) {
            this.sessionParameters = new ArrayList<Parameter>();
        }
        return this.sessionParameters;
    }

    public void setSessionParameters(List<Parameter> sessionParameters) {
        this.sessionParameters = sessionParameters;
    }

    public void setDefaults() {
        if (this.getName() == null) {
            this.setName("Workflow " + this.getId());
        }
        if (this.getDescription() == null) {
            this.setDescription("");
        }
        if (this.getEnabled() == null) {
            this.setEnabled(false);
        }
        if (this.getUsage() == null) {
            this.setUsage("");
        }
    }

    public ExecutionMode getExplicitExecutionMode() {
        return this.explicitExecutionMode;
    }

    public void setExplicitExecutionMode(ExecutionMode explicitExecutionMode) {
        this.explicitExecutionMode = explicitExecutionMode;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    public long getLastModified() {
        if (this.lastModified == null) {
            this.lastModified = 0L;
        }
        return this.lastModified;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified != null ? lastModified : Long.valueOf(0L);
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public List<String> getPrerequisites() {
        return this.prerequisites;
    }

    public void setPrerequisites(List<String> prerequisites) {
        this.prerequisites = prerequisites;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Workflow cloneLimited() {
        Workflow limited = new Workflow();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.enabled = this.enabled;
        limited.libraryId = this.libraryId;
        limited.sessionParameters = this.sessionParameters;
        limited.icon = this.icon;
        limited.setUserPermissions(this.cloneUserPermissions());
        return limited;
    }
}

