/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.cache;

import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class CachedObject<T>
implements Serializable {
    private T object;
    private long expirationMs;
    private long expireInMs;

    public CachedObject() {
    }

    public CachedObject(long expireInMs) {
        this.expireInMs = expireInMs;
        this.updateExpiry(expireInMs);
    }

    public CachedObject(T t, long expireInMs) {
        this.object = t;
        this.expireInMs = expireInMs;
        this.updateExpiry(expireInMs);
    }

    public void resetExpiry() {
        this.updateExpiry(this.expireInMs);
    }

    public void updateExpiry(long expireInMs) {
        this.expirationMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + expireInMs;
    }

    public boolean isExpired() {
        return DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() > this.getExpirationMs();
    }

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public long getExpirationMs() {
        return this.expirationMs;
    }

    public void setExpirationMs(long expirationMs) {
        this.expirationMs = expirationMs;
    }
}

