/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.ecc;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Set;

public class EccProfileModel
extends UserPermissionModel
implements Serializable,
Cloneable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EccProfileModel.class);
    @Schema(description="ECC Profile ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="ECC Profile Name", example="Internal ECC Server")
    private String name;
    @Schema(description="ECC Server URL", example="https://ecc.local")
    private String serverUrl;
    @Schema(description="ECC Profile Username", example="administrator")
    private String username;
    @Schema(description="ECC Profile Password", example="I7zG7gm1O8EGIbv8bpRA2qYZkJsCBUMM")
    private String password;
    @Schema(description="ECC Profile Name", example="Internal ECC Server")
    private String description;
    @Schema(description="ECC Profile Status")
    private Status status;
    @Schema(description="ECC Server Version")
    private String version;
    @Schema(description="ECC Whitelisted Certificates Fingerprints (SHA-512)", example="[\"e62dd01ca608c10402d07714cfd626bfc6b1001e5a16ca039d1050a71f73ee24\",\"d5129635a050f63dd607ffa9271eefaab597c0975809765dad253973fc554d25\"]")
    private Set<String> whitelistedCertFingerprints;
    @Schema(description="Is Sync with AD Enabled?", example="true")
    private Boolean syncWithAd;
    @Schema(description="Deploy ECC Agent Prior to Starting Collection?", example="true")
    private Boolean deployBeforeCollection;
    @Schema(description="ECC Agent Deployment Command", example="powershell -command write 'Installing on {computername}'")
    private String eccInstallCommand;
    @Schema(description="Remove ECC Agent After Collection Completes?", example="true")
    private Boolean removeAfterCollection;
    @Schema(description="ECC Agent Removal Command", example="powershell -command write 'Uninstalling from {computername}'")
    private String eccUninstallCommand;
    @Schema(description="ECC Agent Deployment Password", example="I7zG7gm1O8EGIbv8bpRA2qYZkJsCBUMM")
    private String remoteAgentPassword;
    @Schema(description="Should ECC Agent Deployment Retry on Failure?", example="true")
    private Boolean retryCommand;
    @Schema(description="ECC Agent Deployment Timeout (Minutes)", example="5")
    private Integer timeout;

    @Override
    public EccProfileModel clone() {
        return (EccProfileModel)super.clone();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Set<String> getWhitelistedCertFingerprints() {
        return this.whitelistedCertFingerprints;
    }

    public void setWhitelistedCertFingerprints(Set<String> whitelistedCertFingerprints) {
        this.whitelistedCertFingerprints = whitelistedCertFingerprints;
    }

    public Boolean getSyncWithAd() {
        return this.syncWithAd;
    }

    public void setSyncWithAd(Boolean syncWithAd) {
        this.syncWithAd = syncWithAd;
    }

    public Boolean getDeployBeforeCollection() {
        return this.deployBeforeCollection;
    }

    public void setDeployBeforeCollection(Boolean deployBeforeCollection) {
        this.deployBeforeCollection = deployBeforeCollection;
    }

    public String getEccInstallCommand() {
        return this.eccInstallCommand;
    }

    public void setEccInstallCommand(String eccInstallCommand) {
        this.eccInstallCommand = eccInstallCommand;
    }

    public Boolean getRemoveAfterCollection() {
        return this.removeAfterCollection;
    }

    public void setRemoveAfterCollection(Boolean removeAfterCollection) {
        this.removeAfterCollection = removeAfterCollection;
    }

    public String getEccUninstallCommand() {
        return this.eccUninstallCommand;
    }

    public void setEccUninstallCommand(String eccUninstallCommand) {
        this.eccUninstallCommand = eccUninstallCommand;
    }

    public String getRemoteAgentPassword() {
        return this.remoteAgentPassword;
    }

    public void setRemoteAgentPassword(String remoteAgentPassword) {
        this.remoteAgentPassword = remoteAgentPassword;
    }

    public Boolean getRetryCommand() {
        return this.retryCommand;
    }

    public void setRetryCommand(Boolean retryCommand) {
        this.retryCommand = retryCommand;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status();
        }
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }
}

