/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.engine;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.LocalizedEnum;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.engine.EngineStatus;
import com.nuix.automate.utils.models.api.job.Priority;
import com.nuix.automate.utils.workflow.ExecutionMode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class EngineModel
extends UserPermissionModel
implements Comparable<EngineModel>,
Serializable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EngineModel.class);
    private String id;
    private String name;
    private String serverId;
    private String nuixLicenceSourceId;
    private String executionProfileId;
    private Integer targetNuixWorkers;
    private Integer minNuixWorkers;
    private Integer acquiredWorkers;
    private String nuixVersion;
    private String javaVersion;
    private String nuixLicenceType;
    private EngineStatus status;
    private String error;
    private long errorTime;
    private Double runningJobPercentageComplete;
    private Map<String, String> tags;
    private Priority priority;
    private String runningJobId;
    private String bootstrappingJobId;
    private String logFile;
    private boolean workerAgentOnly;
    private ExecutionMode currentExecutionMode;
    private ExecutionMode supportedExecutionMode;
    private String licenseSessionId;

    @Override
    public int compareTo(EngineModel o) {
        if (o.getName() == null || this.name == null) {
            return 0;
        }
        return (this.name + this.id).toLowerCase().compareTo((o.name + o.id).toLowerCase());
    }

    public EngineModel(EngineModel copy) {
        this.id = copy.id;
        this.name = copy.name;
        this.serverId = copy.serverId;
        this.nuixLicenceSourceId = copy.nuixLicenceSourceId;
        this.executionProfileId = copy.executionProfileId;
        this.targetNuixWorkers = copy.targetNuixWorkers;
        this.minNuixWorkers = copy.minNuixWorkers;
        this.acquiredWorkers = copy.acquiredWorkers;
        this.nuixVersion = copy.nuixVersion;
        this.javaVersion = copy.javaVersion;
        this.status = copy.status;
        this.priority = copy.priority;
        this.error = copy.error;
        this.nuixLicenceType = copy.nuixLicenceType;
        this.runningJobPercentageComplete = copy.runningJobPercentageComplete;
        this.tags = new HashMap<String, String>();
        if (copy.tags != null) {
            this.tags.putAll(copy.tags);
        }
        this.runningJobId = copy.runningJobId;
        this.logFile = copy.logFile;
        this.workerAgentOnly = copy.workerAgentOnly;
        this.currentExecutionMode = copy.currentExecutionMode;
    }

    public long getErrorTime() {
        return this.errorTime;
    }

    public void setErrorTime() {
        this.errorTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public EngineModel() {
    }

    public String getNuixLicenceType() {
        return this.nuixLicenceType;
    }

    public void setNuixLicenceType(String nuixLicenceType) {
        this.nuixLicenceType = nuixLicenceType;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Double getRunningJobPercentageComplete() {
        return this.runningJobPercentageComplete;
    }

    public void setRunningJobPercentageComplete(Double runningJobPercentageComplete) {
        this.runningJobPercentageComplete = runningJobPercentageComplete;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    public Integer getTargetNuixWorkers() {
        return this.targetNuixWorkers;
    }

    @JsonProperty
    public void setTargetNuixWorkers(Integer targetNuixWorkers) {
        this.targetNuixWorkers = targetNuixWorkers;
    }

    @JsonProperty
    public Integer getMinNuixWorkers() {
        if (this.minNuixWorkers == null) {
            return this.targetNuixWorkers;
        }
        return this.minNuixWorkers;
    }

    @JsonProperty
    public void setMinNuixWorkers(Integer minNuixWorkers) {
        this.minNuixWorkers = minNuixWorkers;
    }

    @JsonProperty
    public String getNuixVersion() {
        return this.nuixVersion;
    }

    @JsonProperty
    public void setEngineVersion(String nuixVersion) {
        this.nuixVersion = nuixVersion;
    }

    public Integer getAcquiredWorkers() {
        return this.acquiredWorkers;
    }

    public void setAcquiredWorkers(Integer acquiredWorkers) {
        this.acquiredWorkers = acquiredWorkers;
    }

    @JsonProperty
    public void setNuixVersion(String nuixVersion) {
        this.nuixVersion = nuixVersion;
    }

    public EngineStatus getStatus() {
        return this.status;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public synchronized void appendErrorLine(String line) {
        this.error = this.error == null || this.error.length() == 0 ? line : this.error + "\n" + line;
    }

    public void setStatus(EngineStatus status) {
        this.status = status;
        if (status == EngineStatus.ERROR || status == EngineStatus.WARNING) {
            this.setErrorTime();
        }
    }

    public String toString() {
        String engineString = "Engine " + this.getName() + " (" + FormattingUtils.getShortId(this.id, 8) + ")" + (this.workerAgentOnly ? " [WorkerOnly]" : "");
        if (this.status != null) {
            engineString = engineString + " [" + new LocalizedEnum<EngineStatus>("SchedulerText", this.status) + "]" + (EngineStatus.PENDING.equals(this.status) && this.bootstrappingJobId != null && this.bootstrappingJobId.length() > 0 ? " [Bootstrapping:" + this.bootstrappingJobId + "]" : "");
        }
        return engineString;
    }

    public String getNuixLicenceSourceId() {
        return this.nuixLicenceSourceId;
    }

    public void setNuixLicenceSourceId(String nuixLicenceSourceId) {
        this.nuixLicenceSourceId = nuixLicenceSourceId;
    }

    public String getExecutionProfileId() {
        return this.executionProfileId;
    }

    public void setExecutionProfileId(String executionProfileId) {
        this.executionProfileId = executionProfileId;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getRunningJobId() {
        return this.runningJobId;
    }

    public void setRunningJobId(String runningJobId) {
        this.runningJobId = runningJobId;
    }

    public String getBootstrappingJobId() {
        return this.bootstrappingJobId;
    }

    public void setBootstrappingJobId(String bootstrappingJobId) {
        this.bootstrappingJobId = bootstrappingJobId;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public boolean getWorkerAgentOnly() {
        return this.workerAgentOnly;
    }

    public void setWorkerAgentOnly(boolean workerAgentOnly) {
        this.workerAgentOnly = workerAgentOnly;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public ExecutionMode getCurrentExecutionMode() {
        return this.currentExecutionMode;
    }

    public void setCurrentExecutionMode(ExecutionMode currentExecutionMode) {
        this.currentExecutionMode = currentExecutionMode;
    }

    public ExecutionMode getSupportedExecutionMode() {
        if (this.supportedExecutionMode == null) {
            return ExecutionMode.AUTOMATE_NUIX;
        }
        return this.supportedExecutionMode;
    }

    public void setSupportedExecutionMode(ExecutionMode supportedExecutionMode) {
        this.supportedExecutionMode = supportedExecutionMode;
    }

    public String getLicenseSessionId() {
        return this.licenseSessionId;
    }

    public void setLicenseSessionId(String licenseSessionId) {
        this.licenseSessionId = licenseSessionId;
    }
}

