/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.formbuilder;

import com.nuix.automate.utils.general.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public enum FieldComponentType {
    NULL,
    GROUP,
    ROW,
    RADIO_BUTTON_GROUP,
    RADIO_BUTTON_CHECKBOX_GROUP,
    INPUT,
    TEXTAREA,
    NUMBER,
    CHECKBOX,
    RADIO_BUTTON,
    DROPDOWN,
    CHECKED_DROPDOWN,
    DROPDOWN_SELECTED_LIST,
    DATE,
    TIME,
    DATE_TIME,
    OBJECT,
    OBJECT_LIST,
    OBJECT_TABLE,
    INPUT_LIST,
    SCRIPT_PANE,
    NUIX_PROFILE,
    PARAMETER_TABLE,
    PARAMETER_INPUT,
    PARAMETER_DROPDOWN;

    private static final Set<Class<?>> primitiveNumberClasses;

    public static FieldComponentType deduceFieldComponentType(Field field) {
        Class<?> clazz = field.getType();
        if (String.class.isAssignableFrom(clazz)) {
            return INPUT;
        }
        if (clazz.isPrimitive() && primitiveNumberClasses.contains(clazz) || Number.class.isAssignableFrom(clazz)) {
            return NUMBER;
        }
        if (clazz.isPrimitive() && clazz.equals(Boolean.TYPE) || Boolean.class.isAssignableFrom(clazz)) {
            return CHECKBOX;
        }
        if (clazz.isEnum()) {
            return DROPDOWN;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DATE_TIME;
        }
        Class collectionType = null;
        if (clazz.isArray()) {
            collectionType = clazz.getComponentType();
        } else if (Collection.class.isAssignableFrom(clazz)) {
            collectionType = (Class)ReflectionUtils.getGenericParameterizedTypeArguments(field)[0];
        }
        if (collectionType != null) {
            if (String.class.isAssignableFrom(collectionType)) {
                return INPUT_LIST;
            }
            if (!Number.class.isAssignableFrom(collectionType) && !Boolean.class.isAssignableFrom(collectionType)) {
                if (collectionType.isEnum()) {
                    return CHECKED_DROPDOWN;
                }
                if (collectionType.isArray()) {
                    return OBJECT_TABLE;
                }
            }
            return OBJECT_LIST;
        }
        return OBJECT;
    }

    static {
        primitiveNumberClasses = new HashSet<Class>(Arrays.asList(Short.TYPE, Integer.TYPE, Long.TYPE, Double.TYPE, Float.TYPE));
    }
}

