/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.formbuilder;

import com.nuix.automate.utils.models.internal.formbuilder.ComponentConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.PositionedLabel;
import java.util.ArrayList;

public class FieldGroupConfiguration
extends ComponentConfiguration {
    private boolean styled;
    private Integer numberOfColumns;

    public FieldGroupConfiguration() {
    }

    public FieldGroupConfiguration(FormFieldGroup formFieldGroup) {
        this.setName(formFieldGroup.name());
        this.setComponentType(FieldComponentType.GROUP);
        this.setComponentConfigurations(new ArrayList<ComponentConfiguration>());
        this.styled = formFieldGroup.styled();
        if (formFieldGroup.label().isEmpty()) {
            this.setLabel(formFieldGroup.name());
        } else {
            this.setLabel(formFieldGroup.label());
        }
        this.setPositionedLabel(new PositionedLabel(formFieldGroup.positionLabel()));
        this.setVisibleOn(FieldGroupConfiguration.buildOnValuesMap(formFieldGroup.visibleOn()));
        if (this.getVisibleOn() != null) {
            this.setVisibleOnOperator(formFieldGroup.visibleOnOperator());
        }
        this.setEnableOn(FieldGroupConfiguration.buildOnValuesMap(formFieldGroup.enableOn()));
        if (this.getEnableOn() != null) {
            this.setEnableOnOperator(formFieldGroup.enableOnOperator());
        }
    }

    public FieldGroupConfiguration(FormFieldRow formFieldRow) {
        this.setName(formFieldRow.name());
        this.setComponentType(FieldComponentType.ROW);
        this.setComponentConfigurations(new ArrayList<ComponentConfiguration>());
        if (formFieldRow.numberOfColumns() > 0) {
            this.numberOfColumns = formFieldRow.numberOfColumns();
        }
        if (formFieldRow.label().isEmpty()) {
            this.setLabel(formFieldRow.name());
        } else {
            this.setLabel(formFieldRow.label());
        }
        this.setVisibleOn(FieldGroupConfiguration.buildOnValuesMap(formFieldRow.visibleOn()));
        if (this.getVisibleOn() != null) {
            this.setVisibleOnOperator(formFieldRow.visibleOnOperator());
        }
        this.setEnableOn(FieldGroupConfiguration.buildOnValuesMap(formFieldRow.enableOn()));
        if (this.getEnableOn() != null) {
            this.setEnableOnOperator(formFieldRow.enableOnOperator());
        }
    }

    @Override
    public Integer getSortOrder() {
        Integer sortOrder = this.getOrder();
        if (this.getComponentConfigurations() != null) {
            for (ComponentConfiguration componentConfiguration : this.getComponentConfigurations()) {
                Integer order = componentConfiguration.getSortOrder();
                if (sortOrder != null && (order == null || order.compareTo(sortOrder) >= 0)) continue;
                sortOrder = order;
            }
        }
        return sortOrder;
    }

    public void addChild(ComponentConfiguration childConfiguration) {
        childConfiguration.setGroup((String)this.getName());
        this.getComponentConfigurations().add(childConfiguration);
        if (this.getComponentType() == FieldComponentType.ROW && childConfiguration.getComponentType() != FieldComponentType.CHECKBOX) {
            childConfiguration.setLabel(null);
        }
    }

    public boolean getStyled() {
        return this.styled;
    }

    public void setStyled(boolean styled) {
        this.styled = styled;
    }

    public Integer getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(Integer numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
    }
}

