/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.formbuilder;

import com.nuix.automate.utils.general.ReflectionUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.ComponentConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesProducer;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldColumnConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.FieldGroupConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.FieldLicenseModule;
import com.nuix.automate.utils.models.internal.formbuilder.FieldRadioButtonGroupConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.FormConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRadioButtonGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValue;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValueConfiguration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class FormFieldProcessor {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(FormFieldProcessor.class);
    private DynamicValuesProducer dynamicValuesProducer;
    private boolean replaceScriptPaneWithTextArea;
    private Set<ModuleType> licensedModules;

    public FormFieldProcessor withProducer(DynamicValuesProducer dynamicValuesProducer) {
        this.dynamicValuesProducer = dynamicValuesProducer;
        return this;
    }

    public FormFieldProcessor withLicensedModules(Set<ModuleType> modules) {
        this.licensedModules = modules;
        return this;
    }

    public <T> FormConfiguration getClassFormConfiguration(Class<T> clazz) {
        ComponentConfiguration childConfiguration;
        FieldGroupConfiguration groupConfiguration;
        FieldGroupConfiguration rowConfiguration;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Building formConfiguration for class: " + clazz.getName());
        }
        FormConfiguration formConfiguration = new FormConfiguration();
        HashMap<String, ComponentConfiguration> componentConfigurations = new HashMap<String, ComponentConfiguration>();
        Function<String, ComponentConfiguration> removeChildComponentConfiguration = child -> {
            if (!componentConfigurations.containsKey(child)) {
                throw new IllegalArgumentException("Invalid FormField configuration, child does not exist or was already used: " + child + "; class: " + clazz.getSimpleName());
            }
            return (ComponentConfiguration)componentConfigurations.remove(child);
        };
        for (ComponentConfiguration componentConfiguration : this.getClassFieldConfigurations(clazz)) {
            formConfiguration.getTemplate().put((String)componentConfiguration.getName(), ((FieldConfiguration)componentConfiguration).getDefaultValue());
            componentConfigurations.put((String)componentConfiguration.getName(), componentConfiguration);
        }
        HashMap<String, FieldGroupConfiguration> groupConfigurations = new HashMap<String, FieldGroupConfiguration>();
        FormFieldGroup[] formFieldGroups = (FormFieldGroup[])clazz.getAnnotationsByType(FormFieldGroup.class);
        FormFieldRow[] formFieldRows = (FormFieldRow[])clazz.getAnnotationsByType(FormFieldRow.class);
        for (FormFieldRow formFieldRow : formFieldRows) {
            rowConfiguration = new FieldGroupConfiguration(formFieldRow);
            componentConfigurations.put((String)rowConfiguration.getName(), rowConfiguration);
            groupConfigurations.put((String)rowConfiguration.getName(), rowConfiguration);
        }
        for (Annotation annotation : formFieldGroups) {
            groupConfiguration = new FieldGroupConfiguration((FormFieldGroup)annotation);
            componentConfigurations.put((String)groupConfiguration.getName(), groupConfiguration);
            groupConfigurations.put((String)groupConfiguration.getName(), groupConfiguration);
        }
        for (Annotation annotation : (FormFieldRadioButtonGroup[])clazz.getAnnotationsByType(FormFieldRadioButtonGroup.class)) {
            FieldRadioButtonGroupConfiguration radioButtonGroupConfiguration = new FieldRadioButtonGroupConfiguration((FormFieldRadioButtonGroup)annotation);
            componentConfigurations.put((String)radioButtonGroupConfiguration.getName(), radioButtonGroupConfiguration);
            if (radioButtonGroupConfiguration.getComponentType() == FieldComponentType.RADIO_BUTTON_GROUP) {
                FieldConfiguration radioButtonConfiguration = (FieldConfiguration)removeChildComponentConfiguration.apply(annotation.radioButton());
                radioButtonConfiguration.setGroup((String)radioButtonGroupConfiguration.getName());
                radioButtonGroupConfiguration.setRadioButtonConfiguration(radioButtonConfiguration);
            }
            for (RadioButtonValue radioButtonValue : annotation.values()) {
                FieldConfiguration checkboxFieldConfiguration;
                RadioButtonValueConfiguration radioButtonValueConfiguration = new RadioButtonValueConfiguration(radioButtonValue);
                radioButtonValueConfiguration.setGroup((String)radioButtonGroupConfiguration.getName());
                radioButtonGroupConfiguration.getValueConfigurations().put(radioButtonValue.value(), radioButtonValueConfiguration);
                if (radioButtonGroupConfiguration.getComponentType() == FieldComponentType.RADIO_BUTTON_CHECKBOX_GROUP && (checkboxFieldConfiguration = (FieldConfiguration)componentConfigurations.remove(radioButtonValue.value())) != null) {
                    radioButtonValueConfiguration.update(checkboxFieldConfiguration);
                }
                ComponentConfiguration componentConfiguration = (ComponentConfiguration)componentConfigurations.remove(radioButtonValue.component());
                radioButtonValueConfiguration.setComponentConfiguration(componentConfiguration);
                if (componentConfiguration == null || componentConfiguration instanceof FieldConfiguration && ((FieldConfiguration)componentConfiguration).getKeepLabel()) continue;
                componentConfiguration.setLabel(null);
            }
        }
        for (Annotation annotation : formFieldRows) {
            rowConfiguration = (FieldGroupConfiguration)groupConfigurations.get(annotation.name());
            for (String string : annotation.children()) {
                childConfiguration = removeChildComponentConfiguration.apply(string);
                rowConfiguration.getComponentConfigurations().add(childConfiguration);
                childConfiguration.setGroup((String)rowConfiguration.getName());
                if (childConfiguration.getComponentType() == FieldComponentType.CHECKBOX) continue;
                childConfiguration.setLabel(null);
            }
        }
        for (Annotation annotation : formFieldGroups) {
            groupConfiguration = (FieldGroupConfiguration)groupConfigurations.get(annotation.name());
            for (String string : annotation.children()) {
                childConfiguration = removeChildComponentConfiguration.apply(string);
                childConfiguration.setGroup((String)groupConfiguration.getName());
                groupConfiguration.getComponentConfigurations().add(childConfiguration);
            }
        }
        formConfiguration.getComponentConfigurations().addAll(componentConfigurations.values());
        try {
            this.sortComponentConfigurations(formConfiguration.getComponentConfigurations());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid Class: " + clazz.getSimpleName(), e);
        }
        return formConfiguration;
    }

    public <T> List<ComponentConfiguration> getClassFieldConfigurations(Class<T> clazz) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Building fieldConfigurations for class: " + clazz.getName());
        }
        ArrayList<ComponentConfiguration> fieldConfigurations = new ArrayList<ComponentConfiguration>();
        Object defaultInstance = null;
        try {
            defaultInstance = ReflectionUtils.initializeDefaultClassInstance(clazz);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOGGER.error("Error initializing default instance for class, " + clazz.getSimpleName(), e);
        }
        List<Field> classFields = ReflectionUtils.getAllDeclaredFields(clazz, true);
        for (int i = 0; i < classFields.size(); ++i) {
            Field field = classFields.get(i);
            try {
                FieldLicenseModule fieldModule;
                field.setAccessible(true);
                FormField formField = field.getAnnotation(FormField.class);
                if (formField == null) continue;
                FieldConfiguration fieldConfiguration = new FieldConfiguration(formField, field);
                fieldConfiguration.setNaturalOrder(i);
                if (this.licensedModules != null && (fieldModule = field.getAnnotation(FieldLicenseModule.class)) != null && !this.licensedModules.contains((Object)fieldModule.value())) {
                    fieldConfiguration.setDisabled(true);
                }
                if (this.replaceScriptPaneWithTextArea && fieldConfiguration.getComponentType() == FieldComponentType.SCRIPT_PANE) {
                    fieldConfiguration.setComponentType(FieldComponentType.TEXTAREA);
                }
                if (formField.allowedValuesDynamicType() != DynamicValuesType.NULL) {
                    Collection<String> dynamicAllowedValues;
                    fieldConfiguration.setDynamicValuesType(formField.allowedValuesDynamicType());
                    if (this.dynamicValuesProducer != null && (dynamicAllowedValues = this.dynamicValuesProducer.produce(fieldConfiguration.getDynamicValuesType())) != null) {
                        fieldConfiguration.setAllowedValues(new ArrayList<String>(dynamicAllowedValues));
                    }
                }
                if (defaultInstance != null) {
                    try {
                        Object defaultValue = fieldConfiguration.getEffectiveDefaultValue(field.get(defaultInstance));
                        if (defaultValue != null && defaultValue.getClass().isEnum()) {
                            defaultValue = SerializationUtils.enumToJsonString((Enum)defaultValue);
                        }
                        fieldConfiguration.setDefaultValue(defaultValue);
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.error("Error initializing default instance for class, " + clazz.getSimpleName(), e);
                    }
                }
                FieldComponentType fieldComponentType = fieldConfiguration.getComponentType();
                if (fieldConfiguration.getComponentConfigurations() == null || fieldConfiguration.getComponentConfigurations().size() == 0) {
                    switch (fieldComponentType) {
                        case OBJECT: 
                        case OBJECT_LIST: 
                        case PARAMETER_TABLE: {
                            Class objectClass = fieldConfiguration.getFieldClass();
                            if (objectClass == null) {
                                objectClass = fieldComponentType == FieldComponentType.OBJECT ? field.getType() : (Class)ReflectionUtils.getGenericParameterizedTypeArguments(field)[0];
                            }
                            fieldConfiguration.setFormConfiguration(this.getClassFormConfiguration(objectClass));
                            if (formField.whitelistedFields().length <= 0) break;
                            HashSet<String> whitelistedFields = new HashSet<String>(Arrays.asList(formField.whitelistedFields()));
                            fieldConfiguration.getFormConfiguration().getComponentConfigurations().removeIf(componentConfiguration -> !whitelistedFields.contains(String.valueOf(componentConfiguration.getName())));
                            break;
                        }
                        case OBJECT_TABLE: {
                            Class objectClass = (Class)ReflectionUtils.getGenericParameterizedTypeArguments(field)[0];
                            fieldConfiguration.setComponentConfigurations(this.getClassFieldConfigurations(objectClass));
                            break;
                        }
                    }
                } else if (fieldComponentType == FieldComponentType.OBJECT || fieldComponentType == FieldComponentType.OBJECT_LIST) {
                    FormConfiguration formConfiguration = new FormConfiguration();
                    for (ComponentConfiguration componentConfiguration2 : fieldConfiguration.getComponentConfigurations()) {
                        FieldColumnConfiguration columnConfiguration = (FieldColumnConfiguration)componentConfiguration2;
                        if (columnConfiguration.getComponentType() == FieldComponentType.OBJECT && columnConfiguration.getFieldClass() != null) {
                            FormConfiguration columnObjectFormConfiguration = this.getClassFormConfiguration(columnConfiguration.getFieldClass());
                            columnConfiguration.setFormConfiguration(columnObjectFormConfiguration);
                            columnConfiguration.setDefaultValue(columnObjectFormConfiguration.getTemplate());
                        }
                        formConfiguration.getComponentConfigurations().add(columnConfiguration);
                        formConfiguration.getTemplate().put(String.valueOf(columnConfiguration.getName()), columnConfiguration.getDefaultValue());
                    }
                    fieldConfiguration.setFormConfiguration(formConfiguration);
                    fieldConfiguration.setComponentConfigurations(null);
                }
                fieldConfigurations.add(fieldConfiguration);
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.sortComponentConfigurations(fieldConfigurations);
        return fieldConfigurations;
    }

    private void sortComponentConfigurations(List<? extends ComponentConfiguration> componentConfigurations) {
        componentConfigurations.sort((c1, c2) -> Comparator.comparing(ComponentConfiguration::getSortOrder, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ComponentConfiguration::getOrder, Comparator.nullsLast(Comparator.naturalOrder())).compare((ComponentConfiguration)c1, (ComponentConfiguration)c2));
    }

    public boolean getReplaceScriptPaneWithTextArea() {
        return this.replaceScriptPaneWithTextArea;
    }

    public void setReplaceScriptPaneWithTextArea(boolean replaceScriptPaneWithTextArea) {
        this.replaceScriptPaneWithTextArea = replaceScriptPaneWithTextArea;
    }

    public Set<ModuleType> getLicensedModules() {
        return this.licensedModules;
    }
}

