/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.graphapi;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.graphapi.MicrosoftGraphIdentity;
import com.nuix.automate.utils.models.internal.graphapi.MicrosoftGraphIdentitySet;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.time.Instant;

@JsonPropertyOrder(value={"id"})
public class MicrosoftGraphObject {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MicrosoftGraphObject.class);
    @Schema(description="@odata.context", example="https://graph.microsoft.com/beta/compliance/ediscovery/$metadata#cases/$entity")
    @JsonProperty(value="@odata.context")
    private String oDataContext;
    @JsonProperty(value="@odata.id")
    private String oDataId;
    @Schema(description="ID", example="11111111-1111-1111-1111-111111111111")
    protected String id;
    @Schema(description="Display Name", example="Sample Name")
    protected String displayName;
    @Schema(description="Description", example="Sample description")
    protected String description;
    @Schema(description="Created Date (Epoch)", example="1641034800000")
    private Long createdDate;
    @Schema(description="Last Modified Date (Epoch)", example="1641034800000")
    private Long lastModifiedDate;

    protected Long parseDateTime(String dateTime) {
        if (dateTime != null) {
            return Instant.parse(dateTime).toEpochMilli();
        }
        return null;
    }

    protected MicrosoftGraphIdentitySet parseUserIdentitySet(JsonNode jsonNode) {
        if (jsonNode.getNodeType() == JsonNodeType.STRING) {
            MicrosoftGraphIdentitySet identitySet = new MicrosoftGraphIdentitySet();
            identitySet.setUser(new MicrosoftGraphIdentity());
            identitySet.getUser().setDisplayName(jsonNode.textValue());
            return identitySet;
        }
        if (jsonNode.getNodeType() == JsonNodeType.OBJECT) {
            try {
                ObjectReader objectReader = new ObjectMapper().readerFor(MicrosoftGraphIdentitySet.class);
                return (MicrosoftGraphIdentitySet)objectReader.readValue(jsonNode);
            }
            catch (IOException e) {
                LOGGER.error("Error parsing user from identitySet", e);
            }
        }
        return null;
    }

    protected String parseUsername(MicrosoftGraphIdentitySet identitySet) {
        MicrosoftGraphIdentity user;
        if (identitySet != null && (user = identitySet.getUser()) != null) {
            String username = user.getDisplayName();
            if (username == null) {
                username = user.getUserPrincipalName();
            }
            return username;
        }
        return null;
    }

    public String getODataContext() {
        return this.oDataContext;
    }

    public void setODataContext(String oDataContext) {
        this.oDataContext = oDataContext;
    }

    public String getODataId() {
        return this.oDataId;
    }

    public void setODataId(String oDataId) {
        this.oDataId = oDataId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public void setCreatedDateTime(String createdDateTime) {
        this.createdDate = this.parseDateTime(createdDateTime);
    }

    public Long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setLastModifiedDateTime(String lastModifiedDateTime) {
        this.lastModifiedDate = this.parseDateTime(lastModifiedDateTime);
    }
}

