/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.logging;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.joda.time.DateTime;

public class LogEventModel
implements Serializable {
    private String id;
    private String component;
    private long date;
    private byte[] message;
    private String jobId;
    private long logLine;

    public LogEventModel(String id, String jobId, String component, long date, long logLine) {
        this.id = id;
        this.jobId = jobId;
        this.component = component;
        this.date = date;
        this.logLine = logLine;
    }

    public LogEventModel(long date, byte[] message) {
        this.date = date;
        this.message = message;
    }

    public LogEventModel(String message) {
        this.date = DateTime.now().getMillis();
        this.message = message.getBytes(StandardCharsets.UTF_8);
    }

    public LogEventModel(String jobId, String logLevel, long date, byte[] message) {
        this.jobId = jobId;
        this.component = logLevel;
        this.date = date;
        this.message = message;
    }

    public LogEventModel() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public long getDate() {
        return this.date;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] message) {
        this.message = message;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public long getLogLine() {
        return this.logLine;
    }

    public void setLogLine(long logLine) {
        this.logLine = logLine;
    }

    public String toString() {
        return "LogEventModel{id='" + this.id + '\'' + ", component='" + this.component + '\'' + ", date=" + this.date + ", logLine=" + this.logLine + '}';
    }
}

