/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.purview;

import com.nuix.automate.utils.general.LocalizableEnumUtils;

public enum DataSourceType {
    USER("microsoft.graph.security.userSource"),
    UNIFIED_GROUP("microsoft.graph.security.unifiedGroupSource"),
    SITE("microsoft.graph.security.siteSource");

    private final String odataType;

    private DataSourceType(String odataType) {
        this.odataType = odataType;
    }

    public String getOdataType() {
        return this.odataType;
    }

    public static DataSourceType forOdataType(String odataType) {
        for (DataSourceType sourceType : DataSourceType.values()) {
            if (!sourceType.odataType.equals(odataType)) continue;
            return sourceType;
        }
        return null;
    }

    public String toLocalizedString() {
        return LocalizableEnumUtils.getLocalizedString(this);
    }
}

