/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.purview;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import com.nuix.automate.utils.models.internal.graphapi.MicrosoftGraphIdentitySet;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryCaseStatus;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryObject;
import io.swagger.v3.oas.annotations.media.Schema;

public class EDiscoveryCase
extends EDiscoveryObject {
    @Schema(description="External ID", example="11111111-1111-1111-1111-111111111111")
    private String externalId;
    @Schema(description="eDiscovery Case Status", example="Active")
    private EDiscoveryCaseStatus status;
    @Schema(description="Closed By", example="{\n        \"application\": null,\n        \"user\": {\n            \"id\": \"c25c3914-f9f7-43ee-9cba-a25377e0cec6\",\n            \"displayName\": null,\n            \"userPrincipalName\": \"c25c3914-f9f7-43ee-9cba-a25377e0cec6\"\n        }\n    }")
    private MicrosoftGraphIdentitySet closedBy;
    private String closedByUsername;
    @Schema(description="Closed Date (Epoch)", example="1641034800000")
    private Long closedDate;

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public EDiscoveryCaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(EDiscoveryCaseStatus status) {
        this.status = status;
    }

    public MicrosoftGraphIdentitySet getClosedBy() {
        return this.closedBy;
    }

    @JsonSetter
    public void setClosedBy(JsonNode jsonNode) {
        this.closedBy = this.parseUserIdentitySet(jsonNode);
        this.closedByUsername = this.parseUsername(this.closedBy);
    }

    public String getClosedByUsername() {
        return this.closedByUsername;
    }

    public Long getClosedDate() {
        return this.closedDate;
    }

    public void setClosedDate(Long closedDate) {
        this.closedDate = closedDate;
    }

    public void setClosedDatetime(String closedDatetime) {
        this.closedDate = this.parseDateTime(closedDatetime);
    }
}

