/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.purview;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import io.swagger.v3.oas.annotations.media.Schema;

public class EDiscoveryCaseRedundancyDetectionSettings {
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");
    @Schema(description="Is Email Threading and Near Duplicate Detection Enabled", example="true")
    @FormField
    private Boolean isEnabled = true;
    @Schema(description="Max Words", example="500000")
    @FormField(enableOn={@OnField(name="isEnabled")})
    private Integer maxWords = 500000;
    @Schema(description="Min Words", example="10")
    @FormField(enableOn={@OnField(name="isEnabled")})
    private Integer minWords = 10;
    @Schema(description="Similarity Level for Documents in Near Duplicate Set", example="65")
    @FormField(enableOn={@OnField(name="isEnabled")}, positionLabel=@PositionLabel(right="%"))
    private Integer similarityThreshold = 65;

    @JsonIgnore
    public String isInvalid() {
        if (this.isEnabled == Boolean.TRUE) {
            if (this.minWords != null && this.minWords < 0 || this.maxWords != null && this.maxWords < 0 || this.minWords != null && this.maxWords != null && this.minWords > this.maxWords) {
                return iu.getString("CaseRedundancyDetectionSettings.InvalidMinMaxWords");
            }
            if (this.similarityThreshold < 40 || this.similarityThreshold > 100) {
                return iu.getString("CaseRedundancyDetectionSettings.InvalidSimilarityThreshold");
            }
        }
        return null;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean enabled) {
        this.isEnabled = enabled;
    }

    public Integer getMaxWords() {
        return this.maxWords;
    }

    public void setMaxWords(Integer maxWords) {
        this.maxWords = maxWords;
    }

    public Integer getMinWords() {
        return this.minWords;
    }

    public void setMinWords(Integer minWords) {
        this.minWords = minWords;
    }

    public Integer getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public void setSimilarityThreshold(Integer similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
    }
}

