/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.purview.operations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryObject;
import com.nuix.automate.utils.models.internal.purview.ResultInfo;
import com.nuix.automate.utils.models.internal.purview.operations.CaseAction;
import com.nuix.automate.utils.models.internal.purview.operations.CaseOperationStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class CaseOperation
extends EDiscoveryObject {
    @Schema(description="Case Operation Action")
    private CaseAction action;
    @Schema(description="Case Operation Status")
    private CaseOperationStatus status;
    @Schema(description="Completed Date (Epoch)", example="1641034800000")
    private Long completedDate;
    @Schema(description="Case Operation Percent Progress", example="59")
    private Integer percentProgress;
    @Schema(description="Case Operation Result Info")
    private ResultInfo resultInfo;

    @JsonIgnore
    public boolean isRunning() {
        switch (this.status) {
            case NOT_STARTED: 
            case RUNNING: {
                return true;
            }
        }
        return false;
    }

    @JsonIgnore
    public boolean isErrored() {
        switch (this.status) {
            case FAILED: 
            case SUBMISSION_FAILED: {
                return true;
            }
        }
        return false;
    }

    @JsonIgnore
    public boolean hasWarning() {
        switch (this.status) {
            case PARTIALLY_SUCCEEDED: {
                return true;
            }
        }
        return false;
    }

    @JsonIgnore
    public boolean isFinished() {
        switch (this.status) {
            case PARTIALLY_SUCCEEDED: 
            case SUCCEEDED: {
                return true;
            }
        }
        return false;
    }

    @JsonIgnore
    public int getStageWeightedProgress(int stageWeight) {
        if (this.isFinished()) {
            return stageWeight;
        }
        Integer percentProgress = this.getPercentProgress();
        if (percentProgress != null) {
            return (int)((double)percentProgress.intValue() / 100.0 * (double)stageWeight);
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaseOperation)) {
            return false;
        }
        CaseOperation other = (CaseOperation)o;
        return super.equals(other) && Objects.equals((Object)this.action, (Object)other.action) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.completedDate, other.completedDate) && Objects.equals(this.percentProgress, other.percentProgress) && Objects.equals(this.resultInfo, other.resultInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.action, this.status, this.completedDate, this.percentProgress, this.resultInfo});
    }

    public CaseAction getAction() {
        return this.action;
    }

    public void setAction(CaseAction action) {
        this.action = action;
    }

    public CaseOperationStatus getStatus() {
        return this.status;
    }

    public void setStatus(CaseOperationStatus status) {
        this.status = status;
    }

    public Long getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Long completedDate) {
        this.completedDate = completedDate;
    }

    public void setCompletedDatetime(String completedDateTime) {
        this.completedDate = this.parseDateTime(completedDateTime);
    }

    public Integer getPercentProgress() {
        return this.percentProgress;
    }

    public void setPercentProgress(Integer percentProgress) {
        this.percentProgress = percentProgress;
    }

    public ResultInfo getResultInfo() {
        return this.resultInfo;
    }

    public void setResultInfo(ResultInfo resultInfo) {
        this.resultInfo = resultInfo;
    }
}

