/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.resourcepool;

import com.nuix.automate.utils.workflow.ExecutionMode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;

public class AutoRegistrationSettings
implements Serializable {
    @Schema(description="Engine License Source ID", example="11111111-1111-1111-1111-111111111111")
    private String nuixLicenceSourceId;
    @Schema(description="Execution Profile ID", example="11111111-1111-1111-1111-111111111111")
    private String executionProfileId;
    @Schema(description="Engine Target Workers Count", example="4")
    private Integer targetNuixWorkers;
    @Schema(description="Engine Minimum Workers Count", example="2")
    private Integer minNuixWorkers;
    @Schema(description="Engine Supported Execution Mode")
    private ExecutionMode supportedExecutionMode;
    @Schema(description="Access Key", example="I7zG7gm1O8EGIbv8bpRA2qYZkJsCBUMM")
    private String accessKey;
    @Schema(description="Only only registration from the same IP as the destination server", example="true")
    private boolean strictIp;

    public AutoRegistrationSettings() {
    }

    public AutoRegistrationSettings(AutoRegistrationSettings copy) {
        this.nuixLicenceSourceId = copy.nuixLicenceSourceId;
        this.executionProfileId = copy.executionProfileId;
        this.targetNuixWorkers = copy.targetNuixWorkers;
        this.minNuixWorkers = copy.minNuixWorkers;
        this.supportedExecutionMode = copy.supportedExecutionMode;
        this.accessKey = copy.accessKey;
        this.strictIp = copy.strictIp;
    }

    public void removeSecrets() {
        this.accessKey = null;
    }

    public String getNuixLicenceSourceId() {
        return this.nuixLicenceSourceId;
    }

    public void setNuixLicenceSourceId(String nuixLicenceSourceId) {
        this.nuixLicenceSourceId = nuixLicenceSourceId;
    }

    public Integer getTargetNuixWorkers() {
        return this.targetNuixWorkers;
    }

    public void setTargetNuixWorkers(Integer targetNuixWorkers) {
        this.targetNuixWorkers = targetNuixWorkers;
    }

    public Integer getMinNuixWorkers() {
        if (this.minNuixWorkers == null) {
            return this.targetNuixWorkers;
        }
        return this.minNuixWorkers;
    }

    public void setMinNuixWorkers(Integer minNuixWorkers) {
        this.minNuixWorkers = minNuixWorkers;
    }

    public String getExecutionProfileId() {
        return this.executionProfileId;
    }

    public void setExecutionProfileId(String executionProfileId) {
        this.executionProfileId = executionProfileId;
    }

    public ExecutionMode getSupportedExecutionMode() {
        return this.supportedExecutionMode;
    }

    public void setSupportedExecutionMode(ExecutionMode supportedExecutionMode) {
        this.supportedExecutionMode = supportedExecutionMode;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public boolean getStrictIp() {
        return this.strictIp;
    }

    public void setStrictIp(boolean strictIp) {
        this.strictIp = strictIp;
    }
}

