/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.resourcepool;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.logging.CircularBufferLog;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.resourcepool.Type;
import com.nuix.automate.utils.models.internal.resourcepool.AutoRegistrationSettings;
import com.nuix.automate.utils.models.internal.resourcepool.CloudResourcePoolSettings;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;

public class ResourcePoolModel
extends UserPermissionModel
implements Serializable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ResourcePoolModel.class);
    @Schema(description="Resource Pool ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Resource Pool Name", example="Pool A")
    private String name;
    @Schema(description="Resource Pool Description", example="Sample description")
    private String description;
    @Schema(description="Is Resource Pool Enabled?", example="true")
    private Boolean active;
    @Schema(description="Engine IDs", example="[\"11111111-1111-1111-1111-111111111111\",\"22222222-2222-2222-2222-222222222222\"]")
    private Set<String> engineIds;
    @Schema(description="Remote Engine IDs", example="[\"11111111-1111-1111-1111-111111111111\",\"22222222-2222-2222-2222-222222222222\"]")
    private Set<String> remoteEngineIds;
    @Schema(description="Resource Pool Type")
    private Type type;
    @Schema(description="Resource Pool Cloud Settings")
    private CloudResourcePoolSettings cloudSettings;
    @Schema(description="Resource Pool Status")
    private Status status;
    @Schema(description="Resource Pool Reference ID", example="11111111-1111-1111-1111-111111111111")
    private String referenceId;
    @Schema(description="Is Engine Self-Registration Enabled?", example="true")
    private Boolean autoRegistrationEnabled;
    @Schema(description="Self-Registration Engine Settings")
    private AutoRegistrationSettings autoRegistrationSettings;
    private boolean readOnly;
    private CircularBufferLog log;

    public CircularBufferLog getLog() {
        return this.log;
    }

    public void clearLog() {
        this.log.clear();
    }

    public void addLog(String logLine) {
        LOGGER.info(logLine);
        this.log.addLog(logLine);
    }

    public boolean isCloud() {
        return this.type.equals((Object)Type.AWS) || this.type.equals((Object)Type.AZURE);
    }

    public ResourcePoolModel() {
        this.log = new CircularBufferLog();
    }

    public ResourcePoolModel(ResourcePoolModel copy) {
        this.id = copy.id;
        this.name = copy.name;
        this.description = copy.description;
        this.engineIds = new HashSet<String>();
        if (copy.engineIds != null) {
            this.engineIds.addAll(copy.engineIds);
        }
        this.remoteEngineIds = new HashSet<String>();
        if (copy.remoteEngineIds != null) {
            this.remoteEngineIds.addAll(copy.remoteEngineIds);
        }
        this.type = copy.type;
        this.active = copy.active;
        if (copy.cloudSettings != null) {
            this.cloudSettings = new CloudResourcePoolSettings(copy.cloudSettings);
        }
        this.log = copy.log;
        if (copy.status != null) {
            this.status = copy.status.clone();
        }
        this.autoRegistrationEnabled = copy.autoRegistrationEnabled;
        this.autoRegistrationSettings = copy.autoRegistrationSettings;
        this.readOnly = copy.readOnly;
    }

    public CloudResourcePoolSettings getCloudSettings() {
        return this.cloudSettings;
    }

    public void setCloudSettings(CloudResourcePoolSettings cloudSettings) {
        this.cloudSettings = cloudSettings;
    }

    public Set<String> getEngineIds() {
        return this.engineIds;
    }

    public void setEngineIds(Set<String> engineIds) {
        this.engineIds = engineIds;
    }

    public Set<String> getRemoteEngineIds() {
        return this.remoteEngineIds;
    }

    public void setRemoteEngineIds(Set<String> remoteEngineIds) {
        this.remoteEngineIds = remoteEngineIds;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public Boolean getAutoRegistrationEnabled() {
        return this.autoRegistrationEnabled;
    }

    public void setAutoRegistrationEnabled(Boolean autoRegistrationEnabled) {
        this.autoRegistrationEnabled = autoRegistrationEnabled;
    }

    public AutoRegistrationSettings getAutoRegistrationSettings() {
        return this.autoRegistrationSettings;
    }

    public void setAutoRegistrationSettings(AutoRegistrationSettings autoRegistrationSettings) {
        this.autoRegistrationSettings = autoRegistrationSettings;
    }

    public String toString() {
        return "Resource Pool " + this.name + " (" + (Object)((Object)this.type) + ")";
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status();
        }
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setDefaults() {
        if (this.getName() == null) {
            this.setName("Resource Pool " + this.getId());
        }
        if (this.getDescription() == null) {
            this.setDescription("");
        }
        if (this.getActive() == null) {
            this.setActive(false);
        }
        if (this.getType() == null) {
            this.setType(Type.LOCAL);
        }
    }

    public boolean checkSettingsValid() {
        boolean selfRegistrationSettingsValid = true;
        switch (this.type) {
            case AWS: 
            case AZURE: {
                if (!Boolean.TRUE.equals(this.autoRegistrationEnabled)) break;
                this.setAutoRegistrationEnabled(false);
                selfRegistrationSettingsValid = false;
                break;
            }
            case LOCAL: {
                break;
            }
            case KUBERNETES: {
                if (Boolean.TRUE.equals(this.autoRegistrationEnabled)) break;
                this.setAutoRegistrationEnabled(true);
                selfRegistrationSettingsValid = false;
                break;
            }
            default: {
                throw new NotImplementedException("Resource Pool type " + (Object)((Object)this.type) + " is not supported");
            }
        }
        return true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

