/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.user;

import com.nuix.automate.utils.models.api.user.LoginLinkScope;
import com.nuix.automate.utils.security.SecurityUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class LoginLinkPayload {
    private String userId;
    private String legalHoldId;
    private String redirectUrl;
    private LoginLinkScope scope;
    private long createdDate;
    private final int nonce;

    public LoginLinkPayload(LoginLinkPayload linkPayload) {
        this.userId = linkPayload.getUserId();
        this.legalHoldId = linkPayload.getLegalHoldId();
        this.scope = linkPayload.getScope();
        this.createdDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        this.nonce = SecurityUtils.getSecureRandomInt();
        this.redirectUrl = linkPayload.getRedirectUrl();
    }

    public LoginLinkPayload(String userId, String legalHoldId, LoginLinkScope scope) {
        this.userId = userId;
        this.legalHoldId = legalHoldId;
        this.scope = scope;
        this.createdDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        this.nonce = SecurityUtils.getSecureRandomInt();
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getLegalHoldId() {
        return this.legalHoldId;
    }

    public void setLegalHoldId(String legalHoldId) {
        this.legalHoldId = legalHoldId;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public LoginLinkScope getScope() {
        return this.scope;
    }

    public void setScope(LoginLinkScope scope) {
        this.scope = scope;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(long createdDate) {
        this.createdDate = createdDate;
    }

    public int getNonce() {
        return this.nonce;
    }
}

