/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.vault;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.models.internal.googleapi.PagedResponse;
import com.nuix.automate.utils.models.internal.vault.CorpusType;
import com.nuix.automate.utils.models.internal.vault.VaultObject;
import com.nuix.automate.utils.models.internal.vault.hold.HeldAccount;
import com.nuix.automate.utils.models.internal.vault.hold.HeldLocation;
import com.nuix.automate.utils.models.internal.vault.hold.HeldOrgUnit;
import com.nuix.automate.utils.models.internal.vault.hold.HeldQuery;
import com.nuix.automate.utils.models.internal.vault.query.SearchMethod;
import java.util.ArrayList;
import java.util.List;

public class VaultHold
extends VaultObject {
    private String holdId;
    private CorpusType corpus;
    private Long updatedDate;
    private List<HeldAccount> accounts;
    private HeldOrgUnit orgUnit;
    private HeldQuery query;

    @JsonIgnore
    public SearchMethod getSearchMethod() {
        if (this.accounts != null && !this.accounts.isEmpty()) {
            return SearchMethod.ACCOUNT;
        }
        return SearchMethod.ORG_UNIT;
    }

    @JsonIgnore
    public List<HeldLocation> getHeldLocations() {
        ArrayList<HeldLocation> heldLocations = new ArrayList<HeldLocation>();
        switch (this.getSearchMethod()) {
            case ACCOUNT: {
                if (this.accounts == null) break;
                for (HeldAccount heldAccount : this.accounts) {
                    if (heldAccount == null) continue;
                    heldLocations.add(new HeldLocation(heldAccount));
                }
                break;
            }
            case ORG_UNIT: {
                if (this.orgUnit == null) break;
                heldLocations.add(new HeldLocation(this.orgUnit));
            }
        }
        return heldLocations;
    }

    public String getHoldId() {
        return this.holdId;
    }

    public void setHoldId(String holdId) {
        this.holdId = holdId;
    }

    public CorpusType getCorpus() {
        return this.corpus;
    }

    public void setCorpus(CorpusType corpus) {
        this.corpus = corpus;
    }

    public Long getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Long updatedDate) {
        this.updatedDate = updatedDate;
    }

    public void setUpdateTime(String updateTime) {
        this.updatedDate = this.parseDateTime(updateTime);
    }

    public List<HeldAccount> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<HeldAccount> accounts) {
        this.accounts = accounts;
    }

    public HeldOrgUnit getOrgUnit() {
        return this.orgUnit;
    }

    public void setOrgUnit(HeldOrgUnit orgUnit) {
        this.orgUnit = orgUnit;
    }

    public HeldQuery getQuery() {
        return this.query;
    }

    public void setQuery(HeldQuery query) {
        this.query = query;
    }

    public String toUserPrintableString() {
        SearchMethod searchMethod = this.getSearchMethod();
        String str = "service: " + this.corpus.toLocalizedString() + ", location type: " + searchMethod.toLocalizedString();
        if (searchMethod == SearchMethod.ACCOUNT) {
            str = str + ", email count: " + this.accounts.size();
        } else if (searchMethod == SearchMethod.ORG_UNIT) {
            str = str + ", org unit: " + this.orgUnit.getOrgUnitId();
        }
        return str;
    }

    public String toString() {
        String str = "Hold{name=" + this.getName() + ",corpus=" + (Object)((Object)this.corpus);
        if (this.holdId != null) {
            str = str + ",holdId=" + this.holdId;
        }
        if (this.updatedDate != null) {
            str = str + ",updatedDate=" + this.updatedDate;
        }
        if (this.accounts != null) {
            str = str + ",accounts=[" + this.accounts.size() + "]";
        }
        if (this.orgUnit != null) {
            str = str + ",orgUnit=" + this.orgUnit;
        }
        if (this.query != null) {
            str = str + ",query=" + this.query;
        }
        return str + "}";
    }

    public static class PagedVaultHoldResponse
    extends PagedResponse<VaultHold> {
        private List<VaultHold> holds;

        @Override
        public List<VaultHold> getValue() {
            return this.holds;
        }

        public void setHolds(List<VaultHold> holds) {
            this.holds = holds;
        }
    }
}

