/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.vault;

import com.nuix.automate.utils.models.internal.formbuilder.ComparisonOperator;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.vault.CorpusType;
import com.nuix.automate.utils.models.internal.vault.query.SearchMethod;

public class VaultLocation {
    @FormField(excludeValues={"CORPUS_TYPE_UNSPECIFIED"})
    private CorpusType corpusType;
    @FormField(excludeValues={"SEARCH_METHOD_UNSPECIFIED"})
    private SearchMethod searchMethod;
    @FormField(enableOn={@OnField(name="searchMethod", value={"ENTIRE_ORG"}, comparisonOperator=ComparisonOperator.NOT_EQUAL)})
    private String value;

    public VaultLocation() {
    }

    public VaultLocation(CorpusType corpusType, SearchMethod searchMethod, String value) {
        this.corpusType = corpusType;
        this.searchMethod = searchMethod;
        if (value != null) {
            this.value = value.trim();
        }
    }

    public static VaultLocation build(Object[] queryLocationLine) {
        CorpusType corpusType = CorpusType.normalizeType((String)queryLocationLine[0]);
        SearchMethod searchMethod = SearchMethod.normalizeType((String)queryLocationLine[1]);
        String value = (String)queryLocationLine[2];
        return new VaultLocation(corpusType, searchMethod, value);
    }

    public CorpusType getCorpusType() {
        return this.corpusType;
    }

    public void setCorpusType(CorpusType corpusType) {
        this.corpusType = corpusType;
    }

    public SearchMethod getSearchMethod() {
        return this.searchMethod;
    }

    public void setSearchMethod(SearchMethod searchMethod) {
        this.searchMethod = searchMethod;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

