/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.vault.hold;

import com.nuix.automate.utils.models.api.userservice.GoogleOrgUnit;
import com.nuix.automate.utils.models.internal.vault.hold.HeldAccount;
import com.nuix.automate.utils.models.internal.vault.hold.HeldOrgUnit;
import com.nuix.automate.utils.models.internal.vault.query.SearchMethod;

public class HeldLocation {
    private SearchMethod type;
    private String id;
    private String email;

    public HeldLocation() {
    }

    public HeldLocation(HeldAccount heldAccount) {
        this.type = SearchMethod.ACCOUNT;
        this.id = heldAccount.getAccountId();
        this.email = heldAccount.getEmail();
    }

    public HeldLocation(HeldOrgUnit heldOrgUnit) {
        this.type = SearchMethod.ORG_UNIT;
        this.id = heldOrgUnit.getOrgUnitId();
    }

    public Item getItem() {
        String value = this.email;
        if (value == null) {
            value = this.id;
        }
        return new Item(value, value);
    }

    public Item getItem(GoogleOrgUnit orgUnit) {
        String displayName = orgUnit.getPath();
        if (displayName.startsWith("/") && displayName.length() > 1) {
            displayName = displayName.substring(1);
        }
        if (!displayName.endsWith(orgUnit.getName())) {
            displayName = displayName + " (" + orgUnit.getName() + ")";
        }
        return new Item(displayName, orgUnit.getId());
    }

    public SearchMethod getType() {
        return this.type;
    }

    public void setType(SearchMethod type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public static class Item {
        private String name;
        private String value;

        public Item(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

