/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.persistance;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.IdEncryptor;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@SqlStatementCustomizingAnnotation(value=ConsumptionBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindConsumption {

    public static class ConsumptionBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConsumptionBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                Consumption arg = (Consumption)obj;
                q.bind("id", arg.getId());
                q.bind("timestamp", DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
                IdEncryptor idEncryptor = new IdEncryptor("consumption");
                String encryptedDetails = null;
                try {
                    encryptedDetails = idEncryptor.encrypt(SerializationUtils.toDbJson(arg));
                }
                catch (IOException e) {
                    LOGGER.error("Cannot encrypt consumption record", e);
                }
                q.bind("details", encryptedDetails);
            };
        }
    }
}

