/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.persistance;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.licence.services.EventInfo;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.IdEncryptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@SqlStatementCustomizingAnnotation(value=EventInfoBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindEventInfo {

    public static class EventInfoBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EventInfoBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                String encryptedDetails;
                block2: {
                    EventInfo arg = (EventInfo)obj;
                    q.bind("id", arg.getId());
                    q.bind("timestamp", DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
                    IdEncryptor idEncryptor = new IdEncryptor("session");
                    encryptedDetails = null;
                    try {
                        encryptedDetails = idEncryptor.encrypt(SerializationUtils.toDbJson(arg));
                    }
                    catch (IOException e) {
                        if (!LOGGER.isDebugEnabled()) break block2;
                        LOGGER.debug("Cannot encrypt EventInfo", e);
                    }
                }
                q.bind("details", encryptedDetails);
            };
        }
    }
}

