/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.persistance;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.IdEncryptor;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class ConsumptionMapper
implements RowMapper<Consumption> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConsumptionMapper.class);

    public Consumption map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        String encryptedDetails = resultSet.getString("details");
        IdEncryptor idEncryptor = new IdEncryptor("consumption");
        String decryptedDetails = null;
        try {
            decryptedDetails = idEncryptor.decrypt(encryptedDetails);
        }
        catch (IOException e) {
            LOGGER.error("Cannot decrypt consumption record", e);
        }
        Consumption consumption = SerializationUtils.fromJson(decryptedDetails, Consumption.class);
        return consumption;
    }
}

