/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.persistance;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.Priority;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.workflow.ExecutionMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class EngineMapper
implements RowMapper<EngineModel> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EngineMapper.class);

    public EngineModel map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        EngineModel engineModel = new EngineModel();
        engineModel.setId(resultSet.getString("id"));
        engineModel.setName(resultSet.getString("name"));
        engineModel.setNuixLicenceSourceId(resultSet.getString("nuixLicenceSourceId"));
        engineModel.setExecutionProfileId(resultSet.getString("executionProfileId"));
        engineModel.setTargetNuixWorkers(resultSet.getInt("targetNuixWorkers"));
        String minWorkersName = resultSet.getString("minNuixWorkers");
        if (minWorkersName == null || minWorkersName.length() == 0) {
            engineModel.setMinNuixWorkers(engineModel.getTargetNuixWorkers());
        } else {
            engineModel.setMinNuixWorkers(resultSet.getInt("minNuixWorkers"));
        }
        String priorityName = resultSet.getString("priority");
        if (priorityName == null || priorityName.length() == 0) {
            engineModel.setPriority(Priority.MEDIUM);
        } else {
            engineModel.setPriority(Priority.fromInteger(resultSet.getInt("priority")));
        }
        engineModel.setTags(SerializationUtils.fromJson(resultSet.getString("tags"), Map.class));
        String supportedExecutionModeName = resultSet.getString("supportedExecutionMode");
        engineModel.setSupportedExecutionMode(ExecutionMode.AUTOMATE_NUIX);
        try {
            engineModel.setSupportedExecutionMode(ExecutionMode.valueOf(supportedExecutionModeName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (engineModel.getSupportedExecutionMode().equals((Object)ExecutionMode.AUTOMATE_NATIVE)) {
            engineModel.setNuixLicenceSourceId(null);
            engineModel.setTargetNuixWorkers(null);
            engineModel.setMinNuixWorkers(null);
        }
        return engineModel;
    }
}

