/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.persistance;

import com.nuix.automate.utils.api.internal.automatelicense.AutomateLicenceModel;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.licence.services.Credentials;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.Encryptor;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class RampivaLicenceMapper
implements RowMapper<AutomateLicenceModel> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RampivaLicenceMapper.class);

    public AutomateLicenceModel map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        Credentials credentials;
        String encryptedPassword;
        AutomateLicenceModel licenceDetails = SerializationUtils.fromJson(resultSet.getString("details"), AutomateLicenceModel.class);
        licenceDetails.setId(resultSet.getString("id"));
        licenceDetails.setStatus(null);
        if (licenceDetails != null && licenceDetails.getCredentials() != null && (encryptedPassword = (credentials = licenceDetails.getCredentials()).getLicenseKey()) != null) {
            try {
                String decryptedPassword = Encryptor.getUserInstance().decrypt(encryptedPassword);
                credentials.setLicenseKey(decryptedPassword);
            }
            catch (IOException e) {
                credentials.setLicenseKey(null);
                LOGGER.error("Cannot decrypt Automate license credentials", e);
            }
        }
        return licenceDetails;
    }
}

