/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.proxy;

import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;

public class SystemProxyRoutePlanner
extends DefaultRoutePlanner {
    public static final SystemProxyRoutePlanner INSTANCE = new SystemProxyRoutePlanner();
    private static final Pattern WILDCARD = Pattern.compile("\\*");
    private static final String REGEX_WILDCARD = ".*";
    private volatile HttpHost proxy;
    private volatile List<Pattern> nonProxyHostPatterns;

    public SystemProxyRoutePlanner(SchemePortResolver schemePortResolver) {
        super(schemePortResolver);
        this.resetProxy();
    }

    public SystemProxyRoutePlanner() {
        this(null);
    }

    @Nullable
    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) {
        if (this.proxy != null && this.nonProxyHostPatterns != null) {
            for (Pattern nonProxyHostPattern : this.nonProxyHostPatterns) {
                if (!nonProxyHostPattern.matcher(target.getHostName()).matches()) continue;
                return null;
            }
        }
        return this.proxy;
    }

    public synchronized void resetProxy() {
        NetworkConfiguration networkConfiguration = NetworkConfiguration.fromSystemProperties();
        if (networkConfiguration.isProxyConfigured()) {
            this.nonProxyHostPatterns = this.getNonProxyHostPatterns(networkConfiguration.getNonProxyHosts());
            this.proxy = new HttpHost(networkConfiguration.getProxyHost(), networkConfiguration.getProxyPort().intValue());
        } else {
            this.proxy = null;
            this.nonProxyHostPatterns = null;
        }
    }

    protected List<Pattern> getNonProxyHostPatterns(@Nullable Collection<String> nonProxyHosts) {
        if (nonProxyHosts == null) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(nonProxyHosts.size());
        for (String nonProxyHost : nonProxyHosts) {
            patterns.add(Pattern.compile(WILDCARD.matcher(nonProxyHost).replaceAll(REGEX_WILDCARD)));
        }
        return Collections.unmodifiableList(patterns);
    }
}

