/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.responsecache;

import com.nuix.automate.utils.api.internal.configuration.CacheConfiguration;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.responsecache.CachDisabledException;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.CacheKeyDifferentException;
import com.nuix.automate.utils.responsecache.CacheKeyMissingException;
import com.nuix.automate.utils.responsecache.CacheStaleException;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ResponseCache
implements Closeable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ResponseCache.class);
    private static ResponseCache instance;
    private static CacheConfiguration configuration;
    private static Map<CacheKey, Map<String, Long>> cache;
    private static long creationDate;
    private long nativeETagDelay = 1000L;
    private long virtualETagDelay = 1000L;
    private Random random = new Random();
    boolean enableVirtualTag = false;
    boolean enableDelayOnNotModified = false;
    private Map<String, String> virtualETag = new LinkedHashMap<String, String>();

    private ResponseCache() {
        cache = new HashMap<CacheKey, Map<String, Long>>();
    }

    public static void initialize(CacheConfiguration configuration) {
        ResponseCache.setConfiguration(configuration);
    }

    private static void setConfiguration(CacheConfiguration configuration) {
        ResponseCache.configuration = configuration;
    }

    public static synchronized ResponseCache getInstance() {
        long currentMillis;
        if (instance == null) {
            instance = new ResponseCache();
            creationDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        }
        if ((currentMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()) - creationDate > configuration.getGlobalResponseCacheMaxValidity()) {
            LOGGER.info("Resetting Global Response Cache");
            creationDate = currentMillis;
            try {
                instance.close();
            }
            catch (IOException e) {
                LOGGER.error("Unexpected error", e);
            }
            instance = new ResponseCache();
        }
        return instance;
    }

    public String hashObject(Object o) {
        if (o == null) {
            return null;
        }
        String json = o.getClass().toString() + "" + SerializationUtils.toJson(o);
        try {
            return DatatypeConverter.printHexBinary((byte[])MessageDigest.getInstance("MD5").digest(json.getBytes(StandardCharsets.UTF_8))).substring(0, 8).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Cannot hash object", e);
            return null;
        }
    }

    public Long getLastModified(CacheKey key) {
        return this.getLastModified(key, "", configuration.getResponseCacheMaxValidity());
    }

    public Long getLastModified(CacheKey key, String id) {
        return this.getLastModified(key, id, configuration.getResponseCacheMaxValidity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getLastModified(CacheKey key, String id, long validity) {
        if (configuration.getDisableResponseCache()) {
            return DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        }
        Map<String, Long> sessionIdCacheKey = cache.get((Object)key);
        if (sessionIdCacheKey == null) {
            sessionIdCacheKey = new HashMap<String, Long>();
            cache.put(key, sessionIdCacheKey);
        }
        Long lastModified = sessionIdCacheKey.get(id);
        long currentMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        if (lastModified == null || currentMillis - lastModified > validity) {
            if (lastModified != null) {
                Long l = lastModified;
                synchronized (l) {
                    lastModified.notifyAll();
                }
            }
            lastModified = currentMillis;
            sessionIdCacheKey.put(id, lastModified);
        }
        return lastModified;
    }

    public void resetKeyId(CacheKey key) {
        this.resetKeyId(key, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetKeyId(CacheKey key, String id) {
        Long timestamp;
        Map<String, Long> sessionIdCacheKey = cache.get((Object)key);
        if (sessionIdCacheKey != null && (timestamp = sessionIdCacheKey.remove(id)) != null) {
            Long l = timestamp;
            synchronized (l) {
                timestamp.notifyAll();
            }
        }
    }

    public void resetAll() {
        cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVirtualETag(HttpServletRequest request, String sessionId) {
        String previousETag;
        String key = request.getRequestURI() + sessionId;
        Map<String, String> map = this.virtualETag;
        synchronized (map) {
            previousETag = this.virtualETag.get(key);
        }
        if (previousETag != null) {
            return previousETag;
        }
        return "" + this.random.nextDouble();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVirtualETag(HttpServletRequest request, String sessionId, String tag) {
        String key = request.getRequestURI() + sessionId;
        Map<String, String> map = this.virtualETag;
        synchronized (map) {
            while (this.virtualETag.size() > 100) {
                this.virtualETag.entrySet().iterator().remove();
            }
        }
        this.virtualETag.put(key, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getResponse(CacheKey cacheKey, String id, HttpServletRequest request, String sessionId) throws CacheException {
        String[] splits;
        boolean eTagIsVirtual = false;
        if (configuration.getDisableResponseCache()) {
            throw new CachDisabledException();
        }
        String etag = request.getHeader("If-None-Match");
        if (etag == null) {
            if (this.enableVirtualTag) {
                eTagIsVirtual = true;
                etag = this.getVirtualETag(request, sessionId);
            } else {
                etag = "" + this.random.nextInt();
            }
        }
        if ((splits = (etag = etag.replace("--gzip", "")).split("-")).length >= 2 && splits[1].equals(sessionId)) {
            String header;
            String browserLastModified = splits[0];
            Long cacheLastModified = ResponseCache.getInstance().getLastModified(cacheKey, id);
            if (browserLastModified.equals("" + cacheLastModified) && ((header = request.getHeader("X-Application-State")) == null || !header.toLowerCase().equals("init"))) {
                try {
                    Long l = cacheLastModified;
                    synchronized (l) {
                        if (this.enableDelayOnNotModified) {
                            if (eTagIsVirtual) {
                                cacheLastModified.wait(this.virtualETagDelay);
                            } else {
                                cacheLastModified.wait(this.nativeETagDelay);
                            }
                        }
                    }
                    if (!eTagIsVirtual) {
                        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        Long newCacheLastModified = ResponseCache.getInstance().getLastModified(cacheKey, id);
        this.setVirtualETag(request, sessionId, newCacheLastModified + "-" + sessionId);
        throw new CacheStaleException(newCacheLastModified);
    }

    public Response getResponse(long lastModified, HttpServletRequest request, String sessionId) throws CacheException {
        if (configuration.getDisableResponseCache()) {
            throw new CachDisabledException();
        }
        String etag = request.getHeader("If-None-Match");
        if (etag == null) {
            throw new CacheKeyMissingException();
        }
        String[] splits = (etag = etag.replace("--gzip", "")).split("-");
        if (splits.length < 2 || !splits[1].equals(sessionId)) {
            throw new CacheKeyDifferentException();
        }
        if (splits[0].equals("" + lastModified)) {
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
        }
        throw new CacheStaleException();
    }

    public Response getResponse(String key, HttpServletRequest request) throws CacheException {
        if (configuration.getDisableResponseCache()) {
            throw new CachDisabledException();
        }
        if (key == null) {
            throw new CacheKeyMissingException();
        }
        String etag = request.getHeader("If-None-Match");
        if (etag == null) {
            throw new CacheKeyMissingException();
        }
        if ((etag = etag.replace("--gzip", "")).equals(key)) {
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
        }
        throw new CacheStaleException();
    }

    @Override
    public void close() throws IOException {
        cache = null;
    }
}

