/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.security;

import com.github.windpapi4j.WinDPAPI;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.Encryptor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class WinDPAPIEncyptor
extends Encryptor {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WinDPAPIEncyptor.class);
    WinDPAPI winDPAPI;
    private boolean localMachine;

    public WinDPAPIEncyptor() {
        this(false);
    }

    public WinDPAPIEncyptor(boolean localMachine) {
        this.localMachine = localMachine;
        try {
            LOGGER.info("Initializing WinDPAPI");
            this.winDPAPI = localMachine ? WinDPAPI.newInstance((WinDPAPI.CryptProtectFlag[])new WinDPAPI.CryptProtectFlag[]{WinDPAPI.CryptProtectFlag.CRYPTPROTECT_UI_FORBIDDEN, WinDPAPI.CryptProtectFlag.CRYPTPROTECT_LOCAL_MACHINE}) : WinDPAPI.newInstance((WinDPAPI.CryptProtectFlag[])new WinDPAPI.CryptProtectFlag[]{WinDPAPI.CryptProtectFlag.CRYPTPROTECT_UI_FORBIDDEN});
        }
        catch (Exception e) {
            LOGGER.error("Cannot initialize WinDPAPI", e);
        }
    }

    @Override
    public String encrypt(String message) throws IOException {
        if (message == null) {
            return null;
        }
        if (message.length() == 0) {
            return "";
        }
        try {
            byte[] clearTextBytes = message.getBytes(StandardCharsets.UTF_8);
            byte[] cipherTextBytes = this.winDPAPI.protectData(clearTextBytes);
            return Base64.getEncoder().encodeToString(cipherTextBytes);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public String decrypt(String encryptedMessage) throws IOException {
        if (encryptedMessage == null) {
            return null;
        }
        if (encryptedMessage.length() == 0) {
            return "";
        }
        try {
            byte[] cipherTextBytes = Base64.getDecoder().decode(encryptedMessage);
            byte[] decryptedBytes = this.winDPAPI.unprotectData(cipherTextBytes);
            String decryptedMessage = new String(decryptedBytes, StandardCharsets.UTF_8);
            return decryptedMessage;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

