/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.ui;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.ui.IconType;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.ui.PngIcon;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.IOUtils;

public class Icons {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Icons.class);
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");
    private static Icons instance = null;
    private Map<String, Icon> extensionIcons = new HashMap<String, Icon>();
    private Map<Integer, Map<IconType, Icon>> icons = new HashMap<Integer, Map<IconType, Icon>>();
    private Map<IconType, String> iconURLs = new HashMap<IconType, String>();
    private static final int[] sizes = new int[]{0, 16, 18, 80};
    private final transient Map<String, IconType> operationIcons = new HashMap<String, IconType>();

    private Icons() {
        this.initializeOperationIcons();
        this.initalizeIconImages();
    }

    public Map<String, IconType> getOperationIcons() {
        return this.operationIcons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initalizeIconImages() {
        LOGGER.info("Initializing icons");
        this.iconURLs.put(IconType.ADD_EVIDENCE, "/icons/EvidenceAdd.svg");
        this.iconURLs.put(IconType.EVIDENCE, "/icons/Evidence.svg");
        this.iconURLs.put(IconType.ADD_EVIDENCE_REPOSITORY, "/icons/EvidenceRepositoryAdd.svg");
        this.iconURLs.put(IconType.RESCAN_EVIDENCE_REPOSITORIES, "/icons/EvidenceRepositoryRescan.svg");
        this.iconURLs.put(IconType.TAG, "/icons/TagAdd.svg");
        this.iconURLs.put(IconType.UNTAG, "/icons/TagRemove.svg");
        this.iconURLs.put(IconType.ASSIGN_CUSTODIAN, "/icons/CustodianAdd.svg");
        this.iconURLs.put(IconType.CONFIGURE_PARAMETERS, "/icons/Configuration.svg");
        this.iconURLs.put(IconType.CONFIGURE_NUIX, "/icons/ConfigureNuix.svg");
        this.iconURLs.put(IconType.ADD_TO_PRODUCTION_SET, "/icons/ProductionSetAdd.svg");
        this.iconURLs.put(IconType.DELETE_PRODUCTION_SET, "/icons/ProductionSetDelete.svg");
        this.iconURLs.put(IconType.ADD_ITEMS_TO_DIGEST_LIST, "/icons/HashAdd.svg");
        this.iconURLs.put(IconType.REMOVE_ITEMS_FROM_DIGEST_LIST, "/icons/HashRemove.svg");
        this.iconURLs.put(IconType.MANAGE_DIGEST_LISTS, "/icons/HashSettings.svg");
        this.iconURLs.put(IconType.DELETE_DIGEST_LIST, "/icons/HashDelete.svg");
        this.iconURLs.put(IconType.DIGEST_LIST_EXPORT, "/icons/HashExport.svg");
        this.iconURLs.put(IconType.DIGEST_LIST_IMPORT, "/icons/HashImport.svg");
        this.iconURLs.put(IconType.EXCLUDE, "/icons/ExclusionAdd.svg");
        this.iconURLs.put(IconType.INCLUDE, "/icons/ExclusionRemove.svg");
        this.iconURLs.put(IconType.EXPORT, "/icons/PackageExport.svg");
        this.iconURLs.put(IconType.ADD_TO_ITEM_SET, "/icons/ItemSetAdd.svg");
        this.iconURLs.put(IconType.REMOVE_FROM_ITEM_SET, "/icons/ItemSetRemove.svg");
        this.iconURLs.put(IconType.DELETE_ITEM_SET, "/icons/ItemSetDelete.svg");
        this.iconURLs.put(IconType.RELOAD_ITEMS, "/icons/EvidenceReload.svg");
        this.iconURLs.put(IconType.REPLACE_ITEMS, "/icons/EvidenceReplace.svg");
        this.iconURLs.put(IconType.DELETE_ITEMS, "/icons/EvidenceDelete.svg");
        this.iconURLs.put(IconType.ADD_ITEMS_TO_CLUSTER_RUN, "/icons/ClusterAdd.svg");
        this.iconURLs.put(IconType.POPULATE_ALL_ALTERNATE_FIELDS, "/icons/Link.svg");
        this.iconURLs.put(IconType.DATE_RANGE_FILTER, "/icons/Calendar.svg");
        this.iconURLs.put(IconType.OCR, "/icons/Ocr.svg");
        this.iconURLs.put(IconType.OCR_CONFIGURATION, "/icons/OcrConfiguration.svg");
        this.iconURLs.put(IconType.REMOVE_TEXT, "/icons/OcrRemove.svg");
        this.iconURLs.put(IconType.REPLACE_TEXT, "/icons/OcrReplace.svg");
        this.iconURLs.put(IconType.REDACT_TEXT, "/icons/OcrRedact.svg");
        this.iconURLs.put(IconType.REPORT, "/icons/Report.svg");
        this.iconURLs.put(IconType.MARKDOWN_REPORT, "/icons/ReportMarkdown.svg");
        this.iconURLs.put(IconType.NOTIFY, "/icons/Notify.svg");
        this.iconURLs.put(IconType.EMAIL_ADDRESS, "/icons/EmailAt.svg");
        this.iconURLs.put(IconType.SCRIPT_GENERIC, "/icons/Run.svg");
        this.iconURLs.put(IconType.POWERSHELL, "/icons/PowerShell.svg");
        this.iconURLs.put(IconType.CALL_API, "/icons/CallApi.svg");
        this.iconURLs.put(IconType.RUN_EXTERNAL_APPLICATION, "/icons/Run.svg");
        this.iconURLs.put(IconType.SWITCH_LICENCE, "/icons/LicenceSwitch.svg");
        this.iconURLs.put(IconType.METADATA_REMOVE, "/icons/MetadataRemove.svg");
        this.iconURLs.put(IconType.METADATA_IMPORT, "/icons/MetadataImport.svg");
        this.iconURLs.put(IconType.METADATA_EXPORT, "/icons/MetadataExport.svg");
        this.iconURLs.put(IconType.METADATA_TO_SQL, "/icons/MetadataToSql.svg");
        this.iconURLs.put(IconType.SQL_COMMAND, "/icons/SqlCommand.svg");
        this.iconURLs.put(IconType.METADATA_FROM_SQL, "/icons/MetadataFromSql.svg");
        this.iconURLs.put(IconType.EXPORT_ITEMS, "/icons/ExportItems.svg");
        this.iconURLs.put(IconType.SEARCH, "/icons/Search.svg");
        this.iconURLs.put(IconType.LOGO, "/logo/neo_automate.svg");
        this.iconURLs.put(IconType.PRINT, "/icons/Print.svg");
        this.iconURLs.put(IconType.SIMPLE_CASE, "/icons/Case.svg");
        this.iconURLs.put(IconType.COMPOUND_CASE, "/icons/CaseCompoundAdd.svg");
        this.iconURLs.put(IconType.CASE_EXPORT, "/icons/CaseExport.svg");
        this.iconURLs.put(IconType.RELATIVITY, "/icons/Relativity.svg");
        this.iconURLs.put(IconType.RELATIVITY_PROCESS, "/icons/RelativityProcess.svg");
        this.iconURLs.put(IconType.RELATIVITY_API, "/icons/RelativityApi.svg");
        this.iconURLs.put(IconType.RELATIVITY_CLIENT, "/icons/RelativityClient.svg");
        this.iconURLs.put(IconType.RELATIVITY_CONFIGURATION, "/icons/RelativityConfiguration.svg");
        this.iconURLs.put(IconType.RELATIVITY_MATTER, "/icons/RelativityMatter.svg");
        this.iconURLs.put(IconType.RELATIVITY_METADATA, "/icons/RelativityMetadata.svg");
        this.iconURLs.put(IconType.RELATIVITY_PERMISSIONS, "/icons/RelativityPermissions.svg");
        this.iconURLs.put(IconType.RELATIVITY_PRINT, "/icons/RelativityPrint.svg");
        this.iconURLs.put(IconType.RELATIVITY_SCRIPT, "/icons/RelativityScript.svg");
        this.iconURLs.put(IconType.RELATIVITY_SEARCH, "/icons/RelativitySearch.svg");
        this.iconURLs.put(IconType.RELATIVITY_USER, "/icons/RelativityUser.svg");
        this.iconURLs.put(IconType.RELATIVITY_WORKSPACE, "/icons/RelativityWorkspace.svg");
        this.iconURLs.put(IconType.NLP, "/icons/Nlp.svg");
        this.iconURLs.put(IconType.NLP_CONFIGURE, "/icons/NlpConfiguration.svg");
        this.iconURLs.put(IconType.DISCOVER, "/icons/Discover.svg");
        this.iconURLs.put(IconType.DISCOVER_CONFIGURE, "/icons/DiscoverConfiguration.svg");
        this.iconURLs.put(IconType.WORD_LIST_EXPORT, "/icons/WordListExport.svg");
        this.iconURLs.put(IconType.FIND_ITEMS_WITH_WORDS, "/icons/FindItemsWithWords.svg");
        this.iconURLs.put(IconType.CLOSE_NUIX, "/icons/NuixClose.svg");
        this.iconURLs.put(IconType.CLOSE_CASE, "/icons/CaseClose.svg");
        this.iconURLs.put(IconType.POPULATE_BINARY_STORE, "/icons/Binary.svg");
        this.iconURLs.put(IconType.GOOGLE, "/icons/Google.svg");
        this.iconURLs.put(IconType.SCAN_STATISTICS, "/icons/ScanStatistics.svg");
        this.iconURLs.put(IconType.BRAINSPACE, "/icons/Brainspace.svg");
        this.iconURLs.put(IconType.BRAINSPACE_COMMAND, "/icons/BrainspaceCommand.svg");
        this.iconURLs.put(IconType.BRAINSPACE_IMPORT, "/icons/BrainspaceImport.svg");
        this.iconURLs.put(IconType.BRAINSPACE_EXPORT, "/icons/BrainspaceExport.svg");
        this.iconURLs.put(IconType.BRAINSPACE_SETTINGS, "/icons/BrainspaceSettings.svg");
        this.iconURLs.put(IconType.BRAINSPACE_TAG, "/icons/BrainspaceTag.svg");
        this.iconURLs.put(IconType.ELASTIC, "/icons/Elastic.svg");
        this.iconURLs.put(IconType.ELASTIC_SETTINGS, "/icons/ElasticSettings.svg");
        this.iconURLs.put(IconType.ELASTIC_EXPORT, "/icons/ElasticExport.svg");
        this.iconURLs.put(IconType.PURVIEW_CONFIGURE_CONNECTION, "/icons/PurviewConfigureConnection.svg");
        this.iconURLs.put(IconType.PURVIEW_USE_CASE, "/icons/PurviewUseCase.svg");
        this.iconURLs.put(IconType.PURVIEW_UPDATE_CASE_SETTINGS, "/icons/PurviewUpdateCaseSettings.svg");
        this.iconURLs.put(IconType.PURVIEW_MANAGE_CASE, "/icons/PurviewManageCase.svg");
        this.iconURLs.put(IconType.PURVIEW_ADD_CUSTODIAL_DATA_SOURCES, "/icons/PurviewAddCustodialDataSources.svg");
        this.iconURLs.put(IconType.PURVIEW_RELEASE_CUSTODIANS, "/icons/PurviewReleaseCustodians.svg");
        this.iconURLs.put(IconType.PURVIEW_ADD_NON_CUSTODIAL_DATA_SOURCES, "/icons/PurviewAddNonCustodialDataSources.svg");
        this.iconURLs.put(IconType.PURVIEW_RELEASE_NON_CUSTODIAL_DATA_SOURCES, "/icons/PurviewReleaseNonCustodialDataSources.svg");
        this.iconURLs.put(IconType.PURVIEW_CONVERT_CDS, "/icons/PurviewConvertCds.svg");
        this.iconURLs.put(IconType.PURVIEW_APPLY_HOLD_TO_CUSTODIANS, "/icons/PurviewApplyHoldToCustodians.svg");
        this.iconURLs.put(IconType.PURVIEW_REMOVE_HOLD_FROM_CUSTODIANS, "/icons/PurviewRemoveHoldFromCustodians.svg");
        this.iconURLs.put(IconType.PURVIEW_APPLY_HOLD_TO_NON_CUSTODIAL_DATA_SOURCES, "/icons/PurviewApplyHoldToNonCustodialDataSources.svg");
        this.iconURLs.put(IconType.PURVIEW_REMOVE_HOLD_FROM_NON_CUSTODIAL_DATA_SOURCES, "/icons/PurviewRemoveHoldFromNonCustodialDataSources.svg");
        this.iconURLs.put(IconType.PURVIEW_ADD_TO_SEARCH, "/icons/PurviewAddToSearch.svg");
        this.iconURLs.put(IconType.PURVIEW_DELETE_SEARCH, "/icons/PurviewDeleteSearch.svg");
        this.iconURLs.put(IconType.PURVIEW_ESTIMATE_SEARCH_STATISTICS, "/icons/PurviewEstimateSearchStatistics.svg");
        this.iconURLs.put(IconType.PURVIEW_EXPORT_SEARCH, "/icons/PurviewExportSearch.svg");
        this.iconURLs.put(IconType.PURVIEW_ADD_TO_REVIEW_SET, "/icons/PurviewAddToReviewSet.svg");
        this.iconURLs.put(IconType.PURVIEW_CREATE_REVIEW_SET_QUERY, "/icons/PurviewCreateReviewSetQuery.svg");
        this.iconURLs.put(IconType.PURVIEW_DELETE_REVIEW_SET_QUERY, "/icons/PurviewDeleteReviewSetQuery.svg");
        this.iconURLs.put(IconType.PURVIEW_EXPORT_REVIEW_SET, "/icons/PurviewExportReviewSet.svg");
        this.iconURLs.put(IconType.PURVIEW_SET_EXPORT, "/icons/PurviewDownloadExport.svg");
        this.iconURLs.put(IconType.PURVIEW_DOWNLOAD_EXPORT, "/icons/PurviewSetExport.svg");
        this.iconURLs.put(IconType.PURVIEW_QUERY_OBJECTS, "/icons/PurviewQueryObjects.svg");
        this.iconURLs.put(IconType.NUIX_LOGICAL_IMAGE, "/icons/NuixLogicalImage.svg");
        this.iconURLs.put(IconType.AZURE_STORAGE_ACCOUNT_CONFIGURE_CONNECTION, "/icons/AzureStorageAccountConfigureConnection.svg");
        this.iconURLs.put(IconType.AZURE_STORAGE_ACCOUNT_CREATE_CONTAINER, "/icons/AzureStorageAccountCreateContainer.svg");
        this.iconURLs.put(IconType.AZURE_STORAGE_ACCOUNT_DELETE_CONTAINER, "/icons/AzureStorageAccountDeleteContainer.svg");
        this.iconURLs.put(IconType.AZURE_STORAGE_ACCOUNT_GENERATE_SAS_TOKEN, "/icons/AzureStorageAccountGenerateSasToken.svg");
        this.iconURLs.put(IconType.AZURE_CONTAINER_DOWNLOAD, "/icons/AzureContainerDownload.svg");
        this.iconURLs.put(IconType.AZURE_CONTAINER_COPY, "/icons/AzureContainerCopy.svg");
        this.iconURLs.put(IconType.CONVERT_PURVIEW_EXPORT, "/icons/ConvertPurviewExport.svg");
        this.iconURLs.put(IconType.ECC_CONFIGURE_CONNECTION, "/icons/EccConfigureConnection.svg");
        this.iconURLs.put(IconType.ECC_SET_CASE, "/icons/EccSetCase.svg");
        this.iconURLs.put(IconType.ECC_SET_CONFIGURATION, "/icons/EccSetConfiguration.svg");
        this.iconURLs.put(IconType.ECC_DEPLOY_AGENTS, "/icons/EccDeployAgents.svg");
        this.iconURLs.put(IconType.ECC_SET_COLLECTION_SOURCES, "/icons/Ecc.svg");
        this.iconURLs.put(IconType.ECC_SUBMIT_COLLECTION, "/icons/Ecc.svg");
        this.iconURLs.put(IconType.ECC_REMOVE_AGENTS, "/icons/EccRemoveAgents.svg");
        this.iconURLs.put(IconType.VAULT_CONFIGURE_CONNECTION, "/icons/VaultConfigureConnection.svg");
        this.iconURLs.put(IconType.VAULT_SET_MATTER, "/icons/VaultSetMatter.svg");
        this.iconURLs.put(IconType.VAULT_CREATE_SAVED_QUERIES, "/icons/VaultCreateSavedQueries.svg");
        this.iconURLs.put(IconType.VAULT_EXPORT_SAVED_QUERIES, "/icons/VaultExportSavedQueries.svg");
        this.iconURLs.put(IconType.VAULT_SET_EXPORTS, "/icons/VaultSetExports.svg");
        this.iconURLs.put(IconType.VAULT_DOWNLOAD_EXPORTS, "/icons/VaultDownloadExports.svg");
        this.iconURLs.put(IconType.VAULT_ADD_HOLDS, "/icons/VaultAddHolds.svg");
        this.iconURLs.put(IconType.VAULT_REMOVE_LOCATIONS_FROM_HOLDS, "/icons/VaultRemoveLocationsFromHolds.svg");
        this.iconURLs.put(IconType.VAULT_MANAGE_MATTER, "/icons/VaultManageMatter.svg");
        this.iconURLs.put(IconType.VERITONE_CONFIGURE_CONNECTION, "/icons/VeritoneConfigureConnection.svg");
        this.iconURLs.put(IconType.VERITONE_TRANSLATE_ITEMS, "/icons/VeritoneTranslateItems.svg");
        this.iconURLs.put(IconType.VERITONE_TRANSCRIBE_ITEMS, "/icons/VeritoneTranscribeItems.svg");
        this.iconURLs.put(IconType.UNKNOWN, "/icons/Placeholder.svg");
        this.iconURLs.put(IconType.PLACEHOLDER, "/icons/Placeholder.svg");
        this.iconURLs.put(IconType.NOTES, "/icons/Notes.svg");
        this.iconURLs.put(IconType.JOB_PAUSED, "/icons/JobPaused.svg");
        this.iconURLs.put(IconType.JOB_QUEUED, "/icons/JobQueued.svg");
        this.iconURLs.put(IconType.JOB_STARTED, "/icons/JobStarted.svg");
        this.iconURLs.put(IconType.JOB_STOPPED, "/icons/JobStopped.svg");
        this.iconURLs.put(IconType.CANCELLED, "/icons/Cancelled.svg");
        this.iconURLs.put(IconType.JOB_MODIFIED, "/icons/JobModified.svg");
        this.iconURLs.put(IconType.ERROR, "/icons/Error.svg");
        this.iconURLs.put(IconType.SOFT_ERROR, "/icons/SoftError.svg");
        this.iconURLs.put(IconType.SUCCESS, "/icons/Success.svg");
        this.iconURLs.put(IconType.WARNING, "/icons/Warning.svg");
        this.iconURLs.put(IconType.WARNING_RESOLVED, "/icons/WarningResolved.svg");
        this.iconURLs.put(IconType.INFO, "/icons/Info.svg");
        this.iconURLs.put(IconType.ADD_ITEMS_TO_FOLDER, "/icons/AddItemsToFolder.svg");
        this.iconURLs.put(IconType.REMOVE_ITEMS_FROM_FOLDER, "/icons/RemoveItemsFromFolder.svg");
        this.iconURLs.put(IconType.ASSIGN_FOLDERS_TO_GROUP, "/icons/AssignFoldersToGroup.svg");
        this.iconURLs.put(IconType.GRAPH_CONFIGURE, "/icons/GraphConfigure.svg");
        this.iconURLs.put(IconType.GRAPH_PROMOTE, "/icons/GraphPromote.svg");
        this.iconURLs.put(IconType.GRAPH, "/icons/Graph.svg");
        this.iconURLs.put(IconType.GEN_AI_CONFIGURE, "/icons/GenAiConfigure.svg");
        this.iconURLs.put(IconType.GEN_AI_PROMPT, "/icons/GenAiPrompt.svg");
        this.iconURLs.put(IconType.GEN_AI_ENTITIES, "/icons/GenAiEntities.svg");
        this.iconURLs.put(IconType.REMOVE_ENTITIES, "/icons/EntitiesRemove.svg");
        this.iconURLs.put(IconType.GEN_AI_PROMPT_DOCUMENT_SET, "/icons/GenAiPromptDocumentSet.svg");
        this.iconURLs.put(IconType.GEN_AI_TRANSCRIBE, "/icons/GenAiTranscribe.svg");
        this.iconURLs.put(IconType.GEN_AI_CHAIN, "/icons/GenAiChain.svg");
        this.iconURLs.put(IconType.GEN_AI_COUNT, "/icons/GenAiCount.svg");
        this.iconURLs.put(IconType.GEN_AI, "/icons/GenAi.svg");
        this.iconURLs.put(IconType.SEMANTIC_CONFIGURE, "/icons/SemanticConfigure.svg");
        this.iconURLs.put(IconType.SEMANTIC_SEARCH, "/icons/SemanticSearch.svg");
        this.iconURLs.put(IconType.FILE, "/icons/File.svg");
        this.iconURLs.put(IconType.FOLDER, "/icons/Folder.svg");
        this.iconURLs.put(IconType.AUTOMATE_WORKFLOW_LOGO, "/logo/neo_automate_dark.svg");
        for (IconType iconType : this.iconURLs.keySet()) {
            String iconUrl = null;
            try {
                iconUrl = this.iconURLs.get((Object)iconType);
                if (!iconUrl.endsWith(".svg")) {
                    iconUrl = "/icons/Placeholder.svg";
                }
                for (int size : sizes) {
                    PngIcon icon;
                    Icons icons = this;
                    synchronized (icons) {
                        try {
                            icon = new PngIcon(this.getClass().getResource(iconUrl.replace(".svg", ".png")), size);
                        }
                        catch (Throwable e) {
                            throw new IllegalStateException("Cannot load icon " + iconUrl, e);
                        }
                    }
                    this.icons.putIfAbsent(size, new HashMap());
                    this.icons.get(size).put(iconType, icon);
                }
            }
            catch (NullPointerException e) {
                LOGGER.info("Cannot load icon " + (Object)((Object)iconType) + " from iconUrl " + iconUrl, e);
            }
        }
    }

    private void initializeOperationIcons() {
        this.operationIcons.put(OperationAlias.CONFIGURATION.name(), IconType.CONFIGURE_PARAMETERS);
        this.operationIcons.put(OperationAlias.CONFIGURE_PARAMETERS.name(), IconType.CONFIGURE_PARAMETERS);
        this.operationIcons.put(OperationAlias.CONFIGURE_NUIX_ENGINE.name(), IconType.CONFIGURE_NUIX);
        this.operationIcons.put(OperationAlias.PLACEHOLDER.name(), IconType.PLACEHOLDER);
        this.operationIcons.put(OperationAlias.LOG.name(), IconType.NOTES);
        this.operationIcons.put(OperationAlias.ADD_EVIDENCE.name(), IconType.ADD_EVIDENCE);
        this.operationIcons.put(OperationAlias.ADD_EVIDENCE_REPOSITORY.name(), IconType.ADD_EVIDENCE_REPOSITORY);
        this.operationIcons.put(OperationAlias.ADD_ITEMS_TO_CLUSTER_RUN.name(), IconType.ADD_ITEMS_TO_CLUSTER_RUN);
        this.operationIcons.put(OperationAlias.ADD_ITEMS_TO_DIGEST_LIST.name(), IconType.ADD_ITEMS_TO_DIGEST_LIST);
        this.operationIcons.put(OperationAlias.ADD_TO_COMPOUND_CASE.name(), IconType.COMPOUND_CASE);
        this.operationIcons.put(OperationAlias.ADD_TO_ITEMSET.name(), IconType.ADD_TO_ITEM_SET);
        this.operationIcons.put(OperationAlias.ADD_TO_PRODUCTION_SET.name(), IconType.ADD_TO_PRODUCTION_SET);
        this.operationIcons.put(OperationAlias.ASSIGN_CUSTOM_METADATA.name(), IconType.METADATA_IMPORT);
        this.operationIcons.put(OperationAlias.ASSIGN_DATA_SET_METADATA.name(), IconType.METADATA_IMPORT);
        this.operationIcons.put(OperationAlias.ASSOCIATE_GOOGLE_VAULT_METADATA.name(), IconType.GOOGLE);
        this.operationIcons.put(OperationAlias.CASE_SUBSET_EXPORT.name(), IconType.CASE_EXPORT);
        this.operationIcons.put(OperationAlias.CLOSE_CASE.name(), IconType.CLOSE_CASE);
        this.operationIcons.put(OperationAlias.CLOSE_NUIX.name(), IconType.CLOSE_NUIX);
        this.operationIcons.put(OperationAlias.DATE_RANGE_FILTER.name(), IconType.DATE_RANGE_FILTER);
        this.operationIcons.put(OperationAlias.DELETE_DIGEST_LIST.name(), IconType.DELETE_DIGEST_LIST);
        this.operationIcons.put(OperationAlias.DELETE_ITEMSET.name(), IconType.DELETE_ITEM_SET);
        this.operationIcons.put(OperationAlias.DELETE_ITEMS.name(), IconType.DELETE_ITEMS);
        this.operationIcons.put(OperationAlias.DELETE_PRODUCTION_SET.name(), IconType.DELETE_PRODUCTION_SET);
        this.operationIcons.put(OperationAlias.ASSIGN_CUSTODIAN.name(), IconType.ASSIGN_CUSTODIAN);
        this.operationIcons.put(OperationAlias.DETECT_THREADING_ATTACHMENT_IMPLIED.name(), IconType.EMAIL_ADDRESS);
        this.operationIcons.put(OperationAlias.DIGEST_LIST_EXPORT.name(), IconType.DIGEST_LIST_EXPORT);
        this.operationIcons.put(OperationAlias.DIGEST_LIST_IMPORT.name(), IconType.DIGEST_LIST_IMPORT);
        this.operationIcons.put(OperationAlias.EXCLUDE_ITEMS.name(), IconType.EXCLUDE);
        this.operationIcons.put(OperationAlias.EXPORT_ITEMS.name(), IconType.EXPORT_ITEMS);
        this.operationIcons.put(OperationAlias.FILTER_EMAIL.name(), IconType.EMAIL_ADDRESS);
        this.operationIcons.put(OperationAlias.FIND_ITEMS_WITH_WORDS.name(), IconType.FIND_ITEMS_WITH_WORDS);
        this.operationIcons.put(OperationAlias.GENERATE_DOMAIN_FIELDS.name(), IconType.EMAIL_ADDRESS);
        this.operationIcons.put(OperationAlias.GENERATE_DUPLICATE_CUSTODIANS_FIELD.name(), IconType.POPULATE_ALL_ALTERNATE_FIELDS);
        this.operationIcons.put(OperationAlias.GENERATE_DUPLICATE_FIELDS.name(), IconType.POPULATE_ALL_ALTERNATE_FIELDS);
        this.operationIcons.put(OperationAlias.GENERATE_PRINTED_IMAGES.name(), IconType.PRINT);
        this.operationIcons.put(OperationAlias.INCLUDE_ITEMS.name(), IconType.INCLUDE);
        this.operationIcons.put(OperationAlias.LEGAL_EXPORT.name(), IconType.EXPORT);
        this.operationIcons.put(OperationAlias.LOGICAL_IMAGE_EXPORT.name(), IconType.EXPORT);
        this.operationIcons.put(OperationAlias.MANAGE_DIGEST_LISTS.name(), IconType.MANAGE_DIGEST_LISTS);
        this.operationIcons.put(OperationAlias.MATCH.name(), IconType.TAG);
        this.operationIcons.put(OperationAlias.METADATA_EXPORT.name(), IconType.METADATA_EXPORT);
        this.operationIcons.put(OperationAlias.METADATA_TO_SQL.name(), IconType.METADATA_TO_SQL);
        this.operationIcons.put(OperationAlias.NOTIFY.name(), IconType.NOTIFY);
        this.operationIcons.put(OperationAlias.OCR.name(), IconType.OCR);
        this.operationIcons.put(OperationAlias.NATIVE_OCR_IMAGES.name(), IconType.OCR);
        this.operationIcons.put(OperationAlias.NATIVE_OCR_ITEMS.name(), IconType.OCR);
        this.operationIcons.put(OperationAlias.GEN_AI_TRANSCRIBE_ITEMS.name(), IconType.GEN_AI_TRANSCRIBE);
        this.operationIcons.put(OperationAlias.CONFIGURE_NATIVE_OCR.name(), IconType.OCR_CONFIGURATION);
        this.operationIcons.put(OperationAlias.POPULATE_BINARY_STORE.name(), IconType.POPULATE_BINARY_STORE);
        this.operationIcons.put(OperationAlias.REPORT.name(), IconType.REPORT);
        this.operationIcons.put(OperationAlias.MARKDOWN_REPORT.name(), IconType.MARKDOWN_REPORT);
        this.operationIcons.put(OperationAlias.PROMOTE_TO_DISCOVER.name(), IconType.DISCOVER);
        this.operationIcons.put(OperationAlias.CONFIGURE_DISCOVER_CONNECTION.name(), IconType.DISCOVER_CONFIGURE);
        this.operationIcons.put(OperationAlias.DISCOVER_RETRIEVE_METADATA.name(), IconType.DISCOVER);
        this.operationIcons.put(OperationAlias.CONFIGURE_NLP_CONNECTION.name(), IconType.NLP_CONFIGURE);
        this.operationIcons.put(OperationAlias.ANALYZE_WITH_NLP.name(), IconType.NLP);
        this.operationIcons.put(OperationAlias.LIST_RELATIVITY_DOCUMENTS.name(), IconType.RELATIVITY_METADATA);
        this.operationIcons.put(OperationAlias.CREATE_RELATIVITY_FOLDERS.name(), IconType.RELATIVITY_PROCESS);
        this.operationIcons.put(OperationAlias.RELATIVITY_CSV_OVERLAY.name(), IconType.RELATIVITY_METADATA);
        this.operationIcons.put(OperationAlias.RELATIVITY_LOADFILE_UPLOAD.name(), IconType.RELATIVITY_METADATA);
        this.operationIcons.put(OperationAlias.RELATIVITY_METADATA_OVERLAY.name(), IconType.RELATIVITY_METADATA);
        this.operationIcons.put(OperationAlias.RELATIVITY_PROPERTY_QUERY.name(), IconType.RELATIVITY_METADATA);
        this.operationIcons.put(OperationAlias.CONFIGURE_RELATIVITY_CONNECTION.name(), IconType.RELATIVITY_CONFIGURATION);
        this.operationIcons.put(OperationAlias.SET_RELATIVITY_WORKSPACE.name(), IconType.RELATIVITY_WORKSPACE);
        this.operationIcons.put(OperationAlias.RELATIVITY_RUN_SCRIPT.name(), IconType.RELATIVITY_SCRIPT);
        this.operationIcons.put(OperationAlias.RELATIVITY_DELETE_SCRIPT.name(), IconType.RELATIVITY_SCRIPT);
        this.operationIcons.put(OperationAlias.RELATIVITY_ADD_SCRIPT.name(), IconType.RELATIVITY_SCRIPT);
        this.operationIcons.put(OperationAlias.RELATIVITY_SET_CLIENT.name(), IconType.RELATIVITY_CLIENT);
        this.operationIcons.put(OperationAlias.RELATIVITY_SET_MATTER.name(), IconType.RELATIVITY_MATTER);
        this.operationIcons.put(OperationAlias.RELATIVITY_CREATE_GROUP.name(), IconType.RELATIVITY_PERMISSIONS);
        this.operationIcons.put(OperationAlias.RELATIVITY_MANAGE_WORKSPACE_GROUPS.name(), IconType.RELATIVITY_PERMISSIONS);
        this.operationIcons.put(OperationAlias.RELATIVITY_CREATE_USERS.name(), IconType.RELATIVITY_USER);
        this.operationIcons.put(OperationAlias.RELATIVITY_MANAGE_USERS.name(), IconType.RELATIVITY_USER);
        this.operationIcons.put(OperationAlias.RELATIVITY_MANAGE_GROUP_USERS.name(), IconType.RELATIVITY_PERMISSIONS);
        this.operationIcons.put(OperationAlias.RELATIVITY_IMAGES_OVERLAY.name(), IconType.RELATIVITY_PRINT);
        this.operationIcons.put(OperationAlias.RELATIVITY_MANAGE_DT_SEARCH.name(), IconType.RELATIVITY_SEARCH);
        this.operationIcons.put(OperationAlias.RELATIVITY_MANAGE_ANALYTIC_INDEX.name(), IconType.RELATIVITY_SEARCH);
        this.operationIcons.put(OperationAlias.RELATIVITY_QUERY_WORKSPACE_GROUP_PERMISSIONS.name(), IconType.RELATIVITY_PERMISSIONS);
        this.operationIcons.put(OperationAlias.RELATIVITY_APPLY_WORKSPACE_GROUP_PERMISSIONS.name(), IconType.RELATIVITY_PERMISSIONS);
        this.operationIcons.put(OperationAlias.RELATIVITY_COPY_WORKSPACE_GROUP_PERMISSIONS.name(), IconType.RELATIVITY_PERMISSIONS);
        this.operationIcons.put(OperationAlias.RELATIVITY_LOAD_DYNAMIC_OBJECTS.name(), IconType.RELATIVITY_METADATA);
        this.operationIcons.put(OperationAlias.RELATIVITY_CREATE_ARM_ARCHIVE.name(), IconType.RELATIVITY_PROCESS);
        this.operationIcons.put(OperationAlias.RELATIVITY_CREATE_ARM_RESTORE.name(), IconType.RELATIVITY_PROCESS);
        this.operationIcons.put(OperationAlias.RELATIVITY_DELETE_WORKSPACE.name(), IconType.RELATIVITY_WORKSPACE);
        this.operationIcons.put(OperationAlias.RELATIVITY_RUN_SEARCH_TERM_REPORT.name(), IconType.RELATIVITY_SEARCH);
        this.operationIcons.put(OperationAlias.RELATIVITY_EXPORT_SAVED_SEARCH.name(), IconType.RELATIVITY_SEARCH);
        this.operationIcons.put(OperationAlias.RELATIVITY_CREATE_SAVED_SEARCH.name(), IconType.RELATIVITY_SEARCH);
        this.operationIcons.put(OperationAlias.RELATIVITY_QUERY_WORKSPACE_OVERWRITTEN_PERMISSION.name(), IconType.RELATIVITY_PERMISSIONS);
        this.operationIcons.put(OperationAlias.RELATIVITY_APPLY_WORKSPACE_OVERWRITTEN_PERMISSION.name(), IconType.RELATIVITY_PERMISSIONS);
        this.operationIcons.put(OperationAlias.RELATIVITY_CALL_GENERIC_API.name(), IconType.RELATIVITY_API);
        this.operationIcons.put(OperationAlias.RELATIVITY_DELETE_SAVED_SEARCH.name(), IconType.RELATIVITY_SEARCH);
        this.operationIcons.put(OperationAlias.RELATIVITY_RUN_IMAGING_SET.name(), IconType.RELATIVITY_PRINT);
        this.operationIcons.put(OperationAlias.RELATIVITY_RUN_OCR_SET.name(), IconType.RELATIVITY_PRINT);
        this.operationIcons.put(OperationAlias.RELATIVITY_DELETE_INDEX.name(), IconType.RELATIVITY_SEARCH);
        this.operationIcons.put(OperationAlias.RELATIVITY_CREATE_ANALYTICS_INDEX.name(), IconType.RELATIVITY_SEARCH);
        this.operationIcons.put(OperationAlias.RELATIVITY_RUN_SAVED_SEARCH.name(), IconType.RELATIVITY_SEARCH);
        this.operationIcons.put(OperationAlias.RELATIVITY_EXPORT_VIEW.name(), IconType.RELATIVITY_PRINT);
        this.operationIcons.put(OperationAlias.RELATIVITY_CREATE_PRODUCTION_SET.name(), IconType.RELATIVITY_PRINT);
        this.operationIcons.put(OperationAlias.RELATIVITY_RUN_PRODUCTION_SET.name(), IconType.RELATIVITY_SCRIPT);
        this.operationIcons.put(OperationAlias.CONFIGURE_ECC_CONNECTION.name(), IconType.ECC_CONFIGURE_CONNECTION);
        this.operationIcons.put(OperationAlias.SET_ECC_CASE.name(), IconType.ECC_SET_CASE);
        this.operationIcons.put(OperationAlias.SET_ECC_COLLECTION_CONFIGURATION.name(), IconType.ECC_SET_CONFIGURATION);
        this.operationIcons.put(OperationAlias.ADD_COLLECTION_SOURCES_TO_ECC_COLLECTION.name(), IconType.ECC_SET_COLLECTION_SOURCES);
        this.operationIcons.put(OperationAlias.DEPLOY_ECC_AGENTS.name(), IconType.ECC_DEPLOY_AGENTS);
        this.operationIcons.put(OperationAlias.SUBMIT_ECC_COLLECTION.name(), IconType.ECC_SUBMIT_COLLECTION);
        this.operationIcons.put(OperationAlias.REMOVE_ECC_AGENTS.name(), IconType.ECC_REMOVE_AGENTS);
        this.operationIcons.put(OperationAlias.RESOLVE_USERS_TO_COMPUTERS.name(), IconType.ECC_SUBMIT_COLLECTION);
        this.operationIcons.put(OperationAlias.QUERY_FROM_SQL.name(), IconType.METADATA_FROM_SQL);
        this.operationIcons.put(OperationAlias.REDACT_TEXT.name(), IconType.REDACT_TEXT);
        this.operationIcons.put(OperationAlias.RELOAD_ITEMS.name(), IconType.RELOAD_ITEMS);
        this.operationIcons.put(OperationAlias.REMOVE_CUSTOM_METADATA.name(), IconType.METADATA_REMOVE);
        this.operationIcons.put(OperationAlias.REMOVE_FROM_ITEMSET.name(), IconType.REMOVE_FROM_ITEM_SET);
        this.operationIcons.put(OperationAlias.REMOVE_ITEMS_FROM_DIGEST_LIST.name(), IconType.REMOVE_ITEMS_FROM_DIGEST_LIST);
        this.operationIcons.put(OperationAlias.REMOVE_TEXT.name(), IconType.REMOVE_TEXT);
        this.operationIcons.put(OperationAlias.REPLACE_ITEMS.name(), IconType.REPLACE_ITEMS);
        this.operationIcons.put(OperationAlias.REPLACE_TEXT.name(), IconType.REPLACE_TEXT);
        this.operationIcons.put(OperationAlias.RESCAN_EVIDENCE_REPOSITORIES.name(), IconType.RESCAN_EVIDENCE_REPOSITORIES);
        this.operationIcons.put(OperationAlias.RUN_EXTERNAL_APPLICATION.name(), IconType.RUN_EXTERNAL_APPLICATION);
        this.operationIcons.put(OperationAlias.SCAN_CASE_STATISTICS.name(), IconType.SCAN_STATISTICS);
        this.operationIcons.put(OperationAlias.USE_BRAINSPACE_DATASET.name(), IconType.BRAINSPACE_SETTINGS);
        this.operationIcons.put(OperationAlias.BRAINSPACE_BUILD_DATASET.name(), IconType.BRAINSPACE_COMMAND);
        this.operationIcons.put(OperationAlias.LOAD_ITEMS_TO_BRAINSPACE.name(), IconType.BRAINSPACE_EXPORT);
        this.operationIcons.put(OperationAlias.RETRIEVE_METADATA_FROM_BRAINSPACE.name(), IconType.BRAINSPACE_IMPORT);
        this.operationIcons.put(OperationAlias.PROPAGATE_TAGS_TO_BRAINSPACE.name(), IconType.BRAINSPACE_TAG);
        this.operationIcons.put(OperationAlias.ES_CONFIGURE.name(), IconType.ELASTIC_SETTINGS);
        this.operationIcons.put(OperationAlias.ES_EXPORT.name(), IconType.ELASTIC_EXPORT);
        this.operationIcons.put(OperationAlias.PURVIEW_CONFIGURE_CONNECTION.name(), IconType.PURVIEW_CONFIGURE_CONNECTION);
        this.operationIcons.put(OperationAlias.SET_PURVIEW_CASE.name(), IconType.PURVIEW_USE_CASE);
        this.operationIcons.put(OperationAlias.PURVIEW_UPDATE_CASE_SETTINGS.name(), IconType.PURVIEW_UPDATE_CASE_SETTINGS);
        this.operationIcons.put(OperationAlias.PURVIEW_MANAGE_CASE.name(), IconType.PURVIEW_MANAGE_CASE);
        this.operationIcons.put(OperationAlias.PURVIEW_ADD_CUSTODIAL_DATA_SOURCES.name(), IconType.PURVIEW_ADD_CUSTODIAL_DATA_SOURCES);
        this.operationIcons.put(OperationAlias.PURVIEW_RELEASE_CUSTODIANS.name(), IconType.PURVIEW_RELEASE_CUSTODIANS);
        this.operationIcons.put(OperationAlias.PURVIEW_ADD_NON_CUSTODIAL_DATA_SOURCES.name(), IconType.PURVIEW_ADD_NON_CUSTODIAL_DATA_SOURCES);
        this.operationIcons.put(OperationAlias.PURVIEW_RELEASE_NON_CUSTODIAL_DATA_SOURCES.name(), IconType.PURVIEW_RELEASE_NON_CUSTODIAL_DATA_SOURCES);
        this.operationIcons.put(OperationAlias.PURVIEW_APPLY_HOLD_TO_CUSTODIANS.name(), IconType.PURVIEW_APPLY_HOLD_TO_CUSTODIANS);
        this.operationIcons.put(OperationAlias.PURVIEW_REMOVE_HOLD_FROM_CUSTODIANS.name(), IconType.PURVIEW_REMOVE_HOLD_FROM_CUSTODIANS);
        this.operationIcons.put(OperationAlias.PURVIEW_APPLY_HOLD_TO_NON_CUSTODIAL_DATA_SOURCES.name(), IconType.PURVIEW_APPLY_HOLD_TO_NON_CUSTODIAL_DATA_SOURCES);
        this.operationIcons.put(OperationAlias.PURVIEW_REMOVE_HOLD_FROM_NON_CUSTODIAL_DATA_SOURCES.name(), IconType.PURVIEW_REMOVE_HOLD_FROM_NON_CUSTODIAL_DATA_SOURCES);
        this.operationIcons.put(OperationAlias.PURVIEW_ADD_TO_SEARCH.name(), IconType.PURVIEW_ADD_TO_SEARCH);
        this.operationIcons.put(OperationAlias.PURVIEW_DELETE_SEARCH.name(), IconType.PURVIEW_DELETE_SEARCH);
        this.operationIcons.put(OperationAlias.PURVIEW_ESTIMATE_SEARCH_STATISTICS.name(), IconType.PURVIEW_ESTIMATE_SEARCH_STATISTICS);
        this.operationIcons.put(OperationAlias.PURVIEW_EXPORT_SEARCH.name(), IconType.PURVIEW_EXPORT_SEARCH);
        this.operationIcons.put(OperationAlias.PURVIEW_ADD_TO_REVIEW_SET.name(), IconType.PURVIEW_ADD_TO_REVIEW_SET);
        this.operationIcons.put(OperationAlias.PURVIEW_CREATE_REVIEW_SET_QUERY.name(), IconType.PURVIEW_CREATE_REVIEW_SET_QUERY);
        this.operationIcons.put(OperationAlias.PURVIEW_DELETE_REVIEW_SET_QUERY.name(), IconType.PURVIEW_DELETE_REVIEW_SET_QUERY);
        this.operationIcons.put(OperationAlias.PURVIEW_EXPORT_REVIEW_SET.name(), IconType.PURVIEW_EXPORT_REVIEW_SET);
        this.operationIcons.put(OperationAlias.PURVIEW_SET_EXPORT.name(), IconType.PURVIEW_SET_EXPORT);
        this.operationIcons.put(OperationAlias.PURVIEW_DOWNLOAD_EXPORT.name(), IconType.PURVIEW_DOWNLOAD_EXPORT);
        this.operationIcons.put(OperationAlias.PURVIEW_QUERY_OBJECTS.name(), IconType.PURVIEW_QUERY_OBJECTS);
        this.operationIcons.put(OperationAlias.CREATE_NUIX_LOGICAL_IMAGE.name(), IconType.NUIX_LOGICAL_IMAGE);
        this.operationIcons.put(OperationAlias.CONVERT_LOADFILE_NUIX_LOGICAL_IMAGE.name(), IconType.NUIX_LOGICAL_IMAGE);
        this.operationIcons.put(OperationAlias.AZURE_STORAGE_ACCOUNT_CONFIGURE_CONNECTION.name(), IconType.AZURE_STORAGE_ACCOUNT_CONFIGURE_CONNECTION);
        this.operationIcons.put(OperationAlias.AZURE_STORAGE_ACCOUNT_CREATE_CONTAINER.name(), IconType.AZURE_STORAGE_ACCOUNT_CREATE_CONTAINER);
        this.operationIcons.put(OperationAlias.AZURE_STORAGE_ACCOUNT_DELETE_CONTAINER.name(), IconType.AZURE_STORAGE_ACCOUNT_DELETE_CONTAINER);
        this.operationIcons.put(OperationAlias.AZURE_STORAGE_ACCOUNT_GENERATE_SAS_TOKEN.name(), IconType.AZURE_STORAGE_ACCOUNT_GENERATE_SAS_TOKEN);
        this.operationIcons.put(OperationAlias.AZURE_CONTAINER_DOWNLOAD.name(), IconType.AZURE_CONTAINER_DOWNLOAD);
        this.operationIcons.put(OperationAlias.AZURE_CONTAINER_COPY.name(), IconType.AZURE_CONTAINER_COPY);
        this.operationIcons.put(OperationAlias.CONVERT_PURVIEW_CDS.name(), IconType.PURVIEW_CONVERT_CDS);
        this.operationIcons.put(OperationAlias.CONVERT_PURVIEW_ADVANCED.name(), IconType.PURVIEW_CONVERT_CDS);
        this.operationIcons.put(OperationAlias.CONVERT_PURVIEW_EXPORT.name(), IconType.CONVERT_PURVIEW_EXPORT);
        this.operationIcons.put(OperationAlias.VAULT_CONFIGURE_CONNECTION.name(), IconType.VAULT_CONFIGURE_CONNECTION);
        this.operationIcons.put(OperationAlias.VAULT_SET_MATTER.name(), IconType.VAULT_SET_MATTER);
        this.operationIcons.put(OperationAlias.VAULT_CREATE_SAVED_QUERIES.name(), IconType.VAULT_CREATE_SAVED_QUERIES);
        this.operationIcons.put(OperationAlias.VAULT_EXPORT_SAVED_QUERIES.name(), IconType.VAULT_EXPORT_SAVED_QUERIES);
        this.operationIcons.put(OperationAlias.VAULT_SET_EXPORTS.name(), IconType.VAULT_SET_EXPORTS);
        this.operationIcons.put(OperationAlias.VAULT_DOWNLOAD_EXPORTS.name(), IconType.VAULT_DOWNLOAD_EXPORTS);
        this.operationIcons.put(OperationAlias.VAULT_ADD_HOLDS.name(), IconType.VAULT_ADD_HOLDS);
        this.operationIcons.put(OperationAlias.VAULT_REMOVE_LOCATIONS_FROM_HOLDS.name(), IconType.VAULT_REMOVE_LOCATIONS_FROM_HOLDS);
        this.operationIcons.put(OperationAlias.VAULT_MANAGE_MATTER.name(), IconType.VAULT_MANAGE_MATTER);
        this.operationIcons.put(OperationAlias.VERITONE_CONFIGURE_CONNECTION.name(), IconType.VERITONE_CONFIGURE_CONNECTION);
        this.operationIcons.put(OperationAlias.VERITONE_TRANSLATE_ITEMS.name(), IconType.VERITONE_TRANSLATE_ITEMS);
        this.operationIcons.put(OperationAlias.VERITONE_TRANSCRIBE_ITEMS.name(), IconType.VERITONE_TRANSCRIBE_ITEMS);
        this.operationIcons.put(OperationAlias.SCRIPT.name(), IconType.SCRIPT_GENERIC);
        this.operationIcons.put(OperationAlias.POWER_SHELL.name(), IconType.POWERSHELL);
        this.operationIcons.put(OperationAlias.CALL_API.name(), IconType.CALL_API);
        this.operationIcons.put(OperationAlias.SEARCH_AND_ASSIGN_CUSTODIAN.name(), IconType.ASSIGN_CUSTODIAN);
        this.operationIcons.put(OperationAlias.SEARCH_AND_TAG.name(), IconType.SEARCH);
        this.operationIcons.put(OperationAlias.SQL_COMMAND.name(), IconType.SQL_COMMAND);
        this.operationIcons.put(OperationAlias.SWITCH_LICENCE.name(), IconType.SWITCH_LICENCE);
        this.operationIcons.put(OperationAlias.TAG_ITEMS.name(), IconType.TAG);
        this.operationIcons.put(OperationAlias.TREE_COUNT_SIZE_REPORT.name(), IconType.REPORT);
        this.operationIcons.put(OperationAlias.UNTAG_ITEMS.name(), IconType.UNTAG);
        this.operationIcons.put(OperationAlias.USE_CASE.name(), IconType.SIMPLE_CASE);
        this.operationIcons.put(OperationAlias.USE_DISCOVER_CASE.name(), IconType.DISCOVER);
        this.operationIcons.put(OperationAlias.WORD_LIST_EXPORT.name(), IconType.WORD_LIST_EXPORT);
        this.operationIcons.put(OperationAlias.ADD_ITEMS_TO_FOLDER.name(), IconType.ADD_ITEMS_TO_FOLDER);
        this.operationIcons.put(OperationAlias.REMOVE_ITEMS_FROM_FOLDER.name(), IconType.REMOVE_ITEMS_FROM_FOLDER);
        this.operationIcons.put(OperationAlias.ASSIGN_FOLDERS_TO_GROUP.name(), IconType.ASSIGN_FOLDERS_TO_GROUP);
        this.operationIcons.put(OperationAlias.GRAPH_CONFIGURE_CONNECTION.name(), IconType.GRAPH_CONFIGURE);
        this.operationIcons.put(OperationAlias.GRAPH_PROMOTE.name(), IconType.GRAPH_PROMOTE);
        this.operationIcons.put(OperationAlias.GEN_AI_CONFIGURE_CONNECTION.name(), IconType.GEN_AI_CONFIGURE);
        this.operationIcons.put(OperationAlias.GEN_AI_PROMPT_ON_DOCUMENTS.name(), IconType.GEN_AI_PROMPT);
        this.operationIcons.put(OperationAlias.GEN_AI_PROMPT_ON_DOCUMENT_SET.name(), IconType.GEN_AI_PROMPT_DOCUMENT_SET);
        this.operationIcons.put(OperationAlias.GEN_AI_CHAIN.name(), IconType.GEN_AI_CHAIN);
        this.operationIcons.put(OperationAlias.GEN_AI_ESTIMATE_TOKENS.name(), IconType.GEN_AI_COUNT);
        this.operationIcons.put(OperationAlias.GEN_AI_PROMPT_ON_IMAGES.name(), IconType.GEN_AI_PROMPT);
        this.operationIcons.put(OperationAlias.GEN_AI_EXTRACT_ENTITIES.name(), IconType.GEN_AI_ENTITIES);
        this.operationIcons.put(OperationAlias.REMOVE_ENTITIES.name(), IconType.REMOVE_ENTITIES);
        this.operationIcons.put(OperationAlias.SEMANTIC_CONFIGURE.name(), IconType.SEMANTIC_CONFIGURE);
        this.operationIcons.put(OperationAlias.SEMANTIC_FIND_SIMILAR_ITEMS.name(), IconType.SEMANTIC_SEARCH);
    }

    public static synchronized Icons getInstance() {
        if (instance == null) {
            instance = new Icons();
        }
        return instance;
    }

    public String getIconUrl(IconType iconType) {
        return this.iconURLs.get((Object)iconType);
    }

    public Icon getExtensionIcon(String extension) {
        if (!this.extensionIcons.containsKey(extension.toLowerCase())) {
            Icon icon = null;
            try {
                File tempFile = FileUtils.createTempFile("temp" + Long.toString(System.nanoTime()), "." + extension);
                icon = FileSystemView.getFileSystemView().getSystemIcon(tempFile);
                this.extensionIcons.put(extension.toLowerCase(), icon);
                tempFile.delete();
                return icon;
            }
            catch (IOException e) {
                LOGGER.warn("Cannot get icon for extension " + extension);
            }
        }
        return this.extensionIcons.get(extension.toLowerCase());
    }

    public Icon getMenuIcon(IconType iconType) {
        return this.getIcon(iconType, 16);
    }

    public Icon getIcon(IconType iconType) {
        return this.getIcon(iconType, 18);
    }

    public Icon getIcon(IconType iconType, int size) {
        Map<IconType, Icon> sizedIcons = this.icons.get(size);
        if (sizedIcons == null) {
            sizedIcons = this.icons.get(16);
        }
        if (sizedIcons.containsKey((Object)iconType)) {
            return sizedIcons.get((Object)iconType);
        }
        return null;
    }

    public String getImageBase64(IconType iconType) {
        return this.getImageBase64(this.iconURLs.get((Object)iconType));
    }

    public String getImageBase64(String resourceUrl) {
        String string;
        block8: {
            InputStream iconPngStream = this.getClass().getResourceAsStream(resourceUrl);
            try {
                byte[] iconByteArray = IOUtils.toByteArray((InputStream)iconPngStream);
                string = Base64.getEncoder().encodeToString(iconByteArray);
                if (iconPngStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iconPngStream != null) {
                        try {
                            iconPngStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot get base64 content for " + resourceUrl);
                    return "";
                }
            }
            iconPngStream.close();
        }
        return string;
    }
}

