/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.ui;

import com.nuix.automate.utils.general.InternationalizationUtils;
import org.apache.commons.lang.NotImplementedException;

public enum OperationAlias {
    DUMMY_OPERATION("DummyOperation"),
    ADD_EVIDENCE("AddEvidenceOperation"),
    ADD_EVIDENCE_REPOSITORY("AddEvidenceRepositoryOperation"),
    RESCAN_EVIDENCE_REPOSITORIES("RescanEvidenceRepositoriesOperation"),
    ADD_TO_COMPOUND_CASE("AddToCompoundCaseOperation"),
    ADD_ITEMS_TO_CLUSTER_RUN("AddItemsToClusterRunOperation"),
    ADD_TO_ITEMSET("AddToItemSetOperation"),
    REMOVE_FROM_ITEMSET("RemoveFromItemSetOperation"),
    DELETE_ITEMSET("DeleteItemSetOperation"),
    ADD_ITEMS_TO_DIGEST_LIST("AddItemsToDigestListOperation"),
    REMOVE_ITEMS_FROM_DIGEST_LIST("RemoveItemsFromDigestListOperation"),
    MANAGE_DIGEST_LISTS("ManageDigestListsOperation"),
    DELETE_DIGEST_LIST("DeleteDigestListOperation"),
    DIGEST_LIST_EXPORT("DigestListExportOperation"),
    DIGEST_LIST_IMPORT("DigestListImportOperation"),
    ADD_TO_PRODUCTION_SET("AddToProductionSetOperation"),
    ASSIGN_CUSTOM_METADATA("AssignCustomMetadataOperation"),
    ASSIGN_DATA_SET_METADATA("AssignDataSetMetadataOperation"),
    REMOVE_CUSTOM_METADATA("RemoveCustomMetadataOperation"),
    CONFIGURATION("Configuration"),
    CONFIGURE_PARAMETERS("ConfigurationOperation"),
    CONFIGURE_NUIX_ENGINE("ConfigureNuixOperation"),
    CLOSE_CASE("CloseCaseOperation"),
    CLOSE_NUIX("CloseNuixOperation"),
    DELETE_PRODUCTION_SET("DeleteProductionSetOperation"),
    ASSIGN_CUSTODIAN("DetectAndAssignCustodiansOperation"),
    DETECT_THREADING_ATTACHMENT_IMPLIED("DetectThreadingAttachmentImpliedOperation"),
    EXCLUDE_ITEMS("ExcludeItemsOperation"),
    INCLUDE_ITEMS("IncludeItemsOperation"),
    FILTER_EMAIL("FilterEmailsOperation"),
    GENERATE_DUPLICATE_FIELDS("GenerateDuplicateFieldsOperation"),
    POPULATE_BINARY_STORE("PopulateBinaryStoreOperation"),
    DATE_RANGE_FILTER("DateRangeFilterOperation"),
    GENERATE_DUPLICATE_CUSTODIANS_FIELD("GenerateDuplicateCustodiansFieldOperation"),
    GENERATE_DOMAIN_FIELDS("GenerateDomainFieldsOperation"),
    GENERATE_PRINTED_IMAGES("GeneratePrintedImagesOperation"),
    CONFIGURE_NLP_CONNECTION("ConfigureNlpConnectionOperation"),
    ANALYZE_WITH_NLP("AnalyseWithNlpOperation"),
    CONFIGURE_DISCOVER_CONNECTION("ConfigureDiscoverConnectionOperation"),
    USE_DISCOVER_CASE("UseDiscoverCaseOperation"),
    PROMOTE_TO_DISCOVER("PromoteToDiscoverOperation"),
    DISCOVER_RETRIEVE_METADATA("DiscoverRetrieveMetadataOperation"),
    CONFIGURE_ECC_CONNECTION("ConfigureEccConnectionOperation"),
    SET_ECC_CASE("SetEccCaseOperation"),
    SET_ECC_COLLECTION_CONFIGURATION("SetEccCollectionConfiguration"),
    ADD_COLLECTION_SOURCES_TO_ECC_COLLECTION("AddCollectionSourcesToEccCollectionOperation"),
    DEPLOY_ECC_AGENTS("DeployEccAgentsOperation"),
    SUBMIT_ECC_COLLECTION("SubmitEccCollectionOperation"),
    REMOVE_ECC_AGENTS("RemoveEccAgentsOperation"),
    RESOLVE_USERS_TO_COMPUTERS("ResolveUsersToComputersOperation"),
    PURVIEW_CONFIGURE_CONNECTION("PurviewConfigureConnectionOperation"),
    SET_PURVIEW_CASE("PurviewUseCaseOperation"),
    PURVIEW_UPDATE_CASE_SETTINGS("PurviewUpdateCaseSettingsOperation"),
    PURVIEW_MANAGE_CASE("PurviewManageCaseOperation"),
    PURVIEW_ADD_CUSTODIAL_DATA_SOURCES("PurviewAddCustodialDataSourcesOperation"),
    PURVIEW_RELEASE_CUSTODIANS("PurviewReleaseCustodiansOperation"),
    PURVIEW_ADD_NON_CUSTODIAL_DATA_SOURCES("PurviewAddNonCustodialDataSourcesOperation"),
    PURVIEW_RELEASE_NON_CUSTODIAL_DATA_SOURCES("PurviewReleaseNonCustodialDataSourcesOperation"),
    PURVIEW_APPLY_HOLD_TO_CUSTODIANS("PurviewApplyHoldToCustodiansOperation"),
    PURVIEW_REMOVE_HOLD_FROM_CUSTODIANS("PurviewRemoveHoldFromCustodiansOperation"),
    PURVIEW_APPLY_HOLD_TO_NON_CUSTODIAL_DATA_SOURCES("PurviewApplyHoldToNonCustodialDataSourcesOperation"),
    PURVIEW_REMOVE_HOLD_FROM_NON_CUSTODIAL_DATA_SOURCES("PurviewRemoveHoldFromNonCustodialDataSourcesOperation"),
    PURVIEW_ADD_TO_SEARCH("PurviewAddToSearchOperation"),
    PURVIEW_DELETE_SEARCH("PurviewDeleteSearchOperation"),
    PURVIEW_ESTIMATE_SEARCH_STATISTICS("PurviewEstimateSearchStatisticsOperation"),
    PURVIEW_EXPORT_SEARCH("PurviewExportSearchOperation"),
    PURVIEW_ADD_TO_REVIEW_SET("PurviewAddToReviewSetOperation"),
    PURVIEW_CREATE_REVIEW_SET_QUERY("PurviewCreateReviewSetQueryOperation"),
    PURVIEW_DELETE_REVIEW_SET_QUERY("PurviewDeleteReviewSetQueryOperation"),
    PURVIEW_EXPORT_REVIEW_SET("PurviewExportReviewSetOperation"),
    PURVIEW_SET_EXPORT("PurviewSetExportOperation"),
    PURVIEW_DOWNLOAD_EXPORT("PurviewDownloadExportOperation"),
    PURVIEW_QUERY_OBJECTS("PurviewQueryObjectsOperation"),
    AZURE_STORAGE_ACCOUNT_CONFIGURE_CONNECTION("AzureStorageAccountConfigureConnectionOperation"),
    AZURE_STORAGE_ACCOUNT_CREATE_CONTAINER("AzureStorageAccountCreateContainerOperation"),
    AZURE_STORAGE_ACCOUNT_DELETE_CONTAINER("AzureStorageAccountDeleteContainerOperation"),
    AZURE_STORAGE_ACCOUNT_GENERATE_SAS_TOKEN("AzureStorageAccountGenerateSasTokenOperation"),
    VAULT_CONFIGURE_CONNECTION("VaultConfigureConnectionOperation"),
    VAULT_SET_MATTER("VaultSetMatterOperation"),
    VAULT_CREATE_SAVED_QUERIES("VaultCreateSavedQueriesOperation"),
    VAULT_EXPORT_SAVED_QUERIES("VaultExportSavedQueriesOperation"),
    VAULT_SET_EXPORTS("VaultSetExportsOperation"),
    VAULT_DOWNLOAD_EXPORTS("VaultDownloadExportsOperation"),
    VAULT_ADD_HOLDS("VaultAddHoldsOperation"),
    VAULT_REMOVE_LOCATIONS_FROM_HOLDS("VaultRemoveLocationsFromHoldsOperation"),
    VAULT_MANAGE_MATTER("VaultManageMatterOperation"),
    VERITONE_CONFIGURE_CONNECTION("VeritoneConfigureConnectionOperation"),
    VERITONE_TRANSLATE_ITEMS("VeritoneTranslateItemsOperation"),
    VERITONE_TRANSCRIBE_ITEMS("VeritoneTranscribeItemsOperation"),
    USE_BRAINSPACE_DATASET("UseBrainspaceDataset"),
    BRAINSPACE_BUILD_DATASET("BrainspaceBuildDataset"),
    LOAD_ITEMS_TO_BRAINSPACE("BrainspaceLoadItems"),
    RETRIEVE_METADATA_FROM_BRAINSPACE("BrainspaceRetrieveMetadata"),
    PROPAGATE_TAGS_TO_BRAINSPACE("BrainspacePropagateTagsOperation"),
    ES_CONFIGURE("ElasticSearchConfigureOperation"),
    ES_EXPORT("ElasticSearchExportOperation"),
    CONFIGURE_RELATIVITY_CONNECTION("UseRelativityWorkspaceOperation"),
    SET_RELATIVITY_WORKSPACE("RelativitySetWorkspaceOperation"),
    LIST_RELATIVITY_DOCUMENTS("ListRelativityDocumentsOperation"),
    CREATE_RELATIVITY_FOLDERS("RelativityCreateFoldersOperation"),
    RELATIVITY_METADATA_OVERLAY("RelativityMetadataOverlayOperation"),
    RELATIVITY_CSV_OVERLAY("RelativityCsvOverlayOperation"),
    RELATIVITY_LOADFILE_UPLOAD("RelativityLoadfileUploadOperation"),
    RELATIVITY_IMAGES_OVERLAY("RelativityImagesOverlayOperation"),
    RELATIVITY_PROPERTY_QUERY("RelativityPropertyQueryOperation"),
    RELATIVITY_RUN_SCRIPT("RelativityScriptOperation"),
    RELATIVITY_SET_CLIENT("RelativityCreateClientOperation"),
    RELATIVITY_SET_MATTER("RelativityCreateMatterOperation"),
    RELATIVITY_CREATE_GROUP("RelativityCreateGroupOperation"),
    RELATIVITY_DELETE_SCRIPT("RelativityDeleteScriptOperation"),
    RELATIVITY_ADD_SCRIPT("RelativityAddScriptOperation"),
    RELATIVITY_MANAGE_DT_SEARCH("RelativityDtSearchOperation"),
    RELATIVITY_MANAGE_ANALYTIC_INDEX("RelativityManageAnalyticIndexOperation"),
    RELATIVITY_MANAGE_WORKSPACE_GROUPS("RelativityManageWorkspaceGroupsOperation"),
    RELATIVITY_CREATE_USERS("RelativityCreateUsersOperation"),
    RELATIVITY_MANAGE_USERS("RelativityManageUsersOperation"),
    RELATIVITY_MANAGE_GROUP_USERS("RelativityManageGroupUsersOperation"),
    RELATIVITY_QUERY_WORKSPACE_GROUP_PERMISSIONS("RelativityQueryWorkspaceGroupPermissionsOperation"),
    RELATIVITY_APPLY_WORKSPACE_GROUP_PERMISSIONS("RelativityApplyWorkspaceGroupPermissionsOperation"),
    RELATIVITY_COPY_WORKSPACE_GROUP_PERMISSIONS("RelativityCopyWorkspaceGroupPermissionsOperation"),
    RELATIVITY_LOAD_DYNAMIC_OBJECTS("RelativityLoadCustomObjectsOperation"),
    RELATIVITY_CREATE_ARM_ARCHIVE("RelativityCreateArmArchiveOperation"),
    RELATIVITY_CREATE_ARM_RESTORE("RelativityCreateArmRestoreOperation"),
    RELATIVITY_DELETE_WORKSPACE("RelativityDeleteWorkspaceOperation"),
    RELATIVITY_RUN_SEARCH_TERM_REPORT("RelativityRunSearchTermReportOperation"),
    RELATIVITY_EXPORT_SAVED_SEARCH("RelativityExportSavedSearchOperation"),
    RELATIVITY_CREATE_SAVED_SEARCH("RelativityCreateSavedSearchOperation"),
    RELATIVITY_QUERY_WORKSPACE_OVERWRITTEN_PERMISSION("RelativityQueryWorkspaceOverwrittenPermissionsOperation"),
    RELATIVITY_APPLY_WORKSPACE_OVERWRITTEN_PERMISSION("RelativityApplyWorkspaceOverwrittenPermissionsOperation"),
    RELATIVITY_CALL_GENERIC_API("CallGenericRelativityApiOperation"),
    RELATIVITY_DELETE_SAVED_SEARCH("RelativityDeleteSavedSearchOperation"),
    RELATIVITY_RUN_IMAGING_SET("RelativityRunImagingSetOperation"),
    RELATIVITY_DELETE_INDEX("RelativityDeleteIndexOperation"),
    RELATIVITY_CREATE_ANALYTICS_INDEX("RelativityCreateAnalyticsIndexOperation"),
    RELATIVITY_RUN_SAVED_SEARCH("RelativityRunSavedSearchOperation"),
    RELATIVITY_RUN_OCR_SET("RelativityRunOcrSetOperation"),
    RELATIVITY_EXPORT_VIEW("RelativityExportViewOperation"),
    RELATIVITY_CREATE_PRODUCTION_SET("RelativityCreateProductionSetOperation"),
    RELATIVITY_RUN_PRODUCTION_SET("RelativityRunProductionSetOperation"),
    LEGAL_EXPORT("LegalExportOperation"),
    CASE_SUBSET_EXPORT("CaseSubsetExportOperation"),
    LOGICAL_IMAGE_EXPORT("LogicalImageExportOperation"),
    EXPORT_ITEMS("ExportItemsOperation"),
    METADATA_EXPORT("MetadataExportOperation"),
    METADATA_TO_SQL("MetadataToSqlOperation"),
    QUERY_FROM_SQL("QueryFromSqlOperation"),
    SQL_COMMAND("SqlCommandOperation"),
    MATCH("MatchItemsOperation"),
    NOTIFY("NotifyOperation"),
    OCR("OcrOperation"),
    NATIVE_OCR_IMAGES("NativeOcrImagesOperation"),
    GEN_AI_TRANSCRIBE_ITEMS("GenAiTranscribeItemsOperation"),
    CONFIGURE_NATIVE_OCR("ConfigureNativeOcrOperation"),
    NATIVE_OCR_ITEMS("NativeOcrItemsOperation"),
    REPORT("ProcessingReportOperation"),
    RELOAD_ITEMS("ReloadItemsOperation"),
    REPLACE_ITEMS("ReplaceItemsOperation"),
    DELETE_ITEMS("DeleteItemsOperation"),
    SCAN_CASE_STATISTICS("ScanCaseStatistics"),
    REMOVE_TEXT("RemoveTextOperation"),
    REPLACE_TEXT("ReplaceTextOperation"),
    REDACT_TEXT("RedactTextOperation"),
    SCRIPT("ScriptOperation"),
    POWER_SHELL("PowerShellOperation"),
    CALL_API("CallApiOperation"),
    RUN_EXTERNAL_APPLICATION("RunExternalApplicationOperation"),
    SEARCH_AND_ASSIGN_CUSTODIAN("SearchAndAssignCustodiansOperation"),
    SEARCH_AND_TAG("SearchAndTagOperation"),
    SWITCH_LICENCE("SwitchLicenceOperation"),
    TAG_ITEMS("TagItemsOperation"),
    UNTAG_ITEMS("UntagItemsOperation"),
    TREE_COUNT_SIZE_REPORT("TreeCountSizeReportOperation"),
    USE_CASE("UseCaseOperation"),
    PLACEHOLDER("Placeholder"),
    LOG("LogOperation"),
    MARKDOWN_REPORT("MarkdownReportOperation"),
    WORD_LIST_EXPORT("WordListExportOperation"),
    FIND_ITEMS_WITH_WORDS("FindItemsWithWordsOperation"),
    ASSOCIATE_GOOGLE_VAULT_METADATA("AssociateGoogleVaultMetadata"),
    AZURE_CONTAINER_DOWNLOAD("AzureContainerDownloadOperation"),
    AZURE_CONTAINER_COPY("AzureContainerCopyOperation"),
    CONVERT_PURVIEW_EXPORT("ConvertPurviewExportOperation"),
    CONVERT_PURVIEW_CDS("ConvertPurviewCdsOperation"),
    CONVERT_PURVIEW_ADVANCED("ConvertPurviewAdvancedOperation"),
    CONVERT_LOADFILE_NUIX_LOGICAL_IMAGE("ConvertLoadfileToNuixLogicalImageOperation"),
    CREATE_NUIX_LOGICAL_IMAGE("CreateNuixLogicalImageOperation"),
    ADD_ITEMS_TO_FOLDER("AddItemsToFolderOperation"),
    REMOVE_ITEMS_FROM_FOLDER("RemoveItemsFromFolderOperation"),
    ASSIGN_FOLDERS_TO_GROUP("AssignFoldersToGroupOperation"),
    GRAPH_CONFIGURE_CONNECTION("GraphConfigureConnectionOperation"),
    GRAPH_PROMOTE("GraphPromoteOperation"),
    GEN_AI_CONFIGURE_CONNECTION("GenAiConfigureConnectionOperation"),
    GEN_AI_PROMPT_ON_DOCUMENTS("GenAiPromptOnDocumentsOperation"),
    GEN_AI_PROMPT_ON_DOCUMENT_SET("GenAiPromptOnDocumentSetOperation"),
    GEN_AI_CHAIN("GenAiChainOperation"),
    GEN_AI_PROMPT_ON_IMAGES("GenAiPromptOnImagesOperation"),
    GEN_AI_EXTRACT_ENTITIES("GenAiExtractEntitiesOperation"),
    GEN_AI_ESTIMATE_TOKENS("GenAiEstimateTokensOperation"),
    REMOVE_ENTITIES("RemoveEntitiesOperation"),
    SEMANTIC_CONFIGURE("SemanticConfigureOperation"),
    SEMANTIC_FIND_SIMILAR_ITEMS("SemanticFindSimilarItemsOperation");

    private final String _operationName;

    private OperationAlias() {
        this._operationName = null;
        throw new NotImplementedException("OperationAlias missing operationName");
    }

    private OperationAlias(String operationName) {
        InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");
        this._operationName = iu.getString(operationName + ".Property.Name");
    }

    public static OperationAlias fromOperationName(String operationName) {
        if (operationName != null) {
            for (OperationAlias value : OperationAlias.values()) {
                if (value._operationName == null || !value._operationName.equals(operationName)) continue;
                return value;
            }
        }
        return null;
    }

    public String getAlias() {
        String[] nameSplit = this.name().split("_");
        StringBuilder camelCaseName = new StringBuilder(nameSplit[0].toLowerCase());
        for (int i = 1; i < nameSplit.length; ++i) {
            camelCaseName.append(nameSplit[i].charAt(0)).append(nameSplit[i].substring(1).toLowerCase());
        }
        return camelCaseName.toString();
    }
}

