/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Icon;

public class PngIcon
implements Icon {
    protected BufferedImage bufferedImage;
    protected int width;
    protected int height;

    public void getPngStream(OutputStream outputStream) throws IOException {
        ImageIO.write((RenderedImage)this.bufferedImage, "png", outputStream);
    }

    public PngIcon(URL url) throws IOException {
        this(url, 0);
    }

    public PngIcon(URL url, int w) throws IOException {
        this.bufferedImage = ImageIO.read(url);
        if (w != 0) {
            int newHeight = (int)((double)this.bufferedImage.getHeight() / ((double)this.bufferedImage.getWidth() / (double)w));
            this.bufferedImage = this.resize(this.bufferedImage, w, newHeight);
        }
        this.width = this.bufferedImage.getWidth();
        this.height = this.bufferedImage.getHeight();
    }

    public BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.drawImage(this.bufferedImage, x, y, null);
    }

    public Dimension2D getViewportSize() {
        return new Dimension(this.width, this.height);
    }
}

