/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.utilization;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.utilization.ActivityType;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Activity {
    private long activityPeriodEpoch;
    private long activityDuration;
    private String userId;
    private String licenseId;
    private String matterId = "";
    private ActivityType activityType;
    private String activityKey = "";

    public long getActivityPeriodEpoch() {
        return this.activityPeriodEpoch;
    }

    public void setActivityPeriodEpoch(long activityPeriodEpoch) {
        this.activityPeriodEpoch = activityPeriodEpoch;
    }

    public String getActivityPeriodDate() {
        return new DateTime(this.activityPeriodEpoch).withZone(DateTimeZone.getDefault()).toString();
    }

    public void setActivityPeriodDate(String date) {
    }

    public long getActivityDuration() {
        return this.activityDuration;
    }

    public void setActivityDuration(long activityDuration) {
        this.activityDuration = activityDuration;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ActivityType getActivityType() {
        return this.activityType;
    }

    public void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public String getMatterId() {
        if (this.matterId != null) {
            return this.matterId;
        }
        return "";
    }

    public void setMatterId(String matterId) {
        this.matterId = matterId;
    }

    public String getActivityKey() {
        if (this.activityKey != null) {
            return this.activityKey;
        }
        return "";
    }

    public void setActivityKey(String activityKey) {
        this.activityKey = activityKey;
    }

    public int hashCode() {
        int hashCode = 7;
        if (this.userId != null) {
            hashCode = this.userId.hashCode();
        }
        hashCode = hashCode * 7 + this.activityType.hashCode();
        hashCode *= 7;
        if (this.matterId != null) {
            hashCode += this.matterId.hashCode();
        }
        hashCode *= 7;
        if (this.activityKey != null) {
            hashCode += this.activityKey.hashCode();
        }
        hashCode = hashCode * 7 + (int)this.activityPeriodEpoch;
        hashCode = hashCode * 7 + (int)(this.activityDuration * 1000L);
        return hashCode;
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Activity o = (Activity)obj;
        return (this.userId == null && o.userId == null || this.userId != null && o.userId != null && this.userId.equals(o.userId)) && this.activityType.equals((Object)o.activityType) && (this.matterId == null && o.matterId == null || this.matterId != null && o.matterId != null && this.matterId.equals(o.matterId)) && (this.activityKey == null && o.activityKey == null || this.activityKey != null && o.activityKey != null && this.activityKey.equals(o.activityKey)) && this.activityPeriodEpoch == o.activityPeriodEpoch && this.activityDuration == o.activityDuration;
    }

    public String toString() {
        String onMatter = "";
        if (this.matterId != null && this.matterId.length() > 0) {
            onMatter = " on matter " + FormattingUtils.getShortId(this.matterId, 5);
        }
        return "Activity " + (Object)((Object)this.activityType) + onMatter + " by user " + this.userId + " in period " + new DateTime(this.activityPeriodEpoch).toString() + " for " + this.activityDuration + " s";
    }
}

