/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.utilization;

import com.nuix.automate.utils.general.SchedulerComponent;
import java.util.Arrays;

public enum AutomateModule {
    AUTOMATE_SCHEDULER_UI("automate-scheduler-ui", null),
    AUTOMATE_SCHEDULER_SERVICE("automate-scheduler-service", SchedulerComponent.SCHEDULER),
    AUTOMATE_SERVER_SERVICE("automate-server-service", SchedulerComponent.ENGINE_SERVER),
    AUTOMATE_ENGINE_SERVICE("automate-engine-service", SchedulerComponent.ENGINE);

    private final String value;
    private final SchedulerComponent schedulerComponent;

    private AutomateModule(String value, SchedulerComponent matchingComponent) {
        this.value = value;
        this.schedulerComponent = matchingComponent;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public SchedulerComponent getSchedulerComponent() {
        return this.schedulerComponent;
    }

    public static AutomateModule find(SchedulerComponent schedulerComponent) {
        return schedulerComponent == null ? null : (AutomateModule)Arrays.stream(AutomateModule.values()).filter(module -> schedulerComponent.equals((Object)module.getSchedulerComponent())).findFirst().orElse(null);
    }

    public static AutomateModule valueOfOrValue(String input) {
        if (input == null) {
            return null;
        }
        try {
            return AutomateModule.valueOf(input);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Arrays.stream(AutomateModule.values()).filter(module -> input.equals(module.getValue())).findFirst().orElse(null);
        }
    }
}

