/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.workflow;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.exceptions.ParameterNotDefinedException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.ComparisonOperator;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.SensitiveField;
import com.nuix.automate.utils.workflow.DisplayCondition;
import com.nuix.automate.utils.workflow.ParameterSource;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.ParameterValueMatchBy;
import com.nuix.automate.utils.workflow.RelativityCondition;
import com.nuix.automate.utils.workflow.ScriptLanguage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.text.WordUtils;

public abstract class Parameter
implements Serializable {
    private static final transient LoggerWrapper LOGGER = LogManagerUtils.getLogger(Parameter.class);
    public static String MASKED_VALUE = "**********";
    private static final Set<String> numberParameters = new HashSet<String>(Arrays.asList("{local_worker_count}", "{local_worker_memory}", "{broker_worker_count}", "{job_worker_broker_port}", "{docid_start_numbering_at}", "{docid_digits}", "{docid_family_digits}", "{box_start_at}", "{box_cycle_from}", "{box_cycle_to}", "{folder_start_at}", "{folder_cycle_from}", "{folder_cycle_to}", "{page_start_at}", "{page_cycle_from}", "{page_cycle_to}"));
    public static final String USER_PRINTABLE_SUFFIX = "_userprintable";
    @FormField(order=0)
    protected String name;
    @FormField(order=1, excludeValues={"MICROSOFT_USER_SERVICE"})
    protected ParameterType parameterType;
    @FormField(required=false, visibleOn={@OnField(name="parameterType", value={"TEXT", "SCRIPTED"})})
    protected boolean multiValue;
    @FormField(required=false, visibleOn={@OnField(name="parameterType", value={"SCRIPTED"})})
    protected boolean useLibraryFile;
    @FormField(required=false, componentType=FieldComponentType.PARAMETER_INPUT, parameterType="LIBRARY_FILE", visibleOn={@OnField(name="parameterType", value={"SCRIPTED"}), @OnField(name="useLibraryFile")})
    protected String libraryFileId;
    @FormField(visibleOn={@OnField(name="parameterType", value={"SCRIPTED"}), @OnField(name="useLibraryFile", value={"false"})})
    protected ScriptLanguage scriptLanguage;
    @FormField(required=false, visibleOn={@OnField(name="parameterType", value={"SCRIPTED"}), @OnField(name="useLibraryFile", value={"false"})}, componentType=FieldComponentType.SCRIPT_PANE, scriptLanguageField="scriptLanguage", enableOn={@OnField(name="useLibraryFile", value={"false"})})
    @SensitiveField
    protected String scriptCode;
    protected String dataRepositoryId;
    @FormField
    protected String friendlyName;
    @FormField(componentType=FieldComponentType.TEXTAREA, rowSize=2, required=false)
    protected String description;
    @FormField(required=false, label="regexFilter", visibleOn={@OnField(name="parameterType", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"SCRIPTED", "SERVER_FILE", "SERVER_FOLDER", "INTEGER", "DATE", "DATE_TIME"})})
    protected String regex;
    @FormField(required=false, visibleOn={@OnField(name="parameterType", value={"INTEGER", "DATE", "DATE_TIME"})})
    protected String min;
    @FormField(required=false, visibleOn={@OnField(name="parameterType", value={"INTEGER", "DATE", "DATE_TIME"})})
    protected String max;
    @FormField(componentType=FieldComponentType.DROPDOWN_SELECTED_LIST, allowedValuesDynamicType=DynamicValuesType.PARAMETERS, required=false, visibleOn={@OnField(name="parameterType", value={"SCRIPTED"})})
    protected Set<String> dependantParameters;
    @FormField(required=false, visibleOn={@OnField(name="parameterType", value={"SERVER_FILE"})})
    protected Set<String> allowedFileExtensions;
    @FormField(componentType=FieldComponentType.DROPDOWN_SELECTED_LIST, allowedValuesDynamicType=DynamicValuesType.IN_PLACE_DATA_REPOSITORIES, required=false, visibleOn={@OnField(name="parameterType", value={"SERVER_FILE", "SERVER_FOLDER"})})
    protected Set<String> allowedDataRepositoryIds;
    @FormField(visibleOn={@OnField(name="parameterType", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"TEXT_MASKED", "TEXT_PROTECTED", "SCRIPTED", "SERVER_FILE", "SERVER_FOLDER"})})
    protected ParameterValueMatchBy allowedValuesMatchBy;
    @FormField(required=false, visibleOn={@OnField(name="parameterType", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"TEXT_MASKED", "TEXT_PROTECTED", "SCRIPTED", "SERVER_FILE", "SERVER_FOLDER"})})
    protected Set<String> allowedValues;
    @FormField(required=false)
    protected DisplayCondition displayCondition;
    @FormField(required=false, visibleOn={@OnField(name="parameterType", value={"RELATIVITY_WORKSPACE", "RELATIVITY_MATTER", "RELATIVITY_DT_SEARCH", "RELATIVITY_WORKSPACE_FIELD", "RELATIVITY_VIEW", "RELATIVITY_FOLDER", "RELATIVITY_SAVED_SEARCH"})})
    protected RelativityCondition relativityCondition;
    protected String userDisplayableValue;
    private ParameterSource source;

    private boolean isProtected() {
        return this.name.endsWith("_password}") || this.name.endsWith("_protected}");
    }

    private boolean isMasked() {
        return this.name.endsWith("_masked}");
    }

    public boolean isEffectiveTypeMaskedOrProtected() {
        return this.getEffectiveParameterType().equals((Object)ParameterType.TEXT_MASKED) || this.getEffectiveParameterType().equals((Object)ParameterType.TEXT_PROTECTED);
    }

    public String getUserDisplayableValue(boolean unmask) {
        if (unmask) {
            return this.getUserDisplayableValue();
        }
        return this.getMaskedUserDisplayableValue();
    }

    public String getMaskedUserDisplayableValue() {
        if (this.isEffectiveTypeMaskedOrProtected()) {
            return MASKED_VALUE;
        }
        return this.getUserDisplayableValue();
    }

    public String getUserDisplayableValue() {
        return this.userDisplayableValue;
    }

    public void setUserDisplayableValue(String userDisplayableValue) {
        this.userDisplayableValue = userDisplayableValue;
    }

    public ParameterType getEffectiveParameterType() {
        if (this.parameterType != null) {
            return this.parameterType;
        }
        if (this.isProtected()) {
            return ParameterType.TEXT_PROTECTED;
        }
        if (this.isMasked()) {
            return ParameterType.TEXT_MASKED;
        }
        if (this.isLock()) {
            return ParameterType.LOCK;
        }
        if (this.isNumber()) {
            return ParameterType.INTEGER;
        }
        if (this.isBoolean()) {
            return ParameterType.BOOLEAN;
        }
        if (this.isDate()) {
            return ParameterType.DATE;
        }
        if (this.isDateTime()) {
            return ParameterType.DATE_TIME;
        }
        if (this.isDataSet()) {
            return ParameterType.DATA_SET;
        }
        if (this.isRelativityService()) {
            return ParameterType.RELATIVITY_SERVICE;
        }
        if (this.isPurviewService()) {
            return ParameterType.PURVIEW_SERVICE;
        }
        if (this.isLegalHold()) {
            return ParameterType.LEGAL_HOLD;
        }
        if (this.isAzureStorageAccount()) {
            return ParameterType.AZURE_STORAGE_ACCOUNT;
        }
        if (this.isFile()) {
            return ParameterType.LIBRARY_FILE;
        }
        return ParameterType.TEXT;
    }

    public ParameterType getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(ParameterType parameterType) {
        this.parameterType = parameterType;
    }

    private boolean isNumber() {
        return this.name.endsWith("_number}") || numberParameters.contains(this.name);
    }

    private boolean isBoolean() {
        return this.name.endsWith("_boolean}");
    }

    private boolean isDate() {
        return this.name.endsWith("_date}");
    }

    private boolean isDateTime() {
        return this.name.endsWith("_datetime}");
    }

    private boolean isDataSet() {
        return this.name.endsWith("_dataset}");
    }

    private boolean isRelativityService() {
        return this.name.endsWith("_relativity_service}");
    }

    private boolean isPurviewService() {
        return this.name.endsWith("purview_service}") || this.name.endsWith("microsoft_user_service}");
    }

    private boolean isLegalHold() {
        return this.name.endsWith("_legalhold}");
    }

    private boolean isAzureStorageAccount() {
        return this.name.endsWith("azure_storage_account");
    }

    private boolean isFile() {
        return this.name.endsWith("_file}");
    }

    private boolean isLock() {
        return this.name.endsWith("_lock}");
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFriendlyNameAndName() {
        if (this.friendlyName == null || this.friendlyName.length() == 0) {
            return this.name;
        }
        return this.friendlyName + " / " + this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public Set<String> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(Set<String> allowedValues) {
        this.allowedValues = allowedValues;
    }

    public String getValue(boolean unmask) throws ParameterException {
        if (unmask) {
            return this.getValue();
        }
        return this.getMaskedValue();
    }

    public String getMaskedValue() throws ParameterException {
        String protectedValue = this.getValue();
        if ((this.getEffectiveParameterType().equals((Object)ParameterType.TEXT_PROTECTED) || this.getEffectiveParameterType().equals((Object)ParameterType.TEXT_MASKED)) && protectedValue.length() > 0) {
            return MASKED_VALUE;
        }
        return protectedValue;
    }

    public String getValue() throws ParameterException {
        String protectedValue = this.getProtectedValue();
        if (this.isProtected() && protectedValue.length() > 0) {
            return MASKED_VALUE;
        }
        return protectedValue;
    }

    public abstract String getProtectedValue() throws ParameterNotDefinedException, ParameterException;

    public void checkIfValueIsValid(String value, long timeoutMs) throws IllegalArgumentException {
        if (this.regex == null || this.regex.trim().length() == 0) {
            return;
        }
        if (this.displayCondition == null || !this.displayCondition.getDisplayable()) {
            return;
        }
        if (this.parameterType != null && this.parameterType == ParameterType.SEPARATOR) {
            return;
        }
        try {
            if (value == null) {
                throw new IllegalArgumentException("is null.");
            }
            boolean matchesRegex = FormattingUtils.safeMatchesRegex(value, this.getRegex(), timeoutMs);
            if (!matchesRegex) {
                throw new IllegalArgumentException("does not match regex " + this.getRegex());
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.warn("Parameter " + this.name + " regex " + this.regex + " is invalid", e);
            throw new IllegalArgumentException("regex " + this.regex + " is invalid");
        }
    }

    public String getMin() {
        return this.min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public void updateMinMax(String update) {
        String[] split = update.split(":");
        String min = split[0];
        if (FormattingUtils.isInteger(min)) {
            this.setMin(min);
        } else if (min.equals("null")) {
            this.setMin(null);
        }
        if (split.length > 1) {
            String max = split[1];
            if (FormattingUtils.isInteger(max)) {
                this.setMax(max);
            } else if (max.equals("null")) {
                this.setMax(null);
            }
        }
    }

    public DisplayCondition getDisplayCondition() {
        if (this.displayCondition == null) {
            this.displayCondition = new DisplayCondition();
        }
        return this.displayCondition;
    }

    public void setDisplayCondition(DisplayCondition displayCondition) {
        this.displayCondition = displayCondition;
    }

    public RelativityCondition getRelativityCondition() {
        if (this.relativityCondition == null) {
            this.relativityCondition = new RelativityCondition();
        }
        return this.relativityCondition;
    }

    public void setRelativityCondition(RelativityCondition relativityCondition) {
        this.relativityCondition = relativityCondition;
    }

    public Set<String> getDependantParameters() {
        if (this.dependantParameters == null) {
            this.dependantParameters = new LinkedHashSet<String>();
        }
        return this.dependantParameters;
    }

    public void setDependantParameters(Set<String> dependantParameters) {
        this.dependantParameters = dependantParameters;
    }

    public ScriptLanguage getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(ScriptLanguage scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public String getScriptCode() {
        return this.scriptCode;
    }

    public void setScriptCode(String scriptCode) {
        this.scriptCode = scriptCode;
    }

    public boolean getMultiValue() {
        return this.multiValue;
    }

    public void setMultiValue(boolean multiValue) {
        this.multiValue = multiValue;
    }

    public boolean isUseLibraryFile() {
        return this.useLibraryFile;
    }

    public void setUseLibraryFile(boolean useLibraryFile) {
        this.useLibraryFile = useLibraryFile;
    }

    public String getLibraryFileId() {
        return this.libraryFileId;
    }

    public void setLibraryFileId(String libraryFileId) {
        this.libraryFileId = libraryFileId;
    }

    public String getDataRepositoryId() {
        return this.dataRepositoryId;
    }

    public void setDataRepositoryId(String dataRepositoryId) {
        this.dataRepositoryId = dataRepositoryId;
    }

    public Set<String> getAllowedFileExtensions() {
        return this.allowedFileExtensions;
    }

    public void setAllowedFileExtensions(Set<String> allowedFileExtensions) {
        this.allowedFileExtensions = allowedFileExtensions;
    }

    public Set<String> getAllowedDataRepositoryIds() {
        return this.allowedDataRepositoryIds;
    }

    public void setAllowedDataRepositoryIds(Set<String> allowedDataRepositoryIds) {
        this.allowedDataRepositoryIds = allowedDataRepositoryIds;
    }

    public ParameterValueMatchBy getAllowedValuesMatchBy() {
        return this.allowedValuesMatchBy;
    }

    public void setAllowedValuesMatchBy(ParameterValueMatchBy allowedValuesMatchBy) {
        this.allowedValuesMatchBy = allowedValuesMatchBy;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public void setFriendlyNameFromName() {
        this.friendlyName = this.name.replace("{", "");
        this.friendlyName = this.friendlyName.replace("_masked}", "}");
        this.friendlyName = this.friendlyName.replace("_protected}", "}");
        this.friendlyName = this.friendlyName.replace("}", "");
        this.friendlyName = this.friendlyName.replace("_", " ");
        this.friendlyName = WordUtils.capitalizeFully((String)this.friendlyName);
    }

    public static String getFriendlyNameFromName(String name) {
        String friendlyName = name.replace("{", "");
        friendlyName = friendlyName.replace("_masked}", "}");
        friendlyName = friendlyName.replace("_protected}", "}");
        friendlyName = friendlyName.replace("}", "");
        friendlyName = friendlyName.replace("_", " ");
        friendlyName = WordUtils.capitalizeFully((String)friendlyName);
        return friendlyName;
    }

    public ParameterSource getSource() {
        return this.source;
    }

    public void setSource(ParameterSource source) {
        this.source = source;
    }
}

