/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.workflow;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.Parameter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Parameters {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Parameters.class);
    private final Map<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
    private final Set<String> parametersWhiteList;

    public Parameters(Set<String> whiteList) {
        this.parametersWhiteList = whiteList;
    }

    public Parameters() {
        this(null);
    }

    public Parameter putIfNotExists(Parameter parameter) {
        Parameter previousValue = this.parameters.get(parameter.getName());
        if (previousValue == null) {
            this.put(parameter);
        }
        return previousValue;
    }

    public void put(Parameter parameter) {
        if (!this.isWhiteListed(parameter.getName())) {
            throw new RuntimeException("parameter is not whitelisted: " + parameter.getName());
        }
        String name = parameter.getName();
        if (name.length() > 1 && name.substring(1, name.length() - 1).trim().length() > 0) {
            this.parameters.put(parameter.getName(), parameter);
        } else {
            LOGGER.warn("Skipping parameter with empty name: " + parameter.getName());
        }
    }

    public boolean isWhiteListed(String parameterName) {
        if (this.parametersWhiteList != null) {
            return this.parametersWhiteList.contains(parameterName);
        }
        return true;
    }

    public Parameter get(String parameterName) {
        return this.parameters.get(parameterName);
    }

    public Set<String> getNames() {
        return this.parameters.keySet();
    }

    public Collection<Parameter> getParameters() {
        return this.parameters.values();
    }

    public Parameter remove(String name) {
        return this.parameters.remove(name);
    }
}

