/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.jar.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;

public class JarLoader {
    private static Instrumentation inst;
    private static ClassLoader addUrlThis;
    private static Method addUrlMethod;
    private static boolean loadedViaPreMain;

    private JarLoader() {
    }

    public static synchronized void addToClassPath(File jarFile) throws IOException {
        if (jarFile == null) {
            throw new NullPointerException();
        }
        if (!jarFile.exists()) {
            throw new FileNotFoundException(jarFile.getAbsolutePath());
        }
        if (!jarFile.canRead()) {
            throw new IOException("can't read jar: " + jarFile.getAbsolutePath());
        }
        if (jarFile.isDirectory()) {
            throw new IOException("not a jar: " + jarFile.getAbsolutePath());
        }
        if (inst != null) {
            inst.appendToSystemClassLoaderSearch(new JarFile(jarFile));
            return;
        }
        try {
            JarLoader.getAddUrlMethod().invoke((Object)addUrlThis, jarFile.toURI().toURL());
        }
        catch (SecurityException iae) {
            throw new RuntimeException("security model prevents access to method", iae);
        }
        catch (Throwable t) {
            throw new AssertionError("internal error", t);
        }
    }

    public static synchronized boolean isSupported() {
        try {
            return inst != null || JarLoader.getAddUrlMethod() != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static synchronized String getStrategy() {
        String strat = "none";
        if (inst != null) {
            strat = loadedViaPreMain ? "agent" : "agent (main)";
        } else {
            try {
                if (JarLoader.isSupported()) {
                    strat = "reflection";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return strat;
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        loadedViaPreMain = true;
        JarLoader.agentmain(agentArgs, instrumentation);
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        if (instrumentation == null) {
            throw new NullPointerException("instrumentation");
        }
        if (inst == null) {
            inst = instrumentation;
        }
    }

    private static Method getAddUrlMethod() {
        if (addUrlMethod == null) {
            addUrlThis = ClassLoader.getSystemClassLoader();
            if (addUrlThis instanceof URLClassLoader) {
                try {
                    Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                    method.setAccessible(true);
                    addUrlMethod = method;
                }
                catch (NoSuchMethodException nsm) {
                    throw new AssertionError();
                }
            } else {
                throw new UnsupportedOperationException("missing -javaagent:<jarpath>?");
            }
        }
        return addUrlMethod;
    }

    static {
        loadedViaPreMain = false;
    }
}

