/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.jar.utils;

import com.nuix.automate.jar.utils.JarLoader;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.TreeSet;

public class LibraryUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LibraryUtils.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private String baseFolder;
    private Set<String> nuixEngineVersions;
    private String nuixWorkstationVersion;
    private boolean whatIf;
    private boolean silent;

    public static Version getNuixEngineVersion(String location) throws IOException {
        LibraryUtils libraryUtils = new LibraryUtils(location + "/lib", "", true, true);
        Set<String> nuixVersions = libraryUtils.getNuixEngineVersions();
        if (nuixVersions.size() > 1) {
            throw new IOException(iu.getFormattedString("Engine.Error.DetectedMultipleNuixVersions", new Object[]{String.join((CharSequence)", ", nuixVersions), location}));
        }
        if (nuixVersions.size() == 0) {
            throw new IOException(iu.getFormattedString("Engine.Error.MissingNuixEngineBinaries", (Object)location));
        }
        return new Version(nuixVersions.iterator().next());
    }

    public LibraryUtils(String baseFolder, String excludeJar, boolean whatIf, boolean silent) throws IOException {
        this.baseFolder = baseFolder;
        this.nuixEngineVersions = new TreeSet<String>();
        this.addNuixFolderToClassPath(baseFolder, excludeJar);
        this.whatIf = whatIf;
        this.silent = silent;
    }

    public LibraryUtils(String baseFolder, boolean whatIf, boolean silent) throws IOException {
        this.baseFolder = baseFolder;
        this.whatIf = whatIf;
        this.silent = silent;
        this.addFolderToClassPath(baseFolder);
    }

    public LibraryUtils() throws IOException {
    }

    public void addJarToClasspath(File jarFile) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        if (!this.whatIf) {
            if (this.silent) {
                LOGGER.info("Adding file " + jarFile.getName() + " to classpath");
            }
            JarLoader.addToClassPath(jarFile);
        } else if (!this.silent) {
            LOGGER.debug("Detected file " + jarFile.getName());
        }
    }

    private void addNuixFolderToClassPath(String baseFolder, String excludeJar) throws IOException {
        Path nuixEngineFolderPath;
        if (!this.silent) {
            LOGGER.info("Searching for .jar files in " + baseFolder);
        }
        if (!Files.exists(nuixEngineFolderPath = Paths.get(baseFolder, new String[0]), new LinkOption[0])) {
            throw new IOException("Path " + nuixEngineFolderPath.toAbsolutePath().toString() + " does not exist");
        }
        try {
            File nuixEngineLib = new File(baseFolder);
            for (File jarFile : nuixEngineLib.listFiles()) {
                if (jarFile.isDirectory() || !jarFile.getName().toLowerCase().endsWith(".jar")) continue;
                if (jarFile.getName().equals(excludeJar)) {
                    if (this.silent) continue;
                    LOGGER.info("Skipping " + jarFile.getName());
                    continue;
                }
                try {
                    String[] nameSplit;
                    if (jarFile.getName().startsWith("nuix-engine-api-")) {
                        nameSplit = jarFile.getName().split("-");
                        String nuixEngineVersion = nameSplit[3].replace(".jar", "").trim();
                        this.nuixEngineVersions.add(nuixEngineVersion);
                        LOGGER.info("Found Engine version: " + nuixEngineVersion);
                    }
                    if (jarFile.getName().startsWith("nuix-investigator-") && !jarFile.getName().startsWith("nuix-investigator-api-")) {
                        nameSplit = jarFile.getName().split("-");
                        this.nuixWorkstationVersion = nameSplit[2].replace(".jar", "").trim();
                        LOGGER.info("Found Nuix Workstation version: " + this.nuixWorkstationVersion);
                    }
                    this.addJarToClasspath(jarFile);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | MalformedURLException e) {
                    LOGGER.error("Cannot add " + jarFile.getName() + " to classpath.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot process files in " + baseFolder, (Throwable)e);
        }
    }

    private void addFolderToClassPath(String baseFolder) throws IOException {
        Path folderPath;
        if (!this.silent) {
            LOGGER.info("Searching for .jar files in " + baseFolder);
        }
        if (!Files.exists(folderPath = Paths.get(baseFolder, new String[0]), new LinkOption[0])) {
            throw new IOException("Path " + folderPath.toAbsolutePath().toString() + " does not exist");
        }
        try {
            File libFolder = new File(baseFolder);
            for (File jarFile : libFolder.listFiles()) {
                if (jarFile.isDirectory() || !jarFile.getName().toLowerCase().endsWith(".jar")) continue;
                try {
                    this.addJarToClasspath(jarFile);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | MalformedURLException e) {
                    LOGGER.error("Cannot add " + jarFile.getName() + " to classpath.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot process files in " + baseFolder, (Throwable)e);
        }
    }

    public Set<String> getNuixEngineVersions() {
        return this.nuixEngineVersions;
    }

    public String getNuixWorkstationVersion() {
        return this.nuixWorkstationVersion;
    }

    public void setNuixWorkstationVersion(String nuixWorkstationVersion) {
        this.nuixWorkstationVersion = nuixWorkstationVersion;
    }
}

