/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.genai;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.genai.WrappedContent;
import com.nuix.automate.workflow.core.execution.options.genai.SourceTextLocation;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import java.util.Set;
import nuix.Item;
import nuix.MetadataItem;

public class WrappedItem
extends WrappedContent {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WrappedItem.class);
    private Item item;
    private SourceTextLocation contentLocation;
    private String metadataFieldName;
    private Set<String> contentMetadataProfileRubyFieldNames;
    private MetadataItem contentMetadataItem;

    public WrappedItem(Item item, SourceTextLocation contentLocation, String metadataFieldName, MetadataItem contentMetadataItem, Set<String> contentMetadataProfileRubyFieldNames) {
        this.item = item;
        this.contentLocation = contentLocation;
        this.metadataFieldName = metadataFieldName;
        this.contentMetadataProfileRubyFieldNames = contentMetadataProfileRubyFieldNames;
        this.contentMetadataItem = contentMetadataItem;
    }

    public Item getItem() {
        return this.item;
    }

    @Override
    public String getContent() {
        String bodyText = null;
        switch (this.contentLocation) {
            case TEXT: {
                if (this.item.getTextObject().isAvailable()) {
                    bodyText = this.item.getTextObject().toString();
                    break;
                }
                bodyText = "";
                break;
            }
            case CUSTOM_METADATA: {
                if (!this.item.getCustomMetadata().containsKey((Object)this.metadataFieldName)) {
                    bodyText = null;
                    break;
                }
                StringBuilder sb = new StringBuilder();
                ItemsUtils.getItemMetadataFieldToString(this.item, this.metadataFieldName, "", sb, Long.MAX_VALUE, "");
                bodyText = sb.toString();
                break;
            }
            case METADATA_PROFILE_FIELD: {
                try {
                    bodyText = MetadataItemUtils.evaluate(this.contentMetadataItem, this.item, this.contentMetadataProfileRubyFieldNames);
                }
                catch (Exception e) {
                    LOGGER.error("Error evaluating metadata profile field for item: " + this.item.getGuid(), (Throwable)e);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected content location: " + String.valueOf((Object)this.contentLocation));
            }
        }
        return bodyText;
    }
}

