/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.CountedEntity;
import java.util.List;
import java.util.Map;
import nuix.ItemModifier;
import nuix.ItemModifierCallback;

public class AddEntitiesModifierCallback
implements ItemModifierCallback {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddEntitiesModifierCallback.class);
    private final Map<String, List<CountedEntity>> entities;

    AddEntitiesModifierCallback(Map<String, List<CountedEntity>> entities) {
        this.entities = entities;
    }

    public void execute(ItemModifier itemModifier) {
        try {
            for (Map.Entry<String, List<CountedEntity>> entry : this.entities.entrySet()) {
                String entityType = entry.getKey();
                List<CountedEntity> entityValues = entry.getValue();
                for (CountedEntity countedEntity : entityValues) {
                    for (int i = 0; i < countedEntity.getCount(); ++i) {
                        itemModifier.addEntity(entityType, countedEntity.getValue());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot assign entities", (Throwable)e);
        }
    }
}

