/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.LocalizableEnumUtils;
import com.nuix.automate.utils.general.ZipUtils;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionSubType;
import com.nuix.automate.utils.workflow.DatasetMetadata;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionAbortRequested;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.AddEvidenceOperation;
import com.nuix.automate.workflow.core.execution.operations.DatasetOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.ProcessorMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.operations.RemoteWorkerBasedOperation;
import com.nuix.automate.workflow.core.execution.options.addevidence.LoadfileType;
import com.nuix.automate.workflow.core.execution.options.addevidence.SourceScope;
import com.nuix.automate.workflow.core.execution.options.addevidence.VaultLinkedExportIngestionMethod;
import com.nuix.automate.workflow.core.execution.options.associategooglevaultmetadata.Batch;
import com.nuix.automate.workflow.core.execution.options.associategooglevaultmetadata.Document;
import com.nuix.automate.workflow.core.execution.options.associategooglevaultmetadata.Root;
import com.nuix.automate.workflow.core.execution.options.associategooglevaultmetadata.Serializer;
import com.nuix.automate.workflow.core.execution.options.associategooglevaultmetadata.Tag;
import com.nuix.automate.workflow.core.execution.options.vault.LinkedFileStub;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.nuix.DummyParallelProcessingConfigurable;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.MicrosoftGraphUtils;
import com.nuix.automate.workflow.core.utils.nuix.NetworkSourceUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixWorkerUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import nuix.BatchLoadDetails;
import nuix.Communication;
import nuix.EvidenceContainer;
import nuix.Item;
import nuix.ItemCustomMetadataMap;
import nuix.LicenceException;
import nuix.ProcessedItem;
import nuix.ProcessingJob;
import nuix.SimpleCase;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class AddEvidenceOperationImplementation
extends ProcessorMimeTypeVolumesUtilizationOperation
implements DatasetOperation,
RemoteWorkerBasedOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddEvidenceOperation.class);
    private static final int MAX_RETRIES = 100;
    private static final String GOOGLE_VAULT_LINKED_DRIVE_EXPORT_SUFFIX = " Drive Link Export";
    private static final String EXTRACTED_SUFFIX = " Extracted";
    private static final String PLACEHOLDERS_DIR_NAME = "placeholders";
    @ExcludeFromPrintableOptions
    public boolean predefined = true;
    public String evidenceName = "Evidence 1";
    public String source = "";
    public LoadfileType loadfileType = LoadfileType.CSV;
    @ExcludeFromPrintableOptions
    public List<Object[]> customMetadata;
    public String evidenceNamePrefix;
    @ExcludeFromPrintableOptions
    public boolean omitEvidenceFolderName;
    public SourceScope sourceScope;
    public String sourceEncoding = "UTF-8";
    public String zipEncoding = "UTF-8";
    public VaultLinkedExportIngestionMethod linkedExportIngestionMethod;
    public boolean useLinkedFilePlaceholderForDuplicateFamilies;
    public boolean associateGoogleVaultMetadata;
    public int linkedFileAddAsFamilyItemLimit;
    public boolean tagDuplicateFamilies;
    public String duplicateFamilyTagName;
    private transient boolean taggedDuplicateFamilies;
    private transient Set<String> batchLoadGuids;
    public String metadataImportProfile;
    private transient String effectiveEvidenceName = "";
    private transient EvidenceContainer evidenceContainer;
    private transient boolean deduplicationSerializing = false;
    private transient boolean loadingHashes = false;
    private transient long loadedHashesCount = 0L;
    private transient AtomicInteger seenItems;
    private transient AtomicLong totalEvidenceBytesProcessed;
    private transient boolean noProgressWarningRaised = false;
    private transient boolean noProgressErrorRaised = false;
    private final transient long NO_PROGRESS_WARNING_MINUTES = 5L;
    private final transient long NO_PROGRESS_ERROR_MINUTES = 60L;
    private transient boolean isPaused;
    private transient DateTime resumedFromPauseAt;
    private transient DatasetMetadata dataSetMetadata = null;
    private transient Map<String, DatasetMetadata> dataSetsMetadata;
    private transient String utilizationScopeQuery;
    private transient long ingestionStartedEpoch;
    private transient long processingInitTimeoutMinutes;
    private transient Thread googleVaultLinkedExportsIngestionThread;
    private transient Map<String, String> googleVaultExportToLinkedExport;
    private transient Map<String, Set<String>> googleVaultExportToEvidenceContainerName;
    private transient Map<String, Map<String, Path>> googleVaultLinkedFileDocIdToRenamedFilePath;
    private transient Set<String> googleVaultLinkedFilesWithPlaceholders;
    private transient double stageId;
    private transient double stageCount;
    private transient AtomicReference<String> stageName;
    private transient AtomicInteger addedWorkerCount = new AtomicInteger(0);
    private transient Integer workerMemory = null;

    public AddEvidenceOperationImplementation() {
        this.sourceScope = SourceScope.PATH_ITEM;
        this.timeZoneId = TimeZone.getDefault().getID();
        this.customMetadata = new ArrayList<Object[]>();
    }

    @Override
    public void startTriggered() throws Exception {
        this.evidenceName = this.executionContext.evalParameters(this.evidenceName, this);
        this.metadataImportProfile = this.executionContext.evalParameters(this.metadataImportProfile, this);
        this.evidenceNamePrefix = this.executionContext.evalParameters(this.evidenceNamePrefix, this);
        this.timeZoneId = this.executionContext.evalParameters(this.timeZoneId, this);
        this.source = this.executionContext.evalParameters(this.source, this);
        this.seenItems = new AtomicInteger(0);
        this.totalEvidenceBytesProcessed = new AtomicLong(0L);
        this.batchLoadGuids = new HashSet<String>();
        this.googleVaultExportToEvidenceContainerName = new ConcurrentHashMap<String, Set<String>>();
        this.duplicateFamilyTagName = this.executionContext.evalParameters(this.duplicateFamilyTagName, this);
        this.stageName = new AtomicReference();
        this.stageId = 0.0;
        this.stageCount = 1.0;
        if (this.sourceScope == SourceScope.GOOGLE_VAULT_EXPORT) {
            this.stageCount = 2.5;
            if (this.associateGoogleVaultMetadata) {
                this.stageCount = 3.0;
            }
        }
        this.setWorkerSettings();
        NuixWorkerUtils.verifyWorkerSettings(this.executionContext, this);
        this.executionState = ExecutionState.RUNNING;
        AddEvidenceOperationImplementation currentOperation = this;
        this.processingInitTimeoutMinutes = 60L;
        try {
            this.processingInitTimeoutMinutes = this.executionContext.evalIntParameter("{processing_init_timeout_minutes}", this).intValue();
            if (this.processingInitTimeoutMinutes == 0L) {
                this.addExecutionLog(this.iu.getString("AddEvidenceOperation.Log.NoProgressTimeoutDisabled"));
            } else {
                this.addExecutionLog(this.iu.getNumeralString("AddEvidenceOperation.Log.NoProgressTimeout", this.processingInitTimeoutMinutes));
            }
        }
        catch (ParameterException | NullPointerException throwable) {
            // empty catch block
        }
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.initializeProcessingProfileBuilder();
                try {
                    if (this.sourceScope != SourceScope.PATH_CONTENTS_AS_SEPARATE_EVIDENCE && this.sourceScope != SourceScope.EVIDENCE_LISTING && this.sourceScope != SourceScope.DATASET) {
                        this.getNextEvidenceName();
                    } else {
                        this.effectiveEvidenceName = this.evidenceName;
                    }
                    LOGGER.info("Preliminary evidence name: " + this.effectiveEvidenceName);
                }
                catch (ParameterException e) {
                    LOGGER.error("Cannot get valid evidence name", (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                for (Object[] objectArray : this.customMetadata) {
                    String metadataValue = ((String)objectArray[1]).trim();
                    metadataValue = this.executionContext.evalParameters(metadataValue, currentOperation, true);
                    objectArray[1] = metadataValue;
                }
                this.setTimeZoneSettings();
                this.setLocaleSettings();
                HashMap<String, String> customMetadataMap = new HashMap<String, String>();
                for (Object[] p : this.customMetadata) {
                    String metadataName = ((String)p[0]).trim();
                    File[] metadataValue = ((String)p[1]).trim();
                    metadataValue = this.executionContext.evalParameters((String)metadataValue, currentOperation, true);
                    if (metadataName.length() + metadataValue.length() <= 0) continue;
                    customMetadataMap.put(metadataName, (String)metadataValue);
                }
                if (!this.createProcessor()) {
                    return;
                }
                if (SourceScope.usesSourcePath(this.sourceScope)) {
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.SourcePath", (Object)this.source));
                }
                this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.Scope", (Object)this.sourceScope.toString()));
                if (SourceScope.usesEvidenceName(this.sourceScope)) {
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.EvidenceName", (Object)this.evidenceName));
                } else if (this.sourceScope == SourceScope.PATH_CONTENTS_AS_SEPARATE_EVIDENCE) {
                    if (this.evidenceNamePrefix == null) {
                        this.evidenceNamePrefix = "";
                    }
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.EvidencePrefix", (Object)this.evidenceNamePrefix));
                } else if (this.sourceScope == SourceScope.DATASET) {
                    if (this.dataSetsMetadata != null) {
                        this.dataSetMetadata = this.dataSetsMetadata.get(this.source);
                    }
                    if (this.dataSetMetadata == null) {
                        this.exception = new Exception(this.iu.getFormattedString("AddEvidenceOperation.Exception.DataSetNotFound", (Object)this.source));
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    this.evidenceName = this.dataSetMetadata.getName();
                    this.getNextEvidenceName();
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.EvidenceName", (Object)this.dataSetMetadata.getName()));
                }
                if (this.sourceScope != SourceScope.EVIDENCE_LISTING) {
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.TimeZone", (Object)FormattingUtils.timeZoneIdToDisplayName((String)this.timeZoneId)));
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.SourceEncoding", (Object)this.sourceEncoding));
                    if (this.zipEncoding != null) {
                        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.ZipEncoding", (Object)this.zipEncoding));
                    }
                }
                Object var3_7 = null;
                if (SourceScope.usesSourcePath(this.sourceScope) && !new File(this.source).exists()) {
                    this.exception = new Exception(this.iu.getFormattedString("AddEvidenceOperation.Exception.PathDoesNotExist", (Object)this.source));
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                if (SourceScope.isSourceDirectory(this.sourceScope) && !new File(this.source).isDirectory()) {
                    if (this.sourceScope == SourceScope.GOOGLE_VAULT_EXPORT) {
                        this.exception = new IllegalArgumentException(this.iu.getFormattedString("AddEvidenceOperation.Warning.PathIsFile", (Object)this.sourceScope));
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    this.exception = new IllegalArgumentException(this.iu.getFormattedString("AddEvidenceOperation.Warning.PathIsFileFallingBackToDefaultScope", new Object[]{this.sourceScope, SourceScope.PATH_ITEM}));
                    this.sourceScope = SourceScope.PATH_ITEM;
                }
                if (this.sourceScope == SourceScope.PATH_CONTENTS_AS_SEPARATE_EVIDENCE) {
                    File sourceFolder = new File(this.source);
                    String requestedEvidenceName = this.evidenceNamePrefix;
                    for (File subFolder : sourceFolder.listFiles()) {
                        this.evidenceName = requestedEvidenceName;
                        LOGGER.info("Handling source file: " + subFolder.getAbsolutePath());
                        this.effectiveEvidenceName = subFolder.getName();
                        if (this.evidenceName != null && this.evidenceName.length() > 0) {
                            this.effectiveEvidenceName = this.evidenceName + this.effectiveEvidenceName;
                        }
                        if (!this.createEvidenceContainer()) {
                            return;
                        }
                        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.SubFolderEvidenceName", new Object[]{subFolder.getName(), this.effectiveEvidenceName}));
                        try {
                            if (subFolder.isDirectory()) {
                                for (File f : subFolder.listFiles()) {
                                    this.evidenceContainer.addFile(f);
                                }
                            } else {
                                this.evidenceContainer.addFile(subFolder);
                            }
                            this.evidenceContainer.setTimeZone(this.timeZoneId);
                            this.evidenceContainer.setCustomMetadata(customMetadataMap);
                        }
                        catch (FileNotFoundException e) {
                            LOGGER.error("Evidence file does not exist", (Throwable)e);
                            this.exception = new Exception(this.iu.getString("AddEvidenceOperation.Exception.EvidenceDoesNotExist"), e);
                            this.executionState = ExecutionState.ERROR;
                            return;
                        }
                        try {
                            this.evidenceContainer.save();
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot save evidence", (Throwable)e);
                            this.exception = new Exception(this.iu.getString("AddEvidenceOperation.Exception.CannotSaveEvidence"), e);
                            this.executionState = ExecutionState.ERROR;
                            return;
                        }
                    }
                } else if (this.sourceScope == SourceScope.EVIDENCE_LISTING) {
                    List lines = FileUtils.loadVariableColumnDetectFormatFile((File)new File(this.source));
                    String[] header = (String[])lines.get(0);
                    int namePos = -1;
                    int pathPos = -1;
                    int custodianPos = -1;
                    int timezonePos = -1;
                    int encodingPos = -1;
                    int zipEncodingPos = -1;
                    HashMap<String, Integer> customPropertiesPos = new HashMap<String, Integer>();
                    for (int i = 0; i < header.length; ++i) {
                        if (header[i].equalsIgnoreCase("name")) {
                            if (namePos != -1) {
                                throw new IOException(this.iu.getFormattedString("AddEvidenceOperation.Exception.ColumnFoundMultipleTimes", (Object)"Name"));
                            }
                            namePos = i;
                            LOGGER.info("Detected Name at column " + (i + 1));
                            continue;
                        }
                        if (header[i].equalsIgnoreCase("path")) {
                            if (pathPos != -1) {
                                throw new IOException(this.iu.getFormattedString("AddEvidenceOperation.Exception.ColumnFoundMultipleTimes", (Object)"Path"));
                            }
                            pathPos = i;
                            LOGGER.info("Detected Path at column " + (i + 1));
                            continue;
                        }
                        if (header[i].equalsIgnoreCase("custodian")) {
                            if (custodianPos != -1) {
                                throw new IOException(this.iu.getFormattedString("AddEvidenceOperation.Exception.ColumnFoundMultipleTimes", (Object)"Custodian"));
                            }
                            custodianPos = i;
                            LOGGER.info("Detected Custodian at column " + (i + 1));
                            continue;
                        }
                        if (header[i].equalsIgnoreCase("timezone")) {
                            if (timezonePos != -1) {
                                throw new IOException(this.iu.getFormattedString("AddEvidenceOperation.Exception.ColumnFoundMultipleTimes", (Object)"Timezone"));
                            }
                            timezonePos = i;
                            LOGGER.info("Detected Timezone at column " + (i + 1));
                            continue;
                        }
                        if (header[i].equalsIgnoreCase("encoding")) {
                            if (encodingPos != -1) {
                                throw new IOException(this.iu.getFormattedString("AddEvidenceOperation.Exception.ColumnFoundMultipleTimes", (Object)"Encoding"));
                            }
                            encodingPos = i;
                            LOGGER.info("Detected Encoding at column " + (i + 1));
                            continue;
                        }
                        if (header[i].equalsIgnoreCase("zipencoding")) {
                            if (zipEncodingPos != -1) {
                                throw new IOException(this.iu.getFormattedString("AddEvidenceOperation.Exception.ColumnFoundMultipleTimes", (Object)"ZipEncoding"));
                            }
                            zipEncodingPos = i;
                            LOGGER.info("Detected Encoding at column " + (i + 1));
                            continue;
                        }
                        if (customPropertiesPos.containsKey(header[i])) {
                            throw new IOException(this.iu.getFormattedString("AddEvidenceOperation.Exception.ColumnFoundMultipleTimes", (Object)header[i]));
                        }
                        customPropertiesPos.put(header[i], i);
                        LOGGER.info("Detected evidence metadata " + header[i] + " at column " + (i + 1));
                    }
                    if (namePos == -1) {
                        throw new IOException(this.iu.getFormattedString("AddEvidenceOperation.Exception.ColumnNotFound", (Object)"Name"));
                    }
                    if (pathPos == -1) {
                        throw new IOException(this.iu.getFormattedString("AddEvidenceOperation.Exception.ColumnNotFound", (Object)"Path"));
                    }
                    lines.remove(0);
                    for (Object[] line : lines) {
                        if (line == null || line.length == 0 || line[0] == null) continue;
                        String path = (String)line[pathPos];
                        this.effectiveEvidenceName = (String)line[namePos];
                        boolean evidenceContainerCreated = false;
                        for (int i = 0; i < 100; ++i) {
                            try {
                                this.evidenceContainer = this.processor.newEvidenceContainer(this.effectiveEvidenceName);
                                this.addExecutionLog(this.iu.getString("AddEvidenceOperation.Log.EvidenceListingSeparator"));
                                if (this.metadataImportProfile != null && this.metadataImportProfile.trim().length() > 0) {
                                    this.evidenceContainer.setMetadataImportProfileName(this.metadataImportProfile);
                                }
                                this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.EffectiveEvidenceName", (Object)this.effectiveEvidenceName));
                                this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.Path", (Object)path));
                            }
                            catch (Exception e) {
                                LOGGER.warn("Cannot use evidence container name " + this.effectiveEvidenceName, (Throwable)e);
                                this.evidenceName = this.effectiveEvidenceName;
                                this.getNextEvidenceName(true);
                                Exception exception = e;
                                continue;
                            }
                            evidenceContainerCreated = true;
                            break;
                        }
                        if (!evidenceContainerCreated) {
                            void var3_8;
                            LOGGER.error("Cannot save evidence", (Throwable)var3_8);
                            this.exception = new Exception(this.iu.getString("AddEvidenceOperation.Exception.CannotSaveEvidence"));
                            this.executionState = ExecutionState.ERROR;
                            return;
                        }
                        File evidenceFile = new File(path);
                        if (!this.omitEvidenceFolderName) {
                            this.evidenceContainer.addFile(evidenceFile);
                        } else if (!evidenceFile.isDirectory()) {
                            this.evidenceContainer.addFile(evidenceFile);
                            this.addWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.CannotOmitFolderNameItemIsFile", (Object)evidenceFile.getAbsoluteFile()));
                        } else {
                            this.addExecutionLog(this.iu.getString("AddEvidenceOperation.Log.OmitFolderName"));
                            for (File subFile : evidenceFile.listFiles()) {
                                this.evidenceContainer.addFile(subFile);
                            }
                        }
                        if (custodianPos >= 0) {
                            this.evidenceContainer.setInitialCustodian((String)line[custodianPos]);
                            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.Custodian", (Object)((String)line[custodianPos])));
                        }
                        String zipEncoding = null;
                        if (zipEncodingPos >= 0) {
                            zipEncoding = (String)line[encodingPos];
                        }
                        String encoding = null;
                        if (encodingPos >= 0) {
                            try {
                                encoding = (String)line[encodingPos];
                                this.evidenceContainer.setEncoding(encoding);
                                this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.SourceEncoding", line[encodingPos]));
                            }
                            catch (Exception e) {
                                throw new Exception(this.iu.getFormattedString("AddEvidenceOperation.Log.InvalidEncoding", (Object)((String)line[encodingPos])));
                            }
                        } else {
                            this.evidenceContainer.setEncoding(this.sourceEncoding);
                            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.EncodingDefault", (Object)Charset.forName(this.sourceEncoding).displayName(this.iu.getLocale())));
                        }
                        if (this.dataLocale != null) {
                            this.evidenceContainer.setLocale(this.dataLocale.toLanguageTag());
                        }
                        if (encoding == null || encoding.length() > 0) {
                            encoding = this.sourceEncoding;
                            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.EncodingDefault", (Object)Charset.forName(this.sourceEncoding).displayName(this.iu.getLocale())));
                        } else {
                            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.SourceEncoding", (Object)encoding));
                        }
                        if (zipEncoding != null && !zipEncoding.equals(encoding)) {
                            if (this.executionContext.nuixVersion.compareTo(new Version("8.6.0")) < 0) {
                                this.evidenceContainer.setEncoding(encoding);
                                this.addWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.CannotSetZipEncoding", new Object[]{zipEncoding, "8.6"}));
                            } else {
                                this.evidenceContainer.setEncoding(encoding, zipEncoding);
                            }
                        } else {
                            this.evidenceContainer.setEncoding(encoding);
                        }
                        if (this.dataLocale != null) {
                            this.evidenceContainer.setLocale(this.dataLocale.toLanguageTag());
                        }
                        if (timezonePos >= 0) {
                            try {
                                this.evidenceContainer.setTimeZone((String)line[timezonePos]);
                                this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.TimeZone", (Object)FormattingUtils.timeZoneIdToDisplayName((String)((String)line[timezonePos]))));
                            }
                            catch (Exception e) {
                                throw new Exception(this.iu.getFormattedString("AddEvidenceOperation.Log.InvalidTimezone", (Object)((String)line[timezonePos])));
                            }
                        } else {
                            this.evidenceContainer.setTimeZone(this.timeZoneId);
                            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.TimeZoneDefault", (Object)FormattingUtils.timeZoneIdToDisplayName((String)this.timeZoneId)));
                        }
                        HashMap<String, String> customProperties = new HashMap<String, String>();
                        customProperties.putAll(customMetadataMap);
                        for (String customPropertyName : customPropertiesPos.keySet()) {
                            String customPropertyValue = (String)line[(Integer)customPropertiesPos.get(customPropertyName)];
                            customProperties.put(customPropertyName, customPropertyValue);
                        }
                        for (String customPropertyName : customProperties.keySet()) {
                            if (customPropertiesPos.containsKey(customPropertyName)) {
                                this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.Metadata", new Object[]{customPropertyName, customProperties.get(customPropertyName)}));
                                continue;
                            }
                            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.MetadataDefault", new Object[]{customPropertyName, customProperties.get(customPropertyName)}));
                        }
                        this.evidenceContainer.setCustomMetadata(customProperties);
                        this.evidenceContainer.save();
                    }
                    this.addExecutionLog(this.iu.getString("AddEvidenceOperation.Log.EvidenceListingSeparator"));
                } else if (this.sourceScope == SourceScope.GOOGLE_VAULT_EXPORT) {
                    if (this.linkedExportIngestionMethod == null) {
                        this.linkedExportIngestionMethod = VaultLinkedExportIngestionMethod.ADD_AS_EVIDENCE_WITH_PLACEHOLDERS;
                    }
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.VaultLinkedExportIngestionMethod", (Object)LocalizableEnumUtils.getLocalizedString((Enum)this.linkedExportIngestionMethod)));
                    this.googleVaultExportToLinkedExport = new HashMap<String, String>();
                    this.googleVaultLinkedFileDocIdToRenamedFilePath = new HashMap<String, Map<String, Path>>();
                    this.googleVaultLinkedFilesWithPlaceholders = ConcurrentHashMap.newKeySet();
                    Path sourcePath = Paths.get(this.source, new String[0]);
                    try (DirectoryStream<Path> sourceDirStream = Files.newDirectoryStream(sourcePath);){
                        Iterator namePos = sourceDirStream.iterator();
                        while (namePos.hasNext()) {
                            boolean ingestionMethodRequiresExtraction;
                            Path exportPath = (Path)namePos.next();
                            if (!Files.isDirectory(exportPath, new LinkOption[0])) {
                                this.addWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.UnexpectedFileInVaultExportSourceLocation", (Object)exportPath.getFileName()));
                                continue;
                            }
                            if (exportPath.toString().endsWith(" Drive Link Export Extracted")) {
                                LOGGER.info("Skipping Google Vault Drive Link Export Extracted folder");
                                continue;
                            }
                            LOGGER.info("Handling Google Vault Export source file: " + String.valueOf(exportPath.toAbsolutePath()));
                            boolean bl = ingestionMethodRequiresExtraction = this.linkedExportIngestionMethod == VaultLinkedExportIngestionMethod.ADD_AS_CHILD_ITEM || this.linkedExportIngestionMethod == VaultLinkedExportIngestionMethod.ADD_AS_EVIDENCE_WITH_PLACEHOLDERS;
                            if (exportPath.toString().endsWith(GOOGLE_VAULT_LINKED_DRIVE_EXPORT_SUFFIX)) {
                                if (ingestionMethodRequiresExtraction) {
                                    Path extractedLinkedExportPath = exportPath.resolveSibling(String.valueOf(exportPath.getFileName()) + EXTRACTED_SUFFIX);
                                    if (Files.exists(extractedLinkedExportPath, new LinkOption[0])) {
                                        org.apache.commons.io.FileUtils.deleteDirectory((File)extractedLinkedExportPath.toFile());
                                    }
                                    this.extractAndRenameLinkedExportFiles(extractedLinkedExportPath, exportPath);
                                    if (this.linkedExportIngestionMethod != VaultLinkedExportIngestionMethod.ADD_AS_EVIDENCE_WITH_PLACEHOLDERS || this.createVaultExportEvidenceContainer(extractedLinkedExportPath, customMetadataMap)) continue;
                                    return;
                                }
                            }
                            Path linkedExportPath = exportPath.resolveSibling(exportPath.getFileName().toString() + GOOGLE_VAULT_LINKED_DRIVE_EXPORT_SUFFIX);
                            if (Files.isDirectory(linkedExportPath, new LinkOption[0])) {
                                if (ingestionMethodRequiresExtraction) {
                                    this.googleVaultExportToLinkedExport.put(exportPath.toString(), String.valueOf(linkedExportPath) + EXTRACTED_SUFFIX);
                                } else {
                                    this.googleVaultExportToLinkedExport.put(exportPath.toString(), linkedExportPath.toString());
                                }
                            } else {
                                this.googleVaultExportToLinkedExport.put(exportPath.toString(), null);
                            }
                            if (this.createVaultExportEvidenceContainer(exportPath, customMetadataMap)) continue;
                            return;
                        }
                    }
                    if (this.linkedExportIngestionMethod != VaultLinkedExportIngestionMethod.ADD_AS_EVIDENCE && this.googleVaultExportToLinkedExport.isEmpty()) {
                        this.addWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.UnexpectedGoogleVaultExportStructure", (Object)this.source));
                    }
                } else {
                    if (!this.createEvidenceContainer()) {
                        return;
                    }
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.EffectiveEvidenceName", (Object)this.effectiveEvidenceName));
                    try {
                        if (this.sourceScope == SourceScope.PATH_ITEM) {
                            this.evidenceContainer.addFile(this.source);
                        } else if (this.sourceScope == SourceScope.PATH_CONTENTS) {
                            List files = Files.list(Paths.get(this.source, new String[0])).collect(Collectors.toList());
                            for (Path file : files) {
                                LOGGER.info("Handling source file: " + file.toAbsolutePath().toString());
                                this.evidenceContainer.addFile(file.toFile());
                            }
                        } else if (this.sourceScope == SourceScope.LOADFILE) {
                            HashMap<String, Object> loadOptions = new HashMap<String, Object>();
                            switch (this.loadfileType) {
                                case CSV: {
                                    loadOptions.put("csvFile", this.source);
                                    break;
                                }
                                case IDX: {
                                    loadOptions.put("idxFile", this.source);
                                    break;
                                }
                                case CONCORDANCE: {
                                    loadOptions.put("concordanceFile", this.source);
                                    String dateFormat = "yyyy-MM-dd";
                                    try {
                                        dateFormat = this.executionContext.evalParametersIfSet("{concordance_date_format}", currentOperation);
                                        LOGGER.info("Using Concordance date format " + dateFormat);
                                        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.ConcordanceDateFormat", (Object)dateFormat));
                                    }
                                    catch (ParameterException e) {
                                        LOGGER.warn("{concordance_date_format} is not set, using default format " + dateFormat);
                                    }
                                    loadOptions.put("concordanceDateFormat", dateFormat);
                                    try {
                                        String md5Column = this.executionContext.evalParametersIfSet("{concordance_md5_column}", currentOperation);
                                        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.ConcordanceMd5Column", (Object)md5Column));
                                        loadOptions.put("concordanceMd5Column", md5Column);
                                        loadOptions.put("isReplaceGeneratedMd5", true);
                                    }
                                    catch (ParameterException parameterException) {}
                                    break;
                                }
                                case EDRM_XML: {
                                    loadOptions.put("edrmXmlFile", this.source);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unsupported loadfile type " + String.valueOf((Object)this.loadfileType));
                                }
                            }
                            this.evidenceContainer.addLoadFile(loadOptions);
                            this.evidenceContainer.setMetadataImportProfileName(this.metadataImportProfile);
                        } else if (this.sourceScope == SourceScope.DATASET) {
                            File datasetFolder = new File(this.dataSetMetadata.getBasePath());
                            if (!datasetFolder.exists() || !datasetFolder.isDirectory()) {
                                throw new FileNotFoundException("Cannot access dataset folder " + this.dataSetMetadata.getBasePath());
                            }
                            for (File subFolder : datasetFolder.listFiles()) {
                                LOGGER.info("Handling dataSet file: " + subFolder.getAbsolutePath());
                                this.evidenceContainer.addFile(subFolder);
                            }
                            customMetadataMap.put("Data Set ID", this.source);
                            customMetadataMap.put("Data Set Name", this.dataSetMetadata.getName());
                        } else if (this.sourceScope == SourceScope.S3) {
                            NetworkSourceUtils.addS3Evidence(this.executionContext, currentOperation, this.evidenceContainer);
                        } else if (this.sourceScope == SourceScope.MICROSOFT_GRAPH) {
                            MicrosoftGraphUtils.addEvidence(this.executionContext, currentOperation, this.evidenceContainer);
                        } else if (this.sourceScope == SourceScope.SHAREPOINT) {
                            NetworkSourceUtils.addSharepointEvidence(this.executionContext, currentOperation, this.evidenceContainer);
                        } else if (this.sourceScope == SourceScope.EXCHANGE) {
                            NetworkSourceUtils.addExchangeEvidence(this.executionContext, currentOperation, this.evidenceContainer);
                        } else if (this.sourceScope == SourceScope.ENTERPRISE_VAULT) {
                            NetworkSourceUtils.addEnterpriseVaultEvidence(this.executionContext, currentOperation, this.evidenceContainer);
                        } else if (this.sourceScope == SourceScope.DOCUMENTUM) {
                            NetworkSourceUtils.addDocumentumEvidence(this.executionContext, currentOperation, this.evidenceContainer);
                        } else if (this.sourceScope == SourceScope.SQL_SERVER) {
                            NetworkSourceUtils.addSqlServerEvidence(this.executionContext, currentOperation, this.evidenceContainer);
                        } else if (this.sourceScope == SourceScope.ORACLE) {
                            NetworkSourceUtils.addOracleEvidence(this.executionContext, currentOperation, this.evidenceContainer);
                        } else if (this.sourceScope == SourceScope.DROPBOX) {
                            NetworkSourceUtils.addDropboxEvidence(this.executionContext, currentOperation, this.evidenceContainer);
                        } else if (this.sourceScope == SourceScope.SLACK) {
                            NetworkSourceUtils.addSlackEvidence(this.executionContext, currentOperation, this.evidenceContainer);
                        } else if (this.sourceScope == SourceScope.SSH) {
                            NetworkSourceUtils.addSshEvidence(this.executionContext, currentOperation, this.evidenceContainer);
                        } else if (this.sourceScope == SourceScope.HISTORICAL_TWITTER) {
                            NetworkSourceUtils.addHistoricalTwitterEvidence(this.executionContext, currentOperation, this.evidenceContainer);
                        }
                        this.evidenceContainer.setTimeZone(this.timeZoneId);
                        this.evidenceContainer.setCustomMetadata(customMetadataMap);
                    }
                    catch (FileNotFoundException e) {
                        LOGGER.error("Evidence file does not exist", (Throwable)e);
                        this.exception = new Exception(this.iu.getString("AddEvidenceOperation.Exception.EvidenceDoesNotExist"), e);
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    try {
                        this.evidenceContainer.save();
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot save evidence", (Throwable)e);
                        this.exception = new Exception(this.iu.getString("AddEvidenceOperation.Exception.CannotSaveEvidence"), e);
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                }
                if (!this.startAndWaitForProcessingJob()) {
                    return;
                }
                if (this.executionState == ExecutionState.STOPPING) {
                    this.trackStopped();
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void runGoogleVaultLinkedExportIngestion() {
        try {
            this.stageId = 1.0;
            this.waitForWorkerTempFolderToClear();
            if (this.linkedExportIngestionMethod != VaultLinkedExportIngestionMethod.ADD_AS_EVIDENCE) {
                boolean containsLinkedExports = false;
                for (String linkedExportPath : this.googleVaultExportToLinkedExport.values()) {
                    if (linkedExportPath == null) continue;
                    containsLinkedExports = true;
                    break;
                }
                if (containsLinkedExports) {
                    this.stageName.set(this.iu.getString("AddEvidenceOperation.Progress.AddingChildItems"));
                    if (this.addLinkedFilesAsChildItems()) {
                        if (!this.startAndWaitForProcessingJob()) {
                            return;
                        }
                        this.handleLoadProcessingJobFinish();
                        this.waitForWorkerTempFolderToClear();
                        if (!this.googleVaultLinkedFilesWithPlaceholders.isEmpty()) {
                            this.assignGuidReferenceToPlaceholderItems();
                        }
                        if (this.taggedDuplicateFamilies) {
                            this.tagDuplicateFamilies();
                        }
                    }
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{vault_duplicate_families_tag_name}", this.duplicateFamilyTagName)));
            }
            this.stageId = 1.5;
            if (this.associateGoogleVaultMetadata) {
                this.stageName.set(this.iu.getString("AddEvidenceOperation.Progress.AssociatingMetadata"));
                Thread.sleep(30000L);
                for (String exportFolder : this.googleVaultExportToLinkedExport.keySet()) {
                    this.associateGoogleVaultExportsMetadata(exportFolder);
                }
            }
            this.stageId = 2.0;
            this.trackFinished();
        }
        catch (Exception e) {
            LOGGER.error("Error handing google vault exports", (Throwable)e);
            this.exception = new Exception(this.iu.getFormattedString("AddEvidenceOperation.Exception.CannotIngestGoogleVaultExport", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            this.executionState = ExecutionState.ERROR;
        }
    }

    private boolean addLinkedFilesAsChildItems() throws IOException {
        if (!this.createProcessor()) {
            return false;
        }
        AtomicInteger parentsAddedLinkedFiles = new AtomicInteger();
        AtomicInteger parentsAddedPlaceholderFiles = new AtomicInteger();
        ConcurrentHashMap.KeySetView duplicateItemsToTag = ConcurrentHashMap.newKeySet();
        if (this.linkedExportIngestionMethod == VaultLinkedExportIngestionMethod.ADD_AS_CHILD_ITEM) {
            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.LinkedFileAddAsFamilyItemLimit", (Object)this.linkedFileAddAsFamilyItemLimit));
            if (this.linkedFileAddAsFamilyItemLimit > 50) {
                this.addWarning(this.iu.getString("AddEvidenceOperation.Warning.LargeLinkedFileAddAsFamilyItemLimit"));
            }
        }
        for (String vaultExportFolder : this.googleVaultExportToLinkedExport.keySet()) {
            String linkedExportFolder = this.googleVaultExportToLinkedExport.get(vaultExportFolder);
            if (linkedExportFolder == null) continue;
            Path exportPath = Paths.get(vaultExportFolder, new String[0]);
            Path linkedExportPath = Paths.get(linkedExportFolder, new String[0]);
            LOGGER.info("Adding child items from Google Vault linked Drive export " + String.valueOf(linkedExportPath));
            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.ProcessingLinkedDriveFolder", (Object)linkedExportPath.getFileName()));
            Map<String, Set<Path>> rfc822MessageIdToLinkedFilePaths = this.parseLinkedExportFilePaths(exportPath, linkedExportPath);
            if (rfc822MessageIdToLinkedFilePaths == null || rfc822MessageIdToLinkedFilePaths.isEmpty()) {
                this.addWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.LinkedDriveExportDoesNotContainFileRecords", (Object)linkedExportPath));
                continue;
            }
            this.addExecutionLog(this.iu.getNumeralString("AddEvidenceOperation.Log.DetectedLinkedDriveFileRecords", (long)rfc822MessageIdToLinkedFilePaths.size()));
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            String exportItemsQuery = this.getExportItemsQuery(exportPath, false);
            if (exportItemsQuery == null) {
                this.addWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.CouldNotFindEvidenceContainersForExport", (Object)exportPath));
                continue;
            }
            Collection exportItems = this.executionContext.nuixCase.searchUnsorted(exportItemsQuery);
            LOGGER.info("Export items scope size: " + exportItems.size());
            DateTime now = DateTime.now();
            exportItems = this.executionContext.nuixUtilities.getItemUtility().sortItems(exportItems, item -> {
                Communication communication = item.getCommunication();
                if (communication != null && communication.getDateTime() != null) {
                    return communication.getDateTime();
                }
                return now;
            });
            ConcurrentHashMap messageIdToInReplyToId = new ConcurrentHashMap();
            ConcurrentHashMap<String, Set<Path>> messageIdToLinkedFilePaths = new ConcurrentHashMap<String, Set<Path>>(rfc822MessageIdToLinkedFilePaths);
            ConcurrentHashMap.KeySetView parentItemMd5s = ConcurrentHashMap.newKeySet();
            ConcurrentHashMap linkedItemAttachedCount = new ConcurrentHashMap();
            Parallel.forEachPartitioned((Partitioner)new FixedSizeChunkPartitioner((Iterable)exportItems, ItemsUtils.getPartitionerChunkSize(1000, this)), itemIterator -> {
                while (itemIterator.hasNext()) {
                    String inReplyTo;
                    if (this.stopRequested) {
                        throw new WorkflowExecutionStopRequested();
                    }
                    Item item = (Item)itemIterator.next();
                    String rfc822Id = this.getItemRfc822Id(item);
                    if (rfc822Id == null || !messageIdToLinkedFilePaths.containsKey(rfc822Id) || (inReplyTo = this.getItemInReplyTo(item)) == null) continue;
                    messageIdToInReplyToId.put(rfc822Id, inReplyTo);
                }
            }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
            Parallel.forEachPartitioned((Partitioner)new FixedSizeChunkPartitioner((Iterable)exportItems, ItemsUtils.getPartitionerChunkSize(1000, this)), itemIterator -> {
                while (itemIterator.hasNext()) {
                    boolean addAsPlaceholder;
                    if (this.stopRequested) {
                        throw new WorkflowExecutionStopRequested();
                    }
                    Item item = (Item)itemIterator.next();
                    String rfc822Id = this.getItemRfc822Id(item);
                    if (rfc822Id == null || !messageIdToLinkedFilePaths.containsKey(rfc822Id)) continue;
                    HashSet linkedFilePaths = new HashSet((Collection)messageIdToLinkedFilePaths.get(rfc822Id));
                    String inReplyTo = this.getItemInReplyTo(item);
                    while (inReplyTo != null && !linkedFilePaths.isEmpty()) {
                        Set parentFilePaths = messageIdToLinkedFilePaths.getOrDefault(inReplyTo, null);
                        if (parentFilePaths != null) {
                            linkedFilePaths.removeAll(parentFilePaths);
                        }
                        inReplyTo = messageIdToInReplyToId.getOrDefault(inReplyTo, null);
                    }
                    if (linkedFilePaths.isEmpty()) {
                        LOGGER.info("Skipping item with rfc822Id: " + rfc822Id + ", all linked drive files already exists in email chain");
                        continue;
                    }
                    boolean bl = addAsPlaceholder = this.linkedExportIngestionMethod == VaultLinkedExportIngestionMethod.ADD_AS_EVIDENCE_WITH_PLACEHOLDERS;
                    if (this.linkedExportIngestionMethod == VaultLinkedExportIngestionMethod.ADD_AS_CHILD_ITEM) {
                        boolean duplicate;
                        String md5 = item.getDigests().getMd5();
                        boolean bl2 = duplicate = md5 != null && !parentItemMd5s.add(md5);
                        if (duplicate && this.useLinkedFilePlaceholderForDuplicateFamilies) {
                            addAsPlaceholder = true;
                            if (this.tagDuplicateFamilies) {
                                Item topLevelItem = item.getTopLevelItem();
                                if (topLevelItem != null) {
                                    duplicateItemsToTag.add(topLevelItem);
                                } else if (item.isTopLevel()) {
                                    duplicateItemsToTag.add(item);
                                }
                            }
                        }
                    }
                    HashSet<Path> childFilePaths = new HashSet<Path>();
                    boolean addedContent = false;
                    boolean addedPlaceholder = false;
                    for (Path filePath : linkedFilePaths) {
                        boolean addFileAsPlaceholder = addAsPlaceholder;
                        if (this.linkedExportIngestionMethod == VaultLinkedExportIngestionMethod.ADD_AS_CHILD_ITEM) {
                            Integer attachedCount = linkedItemAttachedCount.computeIfAbsent(filePath.getFileName().toString(), k -> 0);
                            if (attachedCount >= this.linkedFileAddAsFamilyItemLimit) {
                                addFileAsPlaceholder = true;
                            } else {
                                attachedCount = attachedCount + 1;
                                linkedItemAttachedCount.put(filePath.getFileName().toString(), attachedCount);
                            }
                        }
                        if (addFileAsPlaceholder) {
                            this.googleVaultLinkedFilesWithPlaceholders.add(filePath.getFileName().toString());
                            Path placeholderPath = this.createOrGetPlaceholderPath(filePath);
                            childFilePaths.add(placeholderPath);
                            addedPlaceholder = true;
                            continue;
                        }
                        childFilePaths.add(filePath);
                        addedContent = true;
                    }
                    this.processor.addChildItems(item, childFilePaths);
                    if (addedContent) {
                        parentsAddedLinkedFiles.getAndIncrement();
                    }
                    if (!addedPlaceholder) continue;
                    parentsAddedPlaceholderFiles.getAndIncrement();
                }
            }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
        }
        if (!duplicateItemsToTag.isEmpty()) {
            this.executionContext.nuixCase.createTag(this.duplicateFamilyTagName);
            this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.duplicateFamilyTagName, duplicateItemsToTag);
            this.taggedDuplicateFamilies = true;
            LOGGER.info("Tagged " + duplicateItemsToTag.size() + " duplicate family top-level items");
        }
        if (parentsAddedLinkedFiles.get() > 0) {
            this.addExecutionLog(this.iu.getNumeralString("AddEvidenceOperation.Log.AddedLinkedFiles", (long)parentsAddedLinkedFiles.get()));
        }
        if (parentsAddedPlaceholderFiles.get() > 0) {
            this.addExecutionLog(this.iu.getNumeralString("AddEvidenceOperation.Log.AddedPlaceholderFiles", (long)parentsAddedPlaceholderFiles.get()));
        }
        return parentsAddedLinkedFiles.get() > 0 || parentsAddedPlaceholderFiles.get() > 0;
    }

    private void assignGuidReferenceToPlaceholderItems() throws IOException, NoSuchAlgorithmException {
        LOGGER.info("Assigning linked file content item GUID to placeholder file items");
        byte[] emptyBytes = new byte[]{};
        String emptyFileMd5 = SecurityUtils.computeMd5Hex((byte[])emptyBytes);
        for (String exportFolder : this.googleVaultExportToLinkedExport.keySet()) {
            String linkedExport = this.googleVaultExportToLinkedExport.get(exportFolder);
            if (linkedExport == null) continue;
            Path exportPath = Paths.get(exportFolder, new String[0]);
            ConcurrentHashMap itemIdentifierToGuids = new ConcurrentHashMap();
            String exportAndLinkedItemsQuery = this.getExportItemsQuery(exportPath, true);
            if (exportAndLinkedItemsQuery == null) {
                this.addWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.CouldNotFindEvidenceContainersForExport", (Object)exportPath));
                continue;
            }
            Collection exportAndLinkedExportItems = this.executionContext.nuixCase.searchUnsorted(exportAndLinkedItemsQuery);
            LOGGER.info("Export and linked export items scope size: " + exportAndLinkedExportItems.size());
            exportAndLinkedExportItems = this.executionContext.nuixUtilities.getItemUtility().sortItems(exportAndLinkedExportItems, item -> {
                String md5;
                if (item.getDigests() != null && (md5 = item.getDigests().getMd5()) != null && !md5.equalsIgnoreCase(emptyFileMd5)) {
                    return 0;
                }
                return 1;
            });
            Parallel.forEachPartitioned((Partitioner)new FixedSizeChunkPartitioner((Iterable)exportAndLinkedExportItems, ItemsUtils.getPartitionerChunkSize(1000, this)), itemIterator -> {
                while (itemIterator.hasNext()) {
                    String md5;
                    if (this.stopRequested) {
                        throw new WorkflowExecutionStopRequested();
                    }
                    Item item = (Item)itemIterator.next();
                    if (item.getName() == null || !this.googleVaultLinkedFilesWithPlaceholders.contains(item.getName()) || (md5 = item.getDigests().getMd5()) == null || md5.equalsIgnoreCase(emptyFileMd5)) continue;
                    String contentItemIdentifier = this.getPlaceholderItemIdentifier(item);
                    itemIdentifierToGuids.put(contentItemIdentifier, item.getGuid());
                }
            }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
            Parallel.forEachPartitioned((Partitioner)new FixedSizeChunkPartitioner((Iterable)exportAndLinkedExportItems, ItemsUtils.getPartitionerChunkSize(1000, this)), itemIterator -> {
                while (itemIterator.hasNext()) {
                    String placeholderItemIdentifier;
                    String contentItemGuid;
                    String md5;
                    if (this.stopRequested) {
                        throw new WorkflowExecutionStopRequested();
                    }
                    Item item = (Item)itemIterator.next();
                    if (item.getName() == null || !this.googleVaultLinkedFilesWithPlaceholders.contains(item.getName()) || (md5 = item.getDigests().getMd5()) != null && !md5.equalsIgnoreCase(emptyFileMd5) || (contentItemGuid = (String)itemIdentifierToGuids.getOrDefault(placeholderItemIdentifier = this.getPlaceholderItemIdentifier(item), null)) == null) continue;
                    ItemCustomMetadataMap itemCustomMetadataMap = item.getCustomMetadata();
                    itemCustomMetadataMap.put((Object)"Content Item GUID", (Object)contentItemGuid);
                }
            }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
        }
    }

    private void tagDuplicateFamilies() throws IOException {
        LOGGER.info("Tagging duplicate families");
        String duplicateFamiliesTagQuery = "batch-load-guid:(" + String.join((CharSequence)" OR ", this.batchLoadGuids) + ") AND tag:\"" + this.duplicateFamilyTagName + "\"";
        Set duplicateFamilyTopLevelItems = this.executionContext.nuixCase.searchUnsorted(duplicateFamiliesTagQuery);
        LOGGER.info("Duplicate family top-level items scope size: " + duplicateFamilyTopLevelItems.size());
        Set duplicateFamilyItems = this.executionContext.nuixUtilities.getItemUtility().findFamilies((Collection)duplicateFamilyTopLevelItems);
        this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.duplicateFamilyTagName, (Collection)duplicateFamilyItems);
        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.DuplicateFamilyTagName", (Object)this.duplicateFamilyTagName));
        this.addExecutionLog(this.iu.getNumeralString("AddEvidenceOperation.Log.DuplicateFamilyTagCount", (long)duplicateFamilyItems.size()));
    }

    private void associateGoogleVaultExportsMetadata(String exportFolder) throws IOException {
        Path linkedExportPath;
        Path exportPath = Paths.get(exportFolder, new String[0]);
        LOGGER.info("Adding associated metadata for Google Vault export: " + String.valueOf(exportPath));
        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.AssociatingGoogleVaultExportMetadata", (Object)exportPath.getFileName()));
        Map<String, List<Tag>> vaultExportMetadataMap = this.getVaultExportMetadata(exportPath);
        String linkedExportFolder = this.googleVaultExportToLinkedExport.get(exportFolder);
        if (linkedExportFolder != null && Files.isDirectory(linkedExportPath = Paths.get(linkedExportFolder, new String[0]), new LinkOption[0])) {
            vaultExportMetadataMap.putAll(this.getVaultExportMetadata(linkedExportPath));
        }
        if (vaultExportMetadataMap.isEmpty()) {
            this.addWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.VaultExportDoesNotContainMetadata", (Object)exportPath));
            return;
        }
        this.addExecutionLog(this.iu.getNumeralString("AddEvidenceOperation.Log.DetectedMetadataItems", (long)vaultExportMetadataMap.size()));
        String exportAndLinkedItemsQuery = this.getExportItemsQuery(exportPath, true);
        if (exportAndLinkedItemsQuery == null) {
            this.addWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.CouldNotFindEvidenceContainersForExport", (Object)exportPath));
            return;
        }
        Set exportAndLinkedExportItems = this.executionContext.nuixCase.searchUnsorted(exportAndLinkedItemsQuery);
        LOGGER.info("Export and linked export items scope size: " + exportAndLinkedExportItems.size());
        ConcurrentHashMap<String, List<Tag>> itemKeyToMetadata = new ConcurrentHashMap<String, List<Tag>>(vaultExportMetadataMap);
        ConcurrentHashMap.KeySetView matchedItemKeys = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView remainingItemKeys = ConcurrentHashMap.newKeySet();
        remainingItemKeys.addAll(itemKeyToMetadata.keySet());
        Parallel.forEachPartitioned((Partitioner)new FixedSizeChunkPartitioner((Iterable)exportAndLinkedExportItems, ItemsUtils.getPartitionerChunkSize(1000, this)), itemIterator -> {
            while (itemIterator.hasNext()) {
                String itemMessageId;
                if (this.stopRequested) {
                    throw new WorkflowExecutionStopRequested();
                }
                Item item = (Item)itemIterator.next();
                String itemName = item.getName();
                if (itemName != null && itemKeyToMetadata.containsKey(itemName)) {
                    remainingItemKeys.remove(itemName);
                    matchedItemKeys.add(itemName);
                    this.assignCustomMetadata(item, (List)itemKeyToMetadata.get(itemName));
                }
                if ((itemMessageId = this.getItemRfc822Id(item)) == null || !itemKeyToMetadata.containsKey(itemMessageId)) continue;
                remainingItemKeys.remove(itemMessageId);
                matchedItemKeys.add(itemMessageId);
                this.assignCustomMetadata(item, (List)itemKeyToMetadata.get(itemMessageId));
            }
        }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
        if (!remainingItemKeys.isEmpty()) {
            LOGGER.warn("Failed to match item keys: " + String.join((CharSequence)", ", remainingItemKeys));
            this.addWarning(this.iu.getNumeralString("AddEvidenceOperation.Log.CouldNotMatchRecords", (long)remainingItemKeys.size()));
        }
        this.addExecutionLog(this.iu.getNumeralString("AddEvidenceOperation.Log.AssignMetadata", (long)matchedItemKeys.size()));
    }

    private void extractAndRenameLinkedExportFiles(Path extractedLinkedExportPath, Path linkedExportPath) throws IOException {
        Files.createDirectories(extractedLinkedExportPath, new FileAttribute[0]);
        HashSet<Path> extractedZipPaths = new HashSet<Path>();
        try (DirectoryStream<Path> linkedExportDirStream = Files.newDirectoryStream(linkedExportPath);){
            for (Path file : linkedExportDirStream) {
                if (file.getFileName().toString().endsWith(".zip")) {
                    String zipDirName = FilenameUtils.getBaseName((String)file.getFileName().toString());
                    Path extractedZipPath = extractedLinkedExportPath.resolve(zipDirName);
                    ZipUtils.unzipFile((Path)file, (Path)extractedZipPath);
                    extractedZipPaths.add(extractedZipPath);
                    continue;
                }
                Path newFilePath = extractedLinkedExportPath.resolve(file.getFileName());
                Files.copy(file, newFilePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        if (extractedZipPaths.isEmpty()) {
            LOGGER.warn("Linked export does not contain any zip files");
            return;
        }
        Map<String, LinkedFileStub> docIdToFile = this.parseLinkedExportMetadataXml(linkedExportPath);
        if (docIdToFile.isEmpty()) {
            LOGGER.warn("Linked drive metadata.xml does not contain any drive file records");
        }
        HashMap<String, Path> docIdToRenamedFilePath = new HashMap<String, Path>();
        this.googleVaultLinkedFileDocIdToRenamedFilePath.put(extractedLinkedExportPath.toString(), docIdToRenamedFilePath);
        for (String docId : docIdToFile.keySet()) {
            LinkedFileStub stub = docIdToFile.get(docId);
            Path filePath = null;
            for (Path extractedZip : extractedZipPaths) {
                Path extractedFilePath = extractedZip.resolve(stub.getFileName());
                if (!Files.exists(extractedFilePath, new LinkOption[0])) continue;
                filePath = extractedFilePath;
                break;
            }
            if (filePath == null) continue;
            try {
                if (stub.getName() != null && !stub.getName().trim().isEmpty()) {
                    String fileName = stub.getName().replaceAll("[<>:\"/\\\\|?*]", "-").trim();
                    Path newFilePath = filePath.resolveSibling(fileName);
                    if (Files.exists(newFilePath, new LinkOption[0])) {
                        newFilePath = newFilePath.resolveSibling(docId).resolve(newFilePath.getFileName());
                        Files.createDirectories(newFilePath, new FileAttribute[0]);
                    }
                    filePath = Files.move(filePath, newFilePath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error renaming linked file: " + stub.getFileName() + ", to original file name: " + stub.getName(), (Throwable)e);
            }
            docIdToRenamedFilePath.put(docId, filePath);
        }
    }

    private Map<String, Set<Path>> parseLinkedExportFilePaths(Path exportPath, Path linkedExportPath) throws IOException {
        Map<String, LinkedFileStub> docIdToFile = this.parseLinkedExportMetadataXml(linkedExportPath);
        if (docIdToFile.isEmpty()) {
            LOGGER.warn("Linked drive metadata.xml does not contain any drive file records");
            return null;
        }
        Path exportDriveLinksCsv = FileUtils.getPathWithSuffixInDir((Path)exportPath, (String)"-drive-links.csv");
        if (exportDriveLinksCsv == null) {
            LOGGER.warn("Did not find drive-links.csv file for export: " + String.valueOf(exportPath));
            return null;
        }
        Map<String, Path> docIdToRenamedFilePath = this.googleVaultLinkedFileDocIdToRenamedFilePath.get(linkedExportPath.toString());
        HashMap<String, Path> docIdToFilePath = new HashMap<String, Path>();
        for (String docId : docIdToFile.keySet()) {
            Path filePath = docIdToRenamedFilePath.get(docId);
            if (filePath == null || !Files.exists(filePath, new LinkOption[0])) continue;
            docIdToFilePath.put(docId, filePath);
        }
        HashMap<String, Set<Path>> messageIdToLinkedFilePaths = new HashMap<String, Set<Path>>();
        List csvLines = FileUtils.loadVariableColumnCsv((File)exportDriveLinksCsv.toFile());
        int rfc822Col = 1;
        int driveItemIdCol = 4;
        for (int i = 1; i < csvLines.size(); ++i) {
            Object[] line = (Object[])csvLines.get(i);
            String rfc822Id = line[rfc822Col].toString();
            String docId = line[driveItemIdCol].toString().trim();
            if (!docIdToFilePath.containsKey(docId)) continue;
            Path filePath = (Path)docIdToFilePath.get(docId);
            Set linkedDriveItemFilePaths = messageIdToLinkedFilePaths.computeIfAbsent(rfc822Id, k -> new HashSet());
            linkedDriveItemFilePaths.add(filePath);
        }
        return messageIdToLinkedFilePaths;
    }

    private Map<String, LinkedFileStub> parseLinkedExportMetadataXml(Path linkedDriveExportPath) throws IOException {
        HashMap<String, LinkedFileStub> driveItemDocIdToFile = new HashMap<String, LinkedFileStub>();
        Path linkedDriveExportMetadataXml = FileUtils.getPathWithSuffixInDir((Path)linkedDriveExportPath, (String)"-metadata.xml");
        if (linkedDriveExportMetadataXml == null) {
            LOGGER.warn("Did not find metadata.xml drive files record for: " + String.valueOf(linkedDriveExportPath));
        } else {
            try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(linkedDriveExportMetadataXml, StandardOpenOption.READ));){
                Root root = (Root)Serializer.instance().deserialize(is);
                Batch batch = root.getBatch();
                if (batch != null && batch.getDocuments() != null) {
                    for (Document document : batch.getDocuments()) {
                        String docId = document.getDocId();
                        LinkedFileStub stub = new LinkedFileStub(document);
                        if (docId == null || !stub.isValid()) continue;
                        driveItemDocIdToFile.put(docId.trim(), stub);
                    }
                }
            }
        }
        return driveItemDocIdToFile;
    }

    private Map<String, List<Tag>> getVaultExportMetadata(Path exportPath) throws IOException {
        Path exportMetadataXmlPath;
        HashMap<String, List<Tag>> exportMetadata = new HashMap<String, List<Tag>>();
        Path exportMetadataCsvPath = FileUtils.getPathWithSuffixInDir((Path)exportPath, (String)"-metadata.csv");
        if (exportMetadataCsvPath != null) {
            exportMetadata.putAll(this.parseVaultExportMetadataCsv(exportMetadataCsvPath));
        }
        if ((exportMetadataXmlPath = FileUtils.getPathWithSuffixInDir((Path)exportPath, (String)"-metadata.xml")) != null) {
            exportMetadata.putAll(this.parseVaultExportMetadataXml(exportPath, exportMetadataXmlPath));
        }
        return exportMetadata;
    }

    private Map<String, List<Tag>> parseVaultExportMetadataCsv(Path exportMetadataCsvPath) throws IOException {
        HashMap<String, List<Tag>> itemRfc822IdToMetadataTags = new HashMap<String, List<Tag>>();
        List csvLines = FileUtils.loadVariableColumnCsv((File)exportMetadataCsvPath.toFile());
        if (!csvLines.isEmpty()) {
            Object[] headerLine = (Object[])csvLines.get(0);
            int rfc822Col = 0;
            for (int i = 1; i < csvLines.size(); ++i) {
                Object[] line = (Object[])csvLines.get(i);
                String rfc822Id = line[rfc822Col].toString();
                ArrayList<Tag> metadataTags = new ArrayList<Tag>();
                for (int j = 1; j < line.length; ++j) {
                    Tag tag = new Tag();
                    tag.setTagName(headerLine[j].toString());
                    tag.setTagValue(line[j].toString());
                    if (tag.getTagName().startsWith("Date")) {
                        tag.setTagDataType("DateTime");
                    } else {
                        tag.setTagDataType("Text");
                    }
                    metadataTags.add(tag);
                }
                itemRfc822IdToMetadataTags.put(rfc822Id.trim(), metadataTags);
            }
        }
        return itemRfc822IdToMetadataTags;
    }

    private Map<String, List<Tag>> parseVaultExportMetadataXml(Path exportPath, Path exportMetadataXmlPath) throws IOException {
        HashMap<String, List<Tag>> itemNameToMetadataTags = new HashMap<String, List<Tag>>();
        Map<String, Path> docIdToRenamedFilePath = this.googleVaultLinkedFileDocIdToRenamedFilePath.get(exportPath.toString());
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(exportMetadataXmlPath, StandardOpenOption.READ));){
            Root root = (Root)Serializer.instance().deserialize(is);
            Batch batch = root.getBatch();
            if (batch != null && batch.getDocuments() != null) {
                for (Document document : batch.getDocuments()) {
                    Path filePath = null;
                    if (docIdToRenamedFilePath != null) {
                        filePath = docIdToRenamedFilePath.get(document.getDocId());
                    }
                    if (filePath != null) {
                        itemNameToMetadataTags.put(filePath.getFileName().toString(), document.getTags());
                        continue;
                    }
                    LinkedFileStub stub = new LinkedFileStub(document);
                    if (!stub.isValid()) continue;
                    itemNameToMetadataTags.put(stub.getFileName().trim(), document.getTags());
                }
            }
        }
        return itemNameToMetadataTags;
    }

    private void assignCustomMetadata(Item item, List<Tag> metadataTags) {
        ItemCustomMetadataMap itemCustomMetadata = item.getCustomMetadata();
        for (Tag tag : metadataTags) {
            String value = tag.getTagValue();
            if (tag.getTagDataType().equals("DateTime")) {
                try {
                    value = DateTime.parse((String)tag.getTagValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            itemCustomMetadata.put((Object)tag.getTagName(), (Object)value);
        }
    }

    private String getItemRfc822Id(Item item) {
        Map properties = item.getProperties();
        Object messageId = properties.get("Mapi-Smtp-Message-Id");
        if (messageId == null || messageId.toString().trim().isEmpty()) {
            messageId = properties.get("Message-ID");
        }
        if (messageId == null || messageId.toString().trim().isEmpty()) {
            messageId = properties.get("Transport Headers Message-ID");
        }
        if (messageId != null) {
            return this.cleanItemMessageId(messageId.toString());
        }
        return null;
    }

    private String getItemInReplyTo(Item item) {
        Object inReplyTo = item.getProperties().get("Transport Headers In-Reply-To");
        if (inReplyTo != null) {
            return this.cleanItemMessageId(inReplyTo.toString());
        }
        return null;
    }

    private String cleanItemMessageId(String messageId) {
        String result = messageId;
        if (messageId != null && (result = messageId.replace("<", "").replace(">", "").trim()).contains("@[") && result.endsWith("]")) {
            result = result.substring(0, result.length() - 1).replace("@[", "@");
        }
        return result;
    }

    private String getPlaceholderItemIdentifier(Item item) {
        List pathNames = item.getPathNames();
        int grandParentPathNameIndex = pathNames.size() - 2;
        if (grandParentPathNameIndex < 0) {
            grandParentPathNameIndex = 0;
        }
        return (String)pathNames.get(grandParentPathNameIndex) + item.getName();
    }

    private String getExportItemsQuery(Path exportPath, boolean includeLinkedExport) {
        Set<String> linkedExportEvidenceName;
        String linkedExport;
        ArrayList<String> evidenceNames = new ArrayList<String>();
        Set<String> exportEvidenceName = this.getExportEvidenceName(exportPath);
        if (exportEvidenceName != null) {
            evidenceNames.addAll(exportEvidenceName);
        }
        if (includeLinkedExport && (linkedExport = this.googleVaultExportToLinkedExport.get(exportPath.toString())) != null && (linkedExportEvidenceName = this.getExportEvidenceName(Paths.get(linkedExport, new String[0]))) != null) {
            evidenceNames.addAll(linkedExportEvidenceName);
        }
        if (!evidenceNames.isEmpty()) {
            return "path-name:(\"" + String.join((CharSequence)"\" OR \"", evidenceNames) + "\")";
        }
        return null;
    }

    private Set<String> getExportEvidenceName(Path exportPath) {
        if (exportPath != null) {
            return this.googleVaultExportToEvidenceContainerName.get(exportPath.getFileName().toString());
        }
        return null;
    }

    private synchronized Path createOrGetPlaceholderPath(Path filePath) {
        try {
            Path placeholderPath;
            Path placeholderParentPath = filePath.getParent().resolveSibling(PLACEHOLDERS_DIR_NAME);
            if (!Files.isDirectory(placeholderParentPath, new LinkOption[0])) {
                Files.createDirectories(placeholderParentPath, new FileAttribute[0]);
            }
            if (!Files.exists(placeholderPath = placeholderParentPath.resolve(filePath.getFileName()), new LinkOption[0])) {
                Files.createFile(placeholderPath, new FileAttribute[0]);
            }
            return placeholderPath;
        }
        catch (IOException e) {
            LOGGER.error("Error creating placeholder file for: " + String.valueOf(filePath) + ", reverting to adding linked file as child", (Throwable)e);
            return filePath;
        }
    }

    private void waitForWorkerTempFolderToClear() throws InterruptedException, IOException {
        Path workerTempFolderPath = this.executionContext.nuixCase.getLocation().toPath().resolve("temp");
        long secondsToSleep = 10L;
        while (Files.exists(workerTempFolderPath, new LinkOption[0]) && !FileUtils.isDirectoryEmpty((Path)workerTempFolderPath)) {
            LOGGER.info("Waiting " + secondsToSleep + " s for worker temp folder to clear");
            Thread.sleep(secondsToSleep * 1000L);
        }
    }

    @Override
    public synchronized void updateState() {
        if (this.ingestionStartedEpoch > 0L && this.loadProcessingJob != null && this.loadProcessingJob.getItemsProcessed() == 0L && !this.isPaused) {
            long elapsedMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - this.ingestionStartedEpoch;
            if (!this.noProgressWarningRaised && elapsedMillis > 300000L) {
                this.noProgressWarningRaised = true;
                this.addTransientWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.NoProgress", (Object)this.iu.getNumeralString("AddEvidenceOperation.Error.NoProgressFirstMinutes", 5L)), false);
            }
            if (!this.noProgressErrorRaised && this.processingInitTimeoutMinutes > 0L && elapsedMillis > this.processingInitTimeoutMinutes * 1000L * 60L) {
                this.noProgressErrorRaised = true;
                this.exception = new WorkflowExecutionAbortRequested(this.iu.getFormattedString("AddEvidenceOperation.Error.NoProgress", (Object)this.iu.getNumeralString("AddEvidenceOperation.Error.NoProgressFirstMinutes", this.processingInitTimeoutMinutes)));
                this.executionState = ExecutionState.ERROR;
                this.loadProcessingJob.abort();
            }
        }
        if (this.noProgressWarningRaised && this.loadProcessingJob != null && this.loadProcessingJob.getItemsProcessed() > 0L) {
            this.noProgressWarningRaised = false;
            this.addTransientWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.NoProgress", (Object)this.iu.getNumeralString("AddEvidenceOperation.Error.NoProgressFirstMinutes", 5L)), true);
        }
        if (this.loadProcessingJob != null) {
            if (!this.isPaused && this.loadProcessingJob.hasPaused()) {
                this.isPaused = true;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", false);
            }
            if (this.isPaused && !this.loadProcessingJob.hasPaused()) {
                this.resumedFromPauseAt = DateTime.now((DateTimeZone)DateTimeZone.UTC);
                this.isPaused = false;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", true);
            }
            if (this.executionState == ExecutionState.RUNNING || this.executionState == ExecutionState.PAUSING) {
                if (this.loadProcessingJob.hasFinished()) {
                    if (this.sourceScope == SourceScope.GOOGLE_VAULT_EXPORT && this.googleVaultLinkedExportsIngestionThread != null) {
                        return;
                    }
                    this.handleLoadProcessingJobFinish();
                    if (this.startTriggerThread != null) {
                        if (this.startTriggerThread.isAlive()) {
                            LOGGER.info("Interrupting startTriggerThread");
                            this.startTriggerThread.interrupt();
                        }
                        try {
                            LOGGER.info("Waiting 60s for startTriggerThread to complete");
                            this.startTriggerThread.join(60000L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.warn("Could not wait for startTriggerThread to finish", (Throwable)e);
                        }
                    }
                    if (this.sourceScope == SourceScope.GOOGLE_VAULT_EXPORT) {
                        this.googleVaultLinkedExportsIngestionThread = new Thread(this::runGoogleVaultLinkedExportIngestion);
                        this.googleVaultLinkedExportsIngestionThread.setName("Automate - Operation " + this.getOperationName() + " - Vault Linked Exports Ingestion");
                        this.googleVaultLinkedExportsIngestionThread.start();
                    } else {
                        this.trackFinished();
                    }
                }
            } else if (this.executionState == ExecutionState.STOPPING && this.loadProcessingJob.hasFinished()) {
                this.trackStopped();
            }
        }
    }

    private void getNextEvidenceName() throws ParameterException {
        this.getNextEvidenceName(false);
    }

    private void getNextEvidenceName(boolean forceIncrement) {
        boolean increment = forceIncrement;
        this.effectiveEvidenceName = this.evidenceName.trim().length() == 0 ? this.iu.getString("AddEvidenceOperation.DefaultEvidenceName") : this.evidenceName.trim();
        String evidenceNamePrefix = this.effectiveEvidenceName;
        boolean evidenceNameUnique = !NuixUtils.caseContainsEvidenceContainer(this.executionContext.nuixCase, this.effectiveEvidenceName);
        int evidenceNameCounter = 1;
        String[] splits = this.effectiveEvidenceName.split(" ");
        if (splits.length > 1) {
            String lastSplit = splits[splits.length - 1];
            try {
                String tempEvidenceNamePrefix = this.effectiveEvidenceName.substring(0, this.effectiveEvidenceName.length() - lastSplit.length() - 1);
                evidenceNameCounter = Integer.parseInt(lastSplit);
                evidenceNamePrefix = tempEvidenceNamePrefix;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        while (!evidenceNameUnique || increment) {
            if (increment) {
                LOGGER.warn("Evidence container name '" + this.effectiveEvidenceName + "' is unavailable");
            } else {
                LOGGER.warn("Evidence container name '" + this.effectiveEvidenceName + "' is not unique");
            }
            increment = false;
            this.effectiveEvidenceName = evidenceNamePrefix + " " + ++evidenceNameCounter;
            evidenceNameUnique = !NuixUtils.caseContainsEvidenceContainer(this.executionContext.nuixCase, this.effectiveEvidenceName);
        }
    }

    private boolean createVaultExportEvidenceContainer(Path exportPath, Map<String, String> customMetadataMap) {
        String originalExportFileName;
        Path originalExportPath;
        String exportFileName = exportPath.getFileName().toString();
        String exportName = exportFileName;
        if (exportName.endsWith(EXTRACTED_SUFFIX) && Files.isDirectory(originalExportPath = exportPath.resolveSibling(originalExportFileName = exportName.substring(0, exportName.length() - EXTRACTED_SUFFIX.length())), new LinkOption[0])) {
            exportName = originalExportFileName;
        }
        this.effectiveEvidenceName = exportName;
        if (!this.createEvidenceContainer()) {
            return false;
        }
        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.SubFolderEvidenceName", new Object[]{exportFileName, this.effectiveEvidenceName}));
        Set exportEvidenceContainerNames = this.googleVaultExportToEvidenceContainerName.computeIfAbsent(exportFileName, k -> new HashSet());
        exportEvidenceContainerNames.add(this.effectiveEvidenceName);
        try {
            this.evidenceContainer.addFile(exportPath);
            this.evidenceContainer.setTimeZone(this.timeZoneId);
            this.evidenceContainer.setCustomMetadata(customMetadataMap);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Evidence file does not exist", (Throwable)e);
            this.exception = new Exception(this.iu.getString("AddEvidenceOperation.Exception.EvidenceDoesNotExist"), e);
            this.executionState = ExecutionState.ERROR;
            return false;
        }
        try {
            this.evidenceContainer.save();
        }
        catch (IOException e) {
            LOGGER.error("Cannot save evidence", (Throwable)e);
            this.exception = new Exception(this.iu.getString("AddEvidenceOperation.Exception.CannotSaveEvidence"), e);
            this.executionState = ExecutionState.ERROR;
            return false;
        }
        return true;
    }

    private boolean createEvidenceContainer() {
        boolean evidenceContainerCreated = false;
        Exception lastException = null;
        for (int i = 0; i < 100; ++i) {
            block9: {
                try {
                    this.evidenceContainer = this.processor.newEvidenceContainer(this.effectiveEvidenceName);
                    if (this.metadataImportProfile != null && this.metadataImportProfile.trim().length() > 0) {
                        this.evidenceContainer.setMetadataImportProfileName(this.metadataImportProfile);
                    }
                    if (this.zipEncoding != null && !this.zipEncoding.equals(this.sourceEncoding)) {
                        if (this.executionContext.nuixVersion.compareTo(new Version("8.6.0")) < 0) {
                            this.evidenceContainer.setEncoding(this.sourceEncoding);
                            this.addWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.CannotSetZipEncoding", new Object[]{this.zipEncoding, "8.6"}));
                        } else {
                            this.evidenceContainer.setEncoding(this.sourceEncoding, this.zipEncoding);
                        }
                    } else {
                        this.evidenceContainer.setEncoding(this.sourceEncoding);
                    }
                    if (this.dataLocale == null) break block9;
                    this.evidenceContainer.setLocale(this.dataLocale.toLanguageTag());
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot use evidence container name " + this.effectiveEvidenceName, (Throwable)e);
                    this.evidenceName = this.effectiveEvidenceName;
                    this.getNextEvidenceName(true);
                    lastException = e;
                    continue;
                }
            }
            evidenceContainerCreated = true;
            break;
        }
        if (!evidenceContainerCreated) {
            LOGGER.error("Cannot save evidence", lastException);
            this.exception = new Exception(this.iu.getString("AddEvidenceOperation.Exception.CannotSaveEvidence"));
            this.executionState = ExecutionState.ERROR;
        }
        return evidenceContainerCreated;
    }

    private boolean createProcessor() {
        try {
            SimpleCase simpleCase = NuixUtils.getSimpleCase(this.executionContext.nuixCase);
            this.processor = simpleCase.createProcessor();
            this.processor.whenItemProcessed(this::itemProcessed);
            this.processor.getProcessingSettings().put("calculateAuditedSize", true);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Cannot create processor", (Throwable)e);
            this.exception = new Exception(this.iu.getString("AddEvidenceOperation.Exception.CannotAccessProcessor"), e);
            this.executionState = ExecutionState.ERROR;
            return false;
        }
    }

    private boolean startAndWaitForProcessingJob() {
        try {
            this.setConfigurationProfileSettings();
            HashMap<String, Object> overWritingParallelProcessingSettings = new HashMap<String, Object>();
            if (this.executionContext.jobBrokerIp != null) {
                this.addExecutionLog(this.iu.getFormattedString("General.Log.JobRemoteBroker", (Object)(this.executionContext.jobBrokerIp + ":" + this.executionContext.jobBrokerPort)));
                overWritingParallelProcessingSettings.put("workerBrokerAddress", this.executionContext.jobBrokerIp + ":" + this.executionContext.jobBrokerPort);
            }
            this.setProcessingProfileSettings(overWritingParallelProcessingSettings);
            this.setWorkerParallelSettings(overWritingParallelProcessingSettings);
            this.applyProcessingProfile();
            if (this.stopRequested) {
                this.trackStopped();
                return false;
            }
            this.printMemoryUsed("Memory used before start");
            this.resetProcessingJobData();
            this.loadProcessingJob = this.processor.processAsync();
            this.ingestionStartedEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            String processingJobGuid = this.loadProcessingJob.getJobGuid().replace("-", "");
            LOGGER.info("Job Guid: " + processingJobGuid);
            NuixWorkerUtils.addRemoteWorkers(this.executionContext, this, (ProcessingJob)this.loadProcessingJob, this.addedWorkerCount);
        }
        catch (Exception e) {
            LOGGER.error("Cannot start processing", (Throwable)e);
            try {
                if (this.loadProcessingJob != null) {
                    LOGGER.info("Attempting to stop job");
                    this.loadProcessingJob.stop();
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot stop job", (Throwable)ex);
            }
            this.exception = new Exception(this.iu.getString("AddEvidenceOperation.Exception.CannotStartProcessing"), e);
            this.executionState = ExecutionState.ERROR;
            return false;
        }
        NuixUtils.waitForProcessingJobToComplete((ProcessingJob)this.loadProcessingJob);
        return true;
    }

    private void handleLoadProcessingJobFinish() {
        this.printMemoryUsed("Memory used after finish");
        long loadedItems = 0L;
        for (BatchLoadDetails batchLoadDetails : this.executionContext.nuixCase.getBatchLoads()) {
            if (!batchLoadDetails.getBatchId().equals(this.loadProcessingJob.getJobGuid())) continue;
            try {
                loadedItems = batchLoadDetails.getItems().size();
            }
            catch (IOException e) {
                LOGGER.error("Error handling loadedItems", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("General.Warning.UnexpectedError", (Object)e.getLocalizedMessage()));
            }
        }
        System.gc();
        this.printMemoryUsed("Memory used after clean-up");
        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.ProcessingMode", (Object)this.loadProcessingJob.getProcessingMode()));
        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.TraversedCount", (Object)this.iu.getNumeralString("General.Count.Items", Math.max((long)this.seenItems.get(), this.loadProcessingJob.getItemsProcessed()))));
        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.TraversedSize", (Object)FormattingUtils.sizeToDisplaySize((long)this.loadProcessingJob.getBytesProcessed())));
        if (loadedItems > 0L) {
            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.LoadedCount", (Object)this.iu.getNumeralString("General.Count.Items", loadedItems)));
        }
        this.batchLoadGuids.add(this.loadProcessingJob.getJobGuid());
        this.utilizationScopeQuery = "batch-load-guid:(" + String.join((CharSequence)" OR ", this.batchLoadGuids) + ")";
        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.BatchLoadGuid", (Object)this.loadProcessingJob.getJobGuid()));
    }

    private void resetProcessingJobData() {
        if (this.loadProcessingJob != null) {
            this.totalEvidenceBytesProcessed.addAndGet(this.loadProcessingJob.getBytesProcessed());
            this.seenItems.set(0);
        }
    }

    public void itemProcessed(ProcessedItem processedItem) {
        this.seenItems.incrementAndGet();
        if (this.loadProcessingJob != null) {
            try {
                this.trackVolumeProcessed(this.totalEvidenceBytesProcessed.get() + this.loadProcessingJob.getBytesProcessed());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.Processed", (Object)String.join((CharSequence)"/", processedItem.getPath())));
        this.trackItemProcessedIrregular(processedItem.getMimeType(), processedItem.isCorrupted(), processedItem.isEncrypted(), processedItem.isDeleted());
    }

    private void printMemoryUsed(String message) {
        long memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        LOGGER.info(message + ": " + FormattingUtils.sizeToDisplaySize((long)memoryUsed));
    }

    @Override
    public void resumeTriggered() {
        try {
            this.loadProcessingJob.resume();
            this.ingestionStartedEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        }
        catch (Exception e) {
            LOGGER.error("resumeTriggered() triggered", (Throwable)e);
        }
    }

    @Override
    public void pauseTriggered() {
        try {
            this.loadProcessingJob.pause();
        }
        catch (Exception e) {
            LOGGER.error("resumeTriggered() triggered", (Throwable)e);
        }
    }

    @Override
    protected void stopTriggered() {
        LOGGER.info("Stop triggered");
        Thread thread = new Thread(() -> {
            while (this.executionState == ExecutionState.STOPPING) {
                try {
                    if (this.loadProcessingJob != null) {
                        LOGGER.info("Sending stop command");
                        this.loadProcessingJob.stop();
                    }
                }
                catch (LicenceException e) {
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot stop job", (Throwable)e);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        thread.setName("Automate - Operation " + this.getOperationName());
        thread.start();
    }

    @Override
    public String getPrintablePercentageComplete() {
        if (this.loadingHashes) {
            if (this.loadedHashesCount > 0L) {
                return this.iu.getNumeralString("AddEvidenceOperation.Progress.LoadedHashes", this.loadedHashesCount);
            }
            return this.iu.getString("AddEvidenceOperation.Progress.LoadingHashes");
        }
        if (this.deduplicationSerializing) {
            return this.iu.getString("AddEvidenceOperation.Progress.SavingHashes");
        }
        if (this.loadProcessingJob != null) {
            ArrayList<Object> statusComponents = new ArrayList<Object>();
            double percentageComplete = this.getNormalizedPercentageComplete();
            if (percentageComplete > 0.0) {
                statusComponents.add(FormattingUtils.getLocalizedPercentage((double)percentageComplete));
            }
            if (this.stageName.get() != null && !this.stageName.get().trim().isEmpty()) {
                statusComponents.add(this.stageName);
            }
            try {
                statusComponents.add(this.iu.getNumeralString("General.Count.Items", Math.max((long)this.seenItems.get(), this.loadProcessingJob.getItemsProcessed())));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.loadProcessingJob.getBytesProcessed() > 0L) {
                    statusComponents.add(FormattingUtils.sizeToDisplaySize((long)this.loadProcessingJob.getBytesProcessed()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.iu.getFormattedString("General.Status.Components" + statusComponents.size(), statusComponents.toArray());
        }
        return "";
    }

    @Override
    protected double getPercentageComplete() {
        double result = 0.0;
        if (this.loadProcessingJob != null && this.loadProcessingJob.getBytesProcessed() * this.loadProcessingJob.getJobSizeTotalBytes() > 0L) {
            double calculatedPercentageComplete = (double)this.loadProcessingJob.getBytesProcessed() / (double)this.loadProcessingJob.getJobSizeTotalBytes();
            double maxValidPercentageComplete = 0.9999;
            if (this.loadProcessingJob.hasFinished()) {
                maxValidPercentageComplete = 1.0;
            }
            result = Math.min(calculatedPercentageComplete, maxValidPercentageComplete);
        }
        if (this.stageCount > 0.0) {
            result = this.stageId / this.stageCount + result * (1.0 / this.stageCount);
        }
        return result;
    }

    @Override
    public void setDatasetsMetadata(Map<String, DatasetMetadata> datasetsMetadata) {
        this.dataSetsMetadata = datasetsMetadata;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return this.utilizationScopeQuery;
    }

    @Override
    public String getProcessingJobGuid() {
        if (this.loadProcessingJob != null) {
            return this.loadProcessingJob.getJobGuid();
        }
        return null;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("AddEvidenceOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.ADD_EVIDENCE;
    }

    @Override
    public void normalize() {
        super.normalize();
        HashMap<String, String> sourceEncodingMapping = new HashMap<String, String>();
        sourceEncodingMapping.put("ADOBE_STANDARD_ENCODING", "Adobe-Standard-Encoding");
        sourceEncodingMapping.put("WINDOWS_1252", "windows-1252");
        sourceEncodingMapping.put("CP_850", "IBM850");
        sourceEncodingMapping.put("UTF_8", "UTF-8");
        String normalizedEncoding = (String)sourceEncodingMapping.get(this.sourceEncoding);
        if (normalizedEncoding != null) {
            this.sourceEncoding = normalizedEncoding;
        }
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.predefined) {
            if (this.source.trim().length() == 0 && (SourceScope.usesSourcePath(this.sourceScope) || this.sourceScope == SourceScope.DATASET)) {
                prerequisites.add(this.iu.getString("AddEvidenceOperation.Prerequisites.SourcePathRequired"));
            }
            if (this.evidenceName.trim().length() == 0 && SourceScope.usesEvidenceName(this.sourceScope)) {
                prerequisites.add(this.iu.getString("AddEvidenceOperation.Prerequisites.EvidenceNameRequired"));
            }
        }
        if (!(activity != Operation.PrerequisitesActivity.RUN_UNATTENDED && activity != Operation.PrerequisitesActivity.SUBMIT_UNATTENDED || this.predefined)) {
            prerequisites.add(this.iu.getString("AddEvidenceOperation.Prerequisites.PredefinedRequired"));
        }
        if (SourceScope.isNetworkScope(this.sourceScope)) {
            if (this.sourceScope == SourceScope.MICROSOFT_GRAPH && !this.executionContext.versionGreaterOrEqualTo("9.0.0")) {
                prerequisites.add(this.iu.getFormattedString("AddEvidenceOperation.Prerequisites.SourceScopeRequiresNewerVersion", new Object[]{this.sourceScope, "9.0.0"}));
            } else if (!this.executionContext.versionGreaterOrEqualTo("8.0.0")) {
                prerequisites.add(this.iu.getFormattedString("AddEvidenceOperation.Prerequisites.SourceScopeRequiresNewerVersion", new Object[]{this.sourceScope, "8.0.0"}));
            }
        }
        return prerequisites;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.LOAD;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        if (this.predefined) {
            features.add(Feature.NUIX);
        } else {
            features.add(Feature.NUIX_WORKSTATION);
        }
        return features;
    }

    @Override
    public Activity getActivity() {
        return Activity.LOAD;
    }

    @Override
    protected ConsumptionSubType getConsumptionSubType() {
        return ConsumptionSubType.LOAD;
    }

    @Override
    public Integer getWorkerMemory() {
        if (this.executionContext.workflowBrokerWorkersCount <= 0) {
            return null;
        }
        if (this.workerMemory != null) {
            return this.workerMemory;
        }
        try {
            DummyParallelProcessingConfigurable configurable = new DummyParallelProcessingConfigurable();
            NuixWorkerUtils.setWorkerSettings(this.executionContext, this, configurable, false);
            this.workerMemory = Integer.parseInt(String.valueOf(configurable.getParallelProcessingSettings().get("workerMemory")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.workerMemory;
    }

    @Override
    public Integer getAddedWorkerCount() {
        if (this.addedWorkerCount == null) {
            return 0;
        }
        return this.addedWorkerCount.get();
    }
}

