/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.AddEvidenceRepositoryOperation;
import com.nuix.automate.workflow.core.execution.options.addevidencerepository.CustodianMode;
import com.nuix.automate.workflow.core.execution.options.addevidencerepository.EvidenceNameMode;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.util.HashMap;
import nuix.Processor;
import nuix.SimpleCase;
import org.joda.time.DateTimeZone;

public class AddEvidenceRepositoryOperationImplementation
extends AddEvidenceRepositoryOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddEvidenceRepositoryOperation.class);

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                Processor processor;
                this.executionContext.closeAllTabs();
                this.source = this.executionContext.evalParameters(this.source, this);
                this.evidenceNamePrefix = this.executionContext.evalParameters(this.evidenceNamePrefix, this);
                try {
                    SimpleCase simpleCase = NuixUtils.getSimpleCase(this.executionContext.nuixCase);
                    processor = simpleCase.createProcessor();
                }
                catch (Exception e) {
                    LOGGER.error("Cannot create processor", (Throwable)e);
                    this.exception = new Exception(this.iu.getString("AddEvidenceRepositoryOperation.Exception.CannotAccessNuixProcessor"), e);
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                if (this.custodianMode == CustodianMode.NO_CUSTODIANS) {
                    parameters.put("custodianLevel", -1);
                } else if (this.custodianMode == CustodianMode.CUSTODIAN_PER_FILE) {
                    parameters.put("custodianLevel", 1);
                    this.addExecutionLog(this.iu.getString("AddEvidenceRepositoryOperation.Log.CustodianLevelOne"));
                } else if (this.custodianMode == CustodianMode.CUSTODIAN_AT_LEVEL) {
                    parameters.put("custodianLevel", this.custodianLevel);
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceRepositoryOperation.Log.CustodianLevel", (Object)this.custodianLevel));
                } else {
                    throw new Exception(this.iu.getFormattedString("AddEvidenceRepositoryOperation.Exception.UnsupportedCustodianMode", (Object)this.custodianMode));
                }
                if (this.evidenceNameMode == EvidenceNameMode.FROM_CONTENT) {
                    parameters.put("evidenceContainerNaming", "content");
                    this.addExecutionLog(this.iu.getString("AddEvidenceRepositoryOperation.Log.NamingModeFromContent"));
                } else if (this.evidenceNameMode == EvidenceNameMode.NUMBERED) {
                    parameters.put("evidenceContainerNaming", "numbered");
                    this.addExecutionLog(this.iu.getString("AddEvidenceRepositoryOperation.Log.NamingModeNumbered"));
                } else {
                    throw new Exception(this.iu.getFormattedString("AddEvidenceRepositoryOperation.Exception.UnsupportedEvidenceNameMode", (Object)this.evidenceNameMode));
                }
                if (this.evidenceNameUsePrefix) {
                    parameters.put("evidenceContainerNamingPrefix", this.evidenceNamePrefix);
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceRepositoryOperation.Log.NamingPrefix", (Object)this.evidenceNamePrefix));
                } else {
                    parameters.put("evidenceContainerNamingPrefix", null);
                }
                String timezoneIdParameter = "{data_timezone_id}";
                String evaluatedTimezoneIdParameter = this.executionContext.evalParameters(timezoneIdParameter, this);
                if (!timezoneIdParameter.equals(evaluatedTimezoneIdParameter) && evaluatedTimezoneIdParameter.length() > 0) {
                    try {
                        DateTimeZone dateTimeZone = DateTimeZone.forID((String)evaluatedTimezoneIdParameter);
                        this.timeZoneId = dateTimeZone.getID();
                        LOGGER.info("Parsed specified timezone " + FormattingUtils.timeZoneToDisplayName((DateTimeZone)dateTimeZone) + " from ID " + timezoneIdParameter);
                        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceRepositoryOperation.Log.SettingDataTimezoneFromParameter", new Object[]{"{data_timezone_id}", FormattingUtils.timeZoneToDisplayName((DateTimeZone)dateTimeZone)}));
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot set timezone " + evaluatedTimezoneIdParameter, (Throwable)e);
                        this.addWarning(this.iu.getFormattedString("AddEvidenceRepositoryOperation.Warning.ParameterValue", new Object[]{"{data_timezone_id}", evaluatedTimezoneIdParameter}));
                    }
                }
                if (this.executionContext.nuixVersion.compareTo(new Version("7.6.0")) < 0) {
                    this.addWarning(this.iu.getString("AddEvidenceRepositoryOperation.Warning.EvidenceRepositoryTimeZone"));
                } else {
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceRepositoryOperation.Log.SourceTimeZone", (Object)FormattingUtils.timeZoneIdToDisplayName((String)this.timeZoneId)));
                    parameters.put("timeZone", this.timeZoneId);
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceRepositoryOperation.Log.SourceEncoding", (Object)this.sourceEncoding));
                    parameters.put("charset", this.sourceEncoding);
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceRepositoryOperation.Log.SourceLocaleLanguage", (Object)this.sourceLanguageLocale));
                    parameters.put("language", this.sourceLanguageLocale);
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceRepositoryOperation.Log.SourceLocaleCountry", (Object)this.sourceLocalCountry));
                    parameters.put("countryCode", this.sourceLocalCountry);
                }
                try {
                    processor.newEvidenceRepository(this.source, parameters);
                }
                catch (IllegalStateException e) {
                    LOGGER.error("Cannot add evidence repository", (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected void resumeTriggered() {
    }

    @Override
    protected void pauseTriggered() {
    }

    @Override
    protected void stopTriggered() {
    }

    @Override
    public void updateState() {
    }

    @Override
    protected double getPercentageComplete() {
        return 0.0;
    }

    @Override
    public String getPrintablePercentageComplete() {
        String result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        return result;
    }
}

