/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.AddItemsToClusterRunOperation;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nuix.ClusterRun;
import nuix.Item;

public class AddItemsToClusterRunOperationImplementation
extends AddItemsToClusterRunOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddItemsToClusterRunOperation.class);
    private transient ClusterRun clusterRun;
    private transient Set<Item> items;
    private transient Map clusterRunSettings;
    private transient String stageName;

    private ClusterRun getClusterRun(String clusterRunName) {
        List clusterRuns = this.executionContext.nuixCase.getClusterRuns();
        for (ClusterRun clusterRunCheck : clusterRuns) {
            if (!clusterRunCheck.getName().equals(clusterRunName)) continue;
            return clusterRunCheck;
        }
        return null;
    }

    @Override
    protected void startTriggered() throws Exception {
        this.executionContext.closeAllTabs();
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.clusterRunName = this.executionContext.evalParameters(this.clusterRunName, this);
        this.startTriggerThread = new Thread(() -> {
            block11: {
                try {
                    boolean clusterRunExisted = false;
                    long itemsInOriginalScope = 0L;
                    this.items = this.executionContext.nuixCase.searchUnsorted(NuixUtils.addAndQuery(this.scope, "has-exclusion:0"));
                    itemsInOriginalScope = this.items.size();
                    LOGGER.info("Scope count: " + itemsInOriginalScope);
                    this.addExecutionLog(this.iu.getFormattedString("AddItemsToClusterRunOperation.Log.ClusterName", (Object)this.clusterRunName));
                    this.addExecutionLog(this.iu.getFormattedString("AddItemsToClusterRunOperation.Log.ScopeQuery", (Object)this.scope));
                    this.addExecutionLog(this.iu.getNumeralString("AddItemsToClusterRunOperation.Log.ScopeCount", itemsInOriginalScope));
                    try {
                        this.clusterRun = this.getClusterRun(this.clusterRunName);
                        clusterRunExisted = this.clusterRun != null;
                        this.addExecutionLog(this.iu.getFormattedString("AddItemsToClusterRunOperation.Log.ClusterRunExists", (Object)(clusterRunExisted ? this.iu.getString("General.Yes") : this.iu.getString("General.No"))));
                    }
                    catch (Throwable e) {
                        LOGGER.warn(e.getMessage());
                    }
                    if (!clusterRunExisted) {
                        LOGGER.warn("Cluster run '" + this.clusterRunName + "' does not exist");
                        if (this.createIfNotExists) {
                            LOGGER.info("Building cluster run properties");
                            this.clusterRunSettings = new HashMap();
                            Date dateTime = new Date();
                            LOGGER.info("Setting property 'resemblanceThreshold' to '" + this.resemblanceThreshold + "'");
                            this.clusterRunSettings.put("resemblanceThreshold", this.resemblanceThreshold);
                            LOGGER.info("Setting property 'dateTime' to '" + String.valueOf(dateTime) + "'");
                            this.clusterRunSettings.put("dateTime", dateTime);
                            LOGGER.info("Setting property 'useNearDuplicates' to '" + this.useChainedNearDuplicates + "'");
                            this.clusterRunSettings.put("useNearDuplicates", this.useChainedNearDuplicates);
                            LOGGER.info("Setting property 'useEmailThreads' to '" + this.useEmailThreads + "'");
                            this.clusterRunSettings.put("useEmailThreads", this.useEmailThreads);
                        } else {
                            throw new Exception(this.iu.getFormattedString("AddItemsToClusterRunOperation.Exception.ClusterRunDoesNotExist", (Object)this.clusterRunName));
                        }
                    }
                    if (itemsInOriginalScope != 0L) {
                        LOGGER.info("Cluster run '" + this.clusterRunName + "' found");
                        if (clusterRunExisted) {
                            this.stageName = this.iu.getString("AddItemsToClusterRunOperation.Stage.AddingItems");
                            LOGGER.info("Adding items to cluster run");
                            boolean clusterRunItemsAdded = this.executionContext.nuixCase.addToClusterRun(this.clusterRunName, this.items);
                            if (clusterRunItemsAdded) {
                                LOGGER.info("Added " + itemsInOriginalScope + "items to cluster run '" + this.clusterRunName + "'");
                                this.addExecutionLog(this.iu.getNumeralString("AddItemsToClusterRunOperation.Log.AddedToClusterRun", itemsInOriginalScope));
                                break block11;
                            }
                            LOGGER.warn("Failed to add items to '" + this.clusterRunName + "'");
                            throw new Exception(this.iu.getNumeralString("AddItemsToClusterRunOperation.Exception.FailedToAddItems", itemsInOriginalScope));
                        }
                        this.stageName = this.iu.getString("AddItemsToClusterRunOperation.Stage.CreatingClusterRun");
                        LOGGER.info("Creating cluster run");
                        boolean clusterRunCreated = this.executionContext.nuixCase.generateClusterRun(this.clusterRunName, this.items, this.clusterRunSettings);
                        this.clusterRun = this.getClusterRun(this.clusterRunName);
                        if (this.clusterRun != null && clusterRunCreated) {
                            LOGGER.info("Created cluster run '" + this.clusterRunName + "' with " + itemsInOriginalScope + " items");
                            this.addExecutionLog(this.iu.getNumeralString("AddItemsToClusterRunOperation.Log.CreatedClusterRun", itemsInOriginalScope));
                            break block11;
                        }
                        LOGGER.warn("Failed to create cluster run '" + this.clusterRunName + "'");
                        throw new Exception(this.iu.getFormattedString("AddItemsToClusterRunOperation.Exception.FailedToCreateClusterRun", (Object)this.clusterRunName));
                    }
                    throw new Exception(this.iu.getString("AddItemsToClusterRunOperation.Exception.ClusterRunNoItems"));
                }
                catch (Throwable e) {
                    LOGGER.error("Operation unchecked exception");
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected void resumeTriggered() {
        LOGGER.warn("Resume triggered - not supported");
    }

    @Override
    protected void pauseTriggered() {
        LOGGER.warn("Pause triggered - not supported");
    }

    @Override
    protected void stopTriggered() {
        LOGGER.warn("Stop triggered - not supported");
    }

    @Override
    public void updateState() {
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.executionState == ExecutionState.FINISHED) {
            percentageComplete = 0.9999;
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = 1.0E-4;
        }
        return percentageComplete;
    }
}

