/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.AddItemsToDigestListOperation;
import com.nuix.automate.workflow.core.utils.digestlist.DigestHelper;
import com.nuix.automate.workflow.core.utils.digestlist.DigestHelperUtils;
import com.nuix.automate.workflow.core.utils.digestlist.MD5Hash;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Set;

public class AddItemsToDigestListOperationImplementation
extends AddItemsToDigestListOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddItemsToDigestListOperation.class);
    private transient DigestHelper digestHelper;
    private transient String stageName;
    private transient boolean inDigestHelperUtils;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.digestHelper = new DigestHelper(this.executionContext.nuixCase);
                DigestHelperUtils.resetState();
                this.scope = this.executionContext.evalParameters(this.scope, this);
                this.digestListName = this.executionContext.evalParameters(this.digestListName, this);
                this.addExecutionLog(this.iu.getFormattedString("AddItemsToDigestListOperation.Log.DigestListName", (Object)this.digestListName));
                this.addExecutionLog(this.iu.getFormattedString("AddItemsToDigestListOperation.Log.CreateDigestListIfDoesNotExist", (Object)this.createIfDoesntExist));
                this.stageName = this.iu.getString("AddItemsToDigestListOperation.Stage.GettingMDValues");
                this.addExecutionLog(this.iu.getFormattedString("AddItemsToDigestListOperation.Log.ScopeQuery", (Object)this.scope));
                Set items = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.addExecutionLog(this.iu.getNumeralString("AddItemsToDigestListOperation.Log.ScopeCount", (long)items.size()));
                this.inDigestHelperUtils = true;
                Set<MD5Hash> md5HashSet = DigestHelperUtils.getMd5HashSetFromItems(items);
                this.inDigestHelperUtils = false;
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                int md5ValuesCount = md5HashSet.size();
                this.addExecutionLog(this.iu.getNumeralString("AddItemsToDigestListOperation.Log.MDListSize", (long)md5ValuesCount));
                int invalidMd5sCount = DigestHelperUtils.getInvalidMd5sCount();
                if (invalidMd5sCount > 0) {
                    this.addWarning(this.iu.getNumeralString("AddItemsToDigestListOperation.Warning.Found", (long)invalidMd5sCount));
                }
                this.stageName = this.iu.getString("AddItemsToDigestListOperation.Stage.AddingMDToDigestList");
                try {
                    int addedCount = this.digestHelper.addToDigestList(this.digestListName, md5HashSet);
                    this.addExecutionLog(this.iu.getNumeralString("AddItemsToDigestListOperation.Log.Added", (long)addedCount));
                }
                catch (NoSuchFileException e) {
                    if (this.createIfDoesntExist) {
                        this.digestHelper.createDigestList(this.digestListName, this.digestLocation, md5HashSet);
                        this.addExecutionLog(this.iu.getNumeralFormattedString("AddItemsToDigestListOperation.Log.CreatedNewDigestListInLocation", (long)md5ValuesCount, (Object)this.digestLocation));
                    }
                    throw e;
                }
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.trackFinished();
            }
            catch (ParameterException e) {
                LOGGER.error("Error evaluating parameters", (Throwable)e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (IOException | IllegalArgumentException e) {
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected void resumeTriggered() {
    }

    @Override
    protected void pauseTriggered() {
    }

    @Override
    protected void stopTriggered() {
        this.digestHelper.requestStop();
    }

    @Override
    public void updateState() {
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        long itemsProcessed = 0L;
        if (this.inDigestHelperUtils) {
            itemsProcessed = DigestHelperUtils.getItemsProcessed();
        } else if (this.digestHelper != null) {
            itemsProcessed = this.digestHelper.getItemsProcessed();
        }
        if (itemsProcessed > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("AddItemsToDigestListOperation.Progress.ItemsProcessed", itemsProcessed);
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.digestHelper != null) {
            percentageComplete = (this.digestHelper.getExecutionProgress() + DigestHelperUtils.getExecutionProgress()) / 2.0;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }
}

