/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.AddToCompoundCaseOperation;
import com.nuix.automate.workflow.core.utils.nuix.DerbyControlUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.File;
import java.util.ArrayList;
import nuix.Case;
import nuix.CaseFactory;
import nuix.CompoundCase;
import nuix.DuplicateCaseException;
import org.joda.time.DateTimeZone;

public class AddToCompoundCaseOperationImplementation
extends AddToCompoundCaseOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddToCompoundCaseOperation.class);
    private transient String stageName;
    private transient long stageProgress;
    private transient DerbyControlUtils derbyControlUtils;

    public AddToCompoundCaseOperationImplementation() {
        this.childCaseLocations = new ArrayList();
    }

    @Override
    public void startTriggered() throws Exception {
        LOGGER.info("Starting execution");
        this.executionContext.closeAllTabs();
        this.stageName = "";
        this.stageProgress = 0L;
        this.startTriggerThread = new Thread(() -> {
            try {
                if (!this.executionContext.nuixCase.isCompound()) {
                    throw new Exception(this.iu.getFormattedString("AddToCompoundCaseOperation.Exception.CannotAddSubCases", (Object)this.executionContext.nuixCase.getLocation()));
                }
                this.derbyControlUtils = new DerbyControlUtils(this.executionContext, this);
                CaseFactory caseFactory = this.executionContext.nuixUtilities.getCaseFactory();
                String timeZoneId = null;
                String timezoneIdParameter = "{case_timezone_id}";
                String evaluatedTimezoneIdParameter = this.executionContext.evalParameters(timezoneIdParameter, this);
                if (!timezoneIdParameter.equals(evaluatedTimezoneIdParameter)) {
                    if (evaluatedTimezoneIdParameter.length() > 0) {
                        try {
                            DateTimeZone dateTimeZone = DateTimeZone.forID((String)evaluatedTimezoneIdParameter);
                            timeZoneId = dateTimeZone.getID();
                            LOGGER.info("Parsed specified timezone " + FormattingUtils.timeZoneToDisplayName((DateTimeZone)dateTimeZone) + " from ID " + timezoneIdParameter);
                        }
                        catch (Exception e) {
                            LOGGER.error("Cannot set timezone " + evaluatedTimezoneIdParameter, (Throwable)e);
                        }
                    } else {
                        timeZoneId = "";
                    }
                }
                for (String caseLocation : this.childCaseLocations) {
                    File caseDirectory = new File(this.executionContext.evalParameters(caseLocation, this).trim());
                    this.addExecutionLog(this.iu.getFormattedString("AddToCompoundCaseOperation.Log.AddingCase", (Object)caseDirectory.getAbsolutePath()));
                    this.stageName = this.iu.getFormattedString("AddToCompoundCaseOperation.Stage.AddingCase", (Object)caseDirectory.getName());
                    try {
                        this.derbyControlUtils.prepareExistingCase(caseDirectory.getAbsolutePath());
                        Case childCase = caseFactory.open(caseDirectory);
                        if (timeZoneId != null && timeZoneId.length() > 0) {
                            this.executionContext.nuixCase.setInvestigationTimeZone(timeZoneId);
                        }
                        boolean childCaseAlreadyExists = false;
                        for (Case existingChildCase : ((CompoundCase)this.executionContext.nuixCase).getChildCases()) {
                            if (!existingChildCase.getGuid().equals(childCase.getGuid())) continue;
                            childCaseAlreadyExists = true;
                            break;
                        }
                        if (childCaseAlreadyExists) {
                            LOGGER.info("Child case exists in compound case: " + caseDirectory.getPath());
                            this.addExecutionLog(this.iu.getString("AddToCompoundCaseOperation.Log.ChildCaseExistsInCompoundCase"));
                            childCase.close();
                            continue;
                        }
                        if (NuixUtils.disablePreviousProcessingQueue(caseDirectory.getAbsolutePath())) {
                            this.addWarning(this.iu.getFormattedString("AddToCompoundCaseOperation.Warning.CaseIncompleteProcessingQueue", (Object)caseDirectory.getAbsolutePath()));
                        }
                        if (NuixUtils.disablePreviousPersistentQueue(caseDirectory.getAbsolutePath())) {
                            this.addWarning(this.iu.getFormattedString("AddToCompoundCaseOperation.Warning.CaseIncompletePersistentQueue", (Object)caseDirectory.getAbsolutePath()));
                        }
                        ((CompoundCase)this.executionContext.nuixCase).addChildCase(childCase);
                    }
                    catch (DuplicateCaseException e) {
                        this.addWarning(e.getLocalizedMessage());
                    }
                    ++this.stageProgress;
                }
                if (!this.skipReloadingCompoundCase) {
                    this.addExecutionLog(this.iu.getString("AddToCompoundCaseOperation.Log.ReloadingCompoundCase"));
                    File compoundCaseLocation = this.executionContext.nuixCase.getLocation();
                    this.executionContext.closeNuixCase();
                    if (NuixUtils.disablePreviousProcessingQueue(compoundCaseLocation.getAbsolutePath())) {
                        this.addWarning(this.iu.getFormattedString("AddToCompoundCaseOperation.Warning.CaseIncompleteProcessingQueue", (Object)compoundCaseLocation.getAbsolutePath()));
                    }
                    if (NuixUtils.disablePreviousPersistentQueue(compoundCaseLocation.getAbsolutePath())) {
                        this.addWarning(this.iu.getFormattedString("AddToCompoundCaseOperation.Warning.CaseIncompletePersistentQueue", (Object)compoundCaseLocation.getAbsolutePath()));
                    }
                    this.derbyControlUtils.prepareExistingCase(compoundCaseLocation.getAbsolutePath());
                    this.executionContext.nuixCase = caseFactory.open(compoundCaseLocation);
                    if (timeZoneId != null && timeZoneId.length() > 0) {
                        this.executionContext.nuixCase.setInvestigationTimeZone(timeZoneId);
                        this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.Timezone", (Object)FormattingUtils.timeZoneToDisplayName((DateTimeZone)DateTimeZone.forID((String)timeZoneId))));
                    }
                } else {
                    this.addExecutionLog(this.iu.getString("AddToCompoundCaseOperation.Log.SkippingReloadingCompoundCase"));
                }
            }
            catch (Throwable e) {
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.childCaseLocations != null && this.childCaseLocations.size() > 0) {
            percentageComplete = (double)this.stageProgress / (double)this.childCaseLocations.size();
        }
        return percentageComplete;
    }
}

