/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.google.gson.annotations.JsonAdapter;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.BooleanOperator;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRadioButtonGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValue;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.productionset.InclusionStrategy;
import com.nuix.automate.workflow.core.execution.options.sorting.SortDirection;
import com.nuix.automate.workflow.core.execution.options.sorting.SortField;
import com.nuix.automate.workflow.core.execution.options.sorting.SortOrder;
import com.nuix.automate.workflow.core.execution.serialization.SortOrderAdapter;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldGroup(name="newProductionSetSettingsGroup", visibleOn={@OnField(name="createIfNotExistsOrFrozen")}, children={"productionSetDescription", "numberingSchemeRadioButtonGroup", "freezeProductionSet", "familyRow", "startNumberingAt", "boxRow", "folderRow", "pageRow", "pageDelimiter", "continuedNumbering"})
@FormFieldRadioButtonGroup(name="numberingSchemeRadioButtonGroup", componentType=FieldComponentType.RADIO_BUTTON_CHECKBOX_GROUP, positionLabel=@PositionLabel(left="numberingScheme"), values={@RadioButtonValue(value="", label="documentId"), @RadioButtonValue(value="familyNumbering"), @RadioButtonValue(value="filenameNumbering"), @RadioButtonValue(value="prefixPageNumbering"), @RadioButtonValue(value="prefixFolderPageNumbering"), @RadioButtonValue(value="prefixBoxFolderPageNumbering")})
@FormFieldRows(value={@FormFieldRow(name="familyRow", children={"documentIdPrefix", "documentIdDigits", "familySeparator", "familyDigits"}, visibleOn={@OnField(name="filenameNumbering", value={"false"})}), @FormFieldRow(name="boxRow", children={"documentIdBoxStart", "documentIdBoxCycleFrom", "documentIdBoxCycleTo"}, visibleOnOperator=BooleanOperator.OR, visibleOn={@OnField(name="prefixFolderPageNumbering"), @OnField(name="prefixBoxFolderPageNumbering")}, enableOn={@OnField(name="prefixBoxFolderPageNumbering")}), @FormFieldRow(name="folderRow", children={"documentIdFolderStart", "documentIdFolderCycleFrom", "documentIdFolderCycleTo"}, visibleOnOperator=BooleanOperator.OR, visibleOn={@OnField(name="prefixFolderPageNumbering"), @OnField(name="prefixBoxFolderPageNumbering")}), @FormFieldRow(name="pageRow", children={"documentIdPageStart", "documentIdPageCycleFrom", "documentIdPageCycleTo"}, visibleOnOperator=BooleanOperator.OR, visibleOn={@OnField(name="prefixFolderPageNumbering"), @OnField(name="prefixBoxFolderPageNumbering")})})
@OperationMetadata(alias=OperationAlias.ADD_TO_PRODUCTION_SET, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"PRODUCTION"})})
@OperationParameters(value={@OperationParameter(label="queryRetrieveAllItemsFrom", parameter="production-set:\"{last_production_set_name}\""), @OperationParameter(label="productionSetName", parameter="{last_production_set_name}")})
@OperationLicenseModule(module=ModuleType.WORKFLOW_LEGAL)
public class AddToProductionSetOperation
extends Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddToProductionSetOperation.class);
    @FormField(required=false)
    public String scope = "path-guid:{last_evidence_guid} AND flag:audited";
    @FormField
    public String productionSetName = "Production {date_time}";
    @FormField(allowedValues={"SELECTED_ITEMS"})
    @ExcludeFromPrintableOptions
    public InclusionStrategy inclusionStrategy = InclusionStrategy.SELECTED_ITEMS;
    @FormField
    public SortOrder sortOrder = SortOrder.TOP_LEVEL_ITEM_DATE;
    @JsonAdapter(value=SortOrderAdapter.class)
    @FormField(visibleOn={@OnField(name="sortOrder", value={"CUSTOM"})}, columnFields={@FormFieldColumn(label="field", componentType=FieldComponentType.DROPDOWN, enumClass=SortField.class), @FormFieldColumn(label="order", componentType=FieldComponentType.DROPDOWN, enumClass=SortDirection.class)})
    @ExcludeFromPrintableOptions
    public List<Object[]> sortFields;
    @FormField(visibleOn={@OnField(name="sortOrder", value={"METADATA_PROFILE"})})
    public String sortingMetadataProfileName = "";
    @FormField(componentType=FieldComponentType.RADIO_BUTTON)
    @ExcludeFromPrintableOptions
    public boolean createIfNotExistsOrFrozen = true;
    @FormField(componentType=FieldComponentType.TEXTAREA, required=false)
    public String productionSetDescription = "";
    @FormField
    @ExcludeFromPrintableOptions
    public boolean familyNumbering = false;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean filenameNumbering;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean prefixPageNumbering = false;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean prefixFolderPageNumbering = false;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean prefixBoxFolderPageNumbering = false;
    @FormField(enableOnOperator=BooleanOperator.AND, enableOn={@OnField(name="familyNumbering", value={"false"}), @OnField(name="filenameNumbering", value={"false"}), @OnField(name="prefixPageNumbering", value={"false"})})
    public boolean freezeProductionSet = false;
    @FormField(positionLabel=@PositionLabel(top="prefix"), visibleOn={@OnField(name="filenameNumbering", value={"false"})})
    @ExcludeFromPrintableOptions
    public String documentIdPrefix = "{case_prefix}";
    @FormField(min=1.0, positionLabel=@PositionLabel(top="numberingDigits"), visibleOn={@OnField(name="filenameNumbering", value={"false"}), @OnField(name="prefixFolderPageNumbering", value={"false"}), @OnField(name="prefixBoxFolderPageNumbering", value={"false"})})
    @ExcludeFromPrintableOptions
    public int documentIdDigits = 7;
    @FormField(componentType=FieldComponentType.DROPDOWN, allowedValues={".", "_", "-", " "}, positionLabel=@PositionLabel(top="separator"), enableOn={@OnField(name="familyNumbering")}, visibleOn={@OnField(name="filenameNumbering", value={"false"}), @OnField(name="prefixFolderPageNumbering", value={"false"}), @OnField(name="prefixBoxFolderPageNumbering", value={"false"})})
    @ExcludeFromPrintableOptions
    public String familySeparator = ".";
    @FormField(min=1.0, positionLabel=@PositionLabel(top="familyDigits"), enableOn={@OnField(name="familyNumbering")}, visibleOn={@OnField(name="filenameNumbering", value={"false"}), @OnField(name="prefixFolderPageNumbering", value={"false"}), @OnField(name="prefixBoxFolderPageNumbering", value={"false"})})
    @ExcludeFromPrintableOptions
    public int familyDigits = 3;
    @FormField(visibleOnOperator=BooleanOperator.AND, visibleOn={@OnField(name="filenameNumbering", value={"false"}), @OnField(name="prefixFolderPageNumbering", value={"false"}), @OnField(name="prefixBoxFolderPageNumbering", value={"false"})})
    @ExcludeFromPrintableOptions
    public int startNumberingAt = 1;
    @FormField(positionLabel=@PositionLabel(left="startAt"))
    @ExcludeFromPrintableOptions
    public int documentIdBoxStart = 1;
    @FormField(positionLabel=@PositionLabel(left="thenCycleFrom"))
    @ExcludeFromPrintableOptions
    public int documentIdBoxCycleFrom = 1;
    @FormField(min=1.0, positionLabel=@PositionLabel(left="to"))
    @ExcludeFromPrintableOptions
    public int documentIdBoxCycleTo = 999;
    @FormField(positionLabel=@PositionLabel(left="startAt"))
    @ExcludeFromPrintableOptions
    public int documentIdFolderStart = 1;
    @FormField(positionLabel=@PositionLabel(left="thenCycleFrom"))
    @ExcludeFromPrintableOptions
    public int documentIdFolderCycleFrom = 1;
    @FormField(min=1.0, positionLabel=@PositionLabel(left="to"))
    @ExcludeFromPrintableOptions
    public int documentIdFolderCycleTo = 999;
    @FormField(positionLabel=@PositionLabel(left="startAt"))
    @ExcludeFromPrintableOptions
    public int documentIdPageStart = 1;
    @FormField(positionLabel=@PositionLabel(left="thenCycleFrom"))
    @ExcludeFromPrintableOptions
    public int documentIdPageCycleFrom = 1;
    @FormField(min=1.0, positionLabel=@PositionLabel(left="to"))
    @ExcludeFromPrintableOptions
    public int documentIdPageCycleTo = 9000;
    @FormField(componentType=FieldComponentType.DROPDOWN, allowedValues={" ", ".", "-"}, visibleOnOperator=BooleanOperator.OR, visibleOn={@OnField(name="prefixFolderPageNumbering"), @OnField(name="prefixBoxFolderPageNumbering")})
    @ExcludeFromPrintableOptions
    public String pageDelimiter = ".";
    public boolean promptForNumberingAtExecution = false;
    @FormField(enableOnOperator=BooleanOperator.AND, enableOn={@OnField(name="familyNumbering", value={"false"}), @OnField(name="filenameNumbering", value={"false"})})
    public boolean continuedNumbering = true;

    public boolean getDisplaySortFields() {
        return this.createIfNotExistsOrFrozen && SortOrder.CUSTOM.equals((Object)this.sortOrder);
    }

    public boolean getDisplaySortingMetadataProfileName() {
        return this.createIfNotExistsOrFrozen && SortOrder.METADATA_PROFILE.equals((Object)this.sortOrder);
    }

    public boolean getDisplayProductionSetDescription() {
        return this.createIfNotExistsOrFrozen;
    }

    public boolean getDisplayFamilyNumbering() {
        return this.createIfNotExistsOrFrozen;
    }

    public boolean getDisplayFilenameNumbering() {
        return this.createIfNotExistsOrFrozen;
    }

    public boolean getDisplayPrefixPageNumbering() {
        return this.createIfNotExistsOrFrozen;
    }

    public boolean getDisplayPrefixFolderPageNumbering() {
        return this.createIfNotExistsOrFrozen;
    }

    public boolean getDisplayPrefixBoxFolderPageNumbering() {
        return this.createIfNotExistsOrFrozen;
    }

    public boolean getDisplayFreezeProductionSet() {
        return this.createIfNotExistsOrFrozen;
    }

    public boolean getDisplayDocumentIdPrefix() {
        return this.createIfNotExistsOrFrozen && !this.prefixPageNumbering && !this.prefixFolderPageNumbering && !this.prefixBoxFolderPageNumbering && !this.filenameNumbering;
    }

    public boolean getDisplayDocumentIdDigits() {
        return this.createIfNotExistsOrFrozen && !this.prefixPageNumbering && !this.prefixFolderPageNumbering && !this.prefixBoxFolderPageNumbering && !this.filenameNumbering;
    }

    public boolean getDisplayFamilySeparator() {
        return this.createIfNotExistsOrFrozen && this.familyNumbering;
    }

    public boolean getDisplayFamilyDigits() {
        return this.createIfNotExistsOrFrozen && this.familyNumbering;
    }

    public boolean getDisplayStartNumberingAt() {
        return this.createIfNotExistsOrFrozen && !this.prefixPageNumbering && !this.prefixFolderPageNumbering && !this.prefixBoxFolderPageNumbering && !this.filenameNumbering;
    }

    public boolean getDisplayDocumentIdBoxStart() {
        return this.createIfNotExistsOrFrozen && (this.prefixPageNumbering || this.prefixFolderPageNumbering || this.prefixBoxFolderPageNumbering);
    }

    public boolean getDisplayDocumentIdBoxCycleFrom() {
        return this.createIfNotExistsOrFrozen && (this.prefixPageNumbering || this.prefixFolderPageNumbering || this.prefixBoxFolderPageNumbering);
    }

    public boolean getDisplayDocumentIdBoxCycleTo() {
        return this.createIfNotExistsOrFrozen && (this.prefixPageNumbering || this.prefixFolderPageNumbering || this.prefixBoxFolderPageNumbering);
    }

    public boolean getDisplayDocumentIdFolderStart() {
        return this.createIfNotExistsOrFrozen && (this.prefixPageNumbering || this.prefixFolderPageNumbering || this.prefixBoxFolderPageNumbering);
    }

    public boolean getDisplayDocumentIdFolderCycleFrom() {
        return this.createIfNotExistsOrFrozen && (this.prefixPageNumbering || this.prefixFolderPageNumbering || this.prefixBoxFolderPageNumbering);
    }

    public boolean getDisplayDocumentIdFolderCycleTo() {
        return this.createIfNotExistsOrFrozen && (this.prefixPageNumbering || this.prefixFolderPageNumbering || this.prefixBoxFolderPageNumbering);
    }

    public boolean getDisplayDocumentIdPageStart() {
        return this.createIfNotExistsOrFrozen && (this.prefixPageNumbering || this.prefixFolderPageNumbering || this.prefixBoxFolderPageNumbering);
    }

    public boolean getDisplayDocumentIdPageCycleFrom() {
        return this.createIfNotExistsOrFrozen && (this.prefixPageNumbering || this.prefixFolderPageNumbering || this.prefixBoxFolderPageNumbering);
    }

    public boolean getDisplayDocumentIdPageCycleTo() {
        return this.createIfNotExistsOrFrozen && (this.prefixPageNumbering || this.prefixFolderPageNumbering || this.prefixBoxFolderPageNumbering);
    }

    public boolean getDisplayPageDelimiter() {
        return this.createIfNotExistsOrFrozen && (this.prefixPageNumbering || this.prefixFolderPageNumbering || this.prefixBoxFolderPageNumbering);
    }

    public boolean getDisplayPromptForNumberingAtExecution() {
        return this.createIfNotExistsOrFrozen;
    }

    public boolean getDisplayContinuedNumbering() {
        return this.createIfNotExistsOrFrozen && !this.prefixPageNumbering && !this.prefixFolderPageNumbering && !this.prefixBoxFolderPageNumbering && !this.filenameNumbering;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("AddToProductionSetOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.ADD_TO_PRODUCTION_SET;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.familyNumbering) {
            if (this.executionContext.nuixVersion.getMajor() < 7 || this.executionContext.nuixVersion.getMajor() == 7 && this.executionContext.nuixVersion.getMinor() < 4) {
                prerequisites.add(this.iu.getString("AddToProductionSetOperation.Prerequisites.FamilyDocumentIDNumberingRequires"));
            }
            if (this.continuedNumbering) {
                prerequisites.add(this.iu.getString("AddToProductionSetOperation.Prerequisites.FamilyDocumentIDNumberingNotSupported"));
            }
        }
        if ((activity == Operation.PrerequisitesActivity.RUN_UNATTENDED || activity == Operation.PrerequisitesActivity.SUBMIT_UNATTENDED) && this.promptForNumberingAtExecution) {
            prerequisites.add(this.iu.getString("AddToProductionSetOperation.Prerequisites.CannotUsePrompt"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        if (this.promptForNumberingAtExecution) {
            features.add(Feature.NUIX_WORKSTATION);
        } else {
            features.add(Feature.NUIX);
        }
        return features;
    }
}

