/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.AddToProductionSetOperation;
import com.nuix.automate.workflow.core.execution.options.sorting.SortDirection;
import com.nuix.automate.workflow.core.execution.options.sorting.SortOrder;
import com.nuix.automate.workflow.core.utils.general.ItemSortablePathNameExpression;
import com.nuix.automate.workflow.core.utils.general.StringCleaner;
import com.nuix.automate.workflow.core.utils.nuix.ComparableMetadataFieldItem;
import com.nuix.automate.workflow.core.utils.nuix.CustomFieldsItemExpression;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nuix.DocumentNumber;
import nuix.Item;
import nuix.ItemCustomMetadataMap;
import nuix.ItemEventCallback;
import nuix.ItemExpression;
import nuix.MetadataItem;
import nuix.MetadataProfile;
import nuix.ProductionSet;
import nuix.ProductionSetItem;
import org.apache.commons.lang3.NotImplementedException;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class AddToProductionSetOperationImplementation
extends AddToProductionSetOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddToProductionSetOperation.class);
    public transient String effectiveDocumentIdPrefix;
    private transient String effectiveFistDocumentId;
    private transient String effectiveLastDocumentId;
    private transient ProductionSet productionSet;
    private transient boolean productionSetExisted;
    private transient boolean productionSetFrozen;
    private transient String effectiveProductionSetName;
    private transient String addToProductionSetItemsStageName;
    private transient AtomicLong countItemsProcessed = new AtomicLong(0L);
    private transient long countTotalItems;
    private transient int stageCount;
    private transient int stageId;
    private transient boolean promptedForNumberingAtExecution;
    private transient String lastStageName;
    private transient long lastAddToProductionSetItemsProcessed;
    private transient Set<String> rubyFieldNames;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.productionSetName = this.executionContext.evalParameters(this.productionSetName, this);
        try {
            this.productionSetDescription = this.executionContext.evalParameters(this.productionSetDescription, this);
        }
        catch (ParameterException e) {
            this.addWarning(e.getLocalizedMessage());
        }
        this.startTriggerThread = new Thread(() -> {
            try {
                boolean detectedProductionSetsWithIncompatibleNames;
                HashMap<String, Object> addOptions;
                List items;
                block129: {
                    HashMap<String, Object> itemGuidToDocID;
                    boolean createdProductionSet;
                    block131: {
                        Iterator docId2;
                        HashMap<Object, String> docIdToGuid;
                        boolean docIdsWithoutNumberDetected;
                        boolean duplicateDocIdsDetected;
                        block127: {
                            Iterator iterator2;
                            int familyCount;
                            String previousTopLevelGuid;
                            long docIdNumber;
                            block126: {
                                ProductionSet previousProductionSet;
                                block130: {
                                    block128: {
                                        block124: {
                                            block125: {
                                                block123: {
                                                    block121: {
                                                        block122: {
                                                            try {
                                                                this.startNumberingAt = Integer.parseInt(this.executionContext.evalParameters("{docid_start_numbering_at}", this));
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_docid_start_numbering_at}", String.valueOf(this.startNumberingAt))));
                                                            try {
                                                                this.documentIdDigits = Integer.parseInt(this.executionContext.evalParameters("{docid_digits}", this));
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                            try {
                                                                this.familyDigits = Integer.parseInt(this.executionContext.evalParameters("{docid_family_digits}", this));
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                            try {
                                                                this.documentIdBoxStart = Integer.parseInt(this.executionContext.evalParameters("{box_start_at}", this));
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_box_start_at}", String.valueOf(this.documentIdBoxStart))));
                                                            try {
                                                                this.documentIdBoxCycleFrom = Integer.parseInt(this.executionContext.evalParameters("{box_cycle_from}", this));
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                            try {
                                                                this.documentIdBoxCycleTo = Integer.parseInt(this.executionContext.evalParameters("{box_cycle_to}", this));
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                            try {
                                                                this.documentIdFolderStart = Integer.parseInt(this.executionContext.evalParameters("{folder_start_at}", this));
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_folder_start_at}", String.valueOf(this.documentIdFolderStart))));
                                                            try {
                                                                this.documentIdFolderCycleFrom = Integer.parseInt(this.executionContext.evalParameters("{folder_cycle_from}", this));
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                            try {
                                                                this.documentIdFolderCycleTo = Integer.parseInt(this.executionContext.evalParameters("{folder_cycle_to}", this));
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                            try {
                                                                this.documentIdPageStart = Integer.parseInt(this.executionContext.evalParameters("{page_start_at}", this));
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_page_start_at}", String.valueOf(this.documentIdPageStart))));
                                                            try {
                                                                this.documentIdPageCycleFrom = Integer.parseInt(this.executionContext.evalParameters("{page_cycle_from}", this));
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                            try {
                                                                this.documentIdPageCycleTo = Integer.parseInt(this.executionContext.evalParameters("{page_cycle_to}", this));
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                            String pageDelimiterParameterValue = this.executionContext.evalParameters("{numbering_delimiter}", this);
                                                            if (!pageDelimiterParameterValue.equals("{numbering_delimiter}")) {
                                                                this.pageDelimiter = pageDelimiterParameterValue;
                                                            }
                                                            this.executionContext.closeAllTabs();
                                                            try {
                                                                this.productionSet = this.executionContext.nuixCase.findProductionSetByName(this.productionSetName);
                                                            }
                                                            catch (IOException e) {
                                                                LOGGER.error("Error finding Production Set by name", (Throwable)e);
                                                                this.exception = e;
                                                                this.executionState = ExecutionState.ERROR;
                                                                return;
                                                            }
                                                            this.productionSetExisted = this.productionSet != null;
                                                            LOGGER.info("Production Set existed: " + this.productionSetExisted);
                                                            if (this.productionSetExisted && this.productionSet.isFrozen()) {
                                                                LOGGER.info("ProductionSet '" + this.productionSetName + "' exists but it's frozen");
                                                                this.productionSetFrozen = true;
                                                                try {
                                                                    this.productionSet = this.getNextProductionSet();
                                                                    this.addWarning(this.iu.getFormattedString("AddToProductionSetOperation.Warning.RequestedProductionSet", new Object[]{this.productionSetName, this.effectiveProductionSetName}));
                                                                }
                                                                catch (IOException e) {
                                                                    LOGGER.error("Error getting next production set name", (Throwable)e);
                                                                    this.exception = e;
                                                                    this.executionState = ExecutionState.ERROR;
                                                                    return;
                                                                }
                                                                catch (ParameterException e) {
                                                                    LOGGER.error("Cannot get valid production set name", (Throwable)e);
                                                                    this.exception = e;
                                                                    this.executionState = ExecutionState.ERROR;
                                                                    return;
                                                                }
                                                            } else {
                                                                this.effectiveProductionSetName = this.productionSetName;
                                                            }
                                                            LOGGER.info("Effective Production Set name: " + this.effectiveProductionSetName);
                                                            this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.ProductionSetName", (Object)this.effectiveProductionSetName));
                                                            this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.ProductionSetExistedBefore", (Object)this.productionSetExisted));
                                                            createdProductionSet = false;
                                                            if (this.productionSetExisted && !this.productionSetFrozen) break block121;
                                                            if (!this.createIfNotExistsOrFrozen) break block122;
                                                            ProductionSet effectiveProductionSet = this.executionContext.nuixCase.findProductionSetByName(this.effectiveProductionSetName);
                                                            if (effectiveProductionSet == null) {
                                                                LOGGER.info("Creating Production Set");
                                                                HashMap<String, String> productionSetOptions = new HashMap<String, String>();
                                                                productionSetOptions.put("description", this.productionSetDescription);
                                                                try {
                                                                    this.productionSet = this.executionContext.nuixCase.newProductionSet(this.effectiveProductionSetName, productionSetOptions);
                                                                    createdProductionSet = true;
                                                                }
                                                                catch (IOException e) {
                                                                    LOGGER.error("Error creating new Production Set", (Throwable)e);
                                                                    this.exception = e;
                                                                    this.executionState = ExecutionState.ERROR;
                                                                    return;
                                                                }
                                                                LOGGER.info("Unpacking DocumentID prefix: " + this.documentIdPrefix);
                                                                try {
                                                                    this.effectiveDocumentIdPrefix = this.executionContext.evalParameters(this.documentIdPrefix, this);
                                                                }
                                                                catch (ParameterException e) {
                                                                    LOGGER.error("Cannot get valid document ID prefix", (Throwable)e);
                                                                    this.exception = e;
                                                                    this.executionState = ExecutionState.ERROR;
                                                                    return;
                                                                }
                                                                LOGGER.info("Cleaning DocumentID prefix: " + this.effectiveDocumentIdPrefix);
                                                                this.effectiveDocumentIdPrefix = StringCleaner.cleanDocumentIdPrefix(this.effectiveDocumentIdPrefix);
                                                                LOGGER.info("Cleaned DocumentID prefix: " + this.effectiveDocumentIdPrefix);
                                                            }
                                                            break block123;
                                                        }
                                                        if (!this.productionSetExisted) {
                                                            LOGGER.error("Production Set " + this.productionSetName + " does not exist");
                                                            this.exception = new Exception(this.iu.getFormattedString("AddToProductionSetOperation.Exception.ProductionSetNameDoesNotExist", (Object)this.productionSetName));
                                                            this.executionState = ExecutionState.ERROR;
                                                            return;
                                                        }
                                                        LOGGER.error("Production Set " + this.productionSetName + " was frozen");
                                                        this.exception = new Exception(this.iu.getFormattedString("AddToProductionSetOperation.Exception.ProductionSetNameWasFrozen", (Object)this.productionSetName));
                                                        this.executionState = ExecutionState.ERROR;
                                                        return;
                                                    }
                                                    Map productionSetNumberingOptions = this.productionSet.getNumberingOptions();
                                                    Object importedNumberingOption = productionSetNumberingOptions.get("imported");
                                                    if (importedNumberingOption != null) {
                                                        LOGGER.info("Existing production set has imported numbering scheme");
                                                        this.familyNumbering = true;
                                                    } else {
                                                        LOGGER.info("Existing production does not have imported numbering scheme");
                                                        this.familyNumbering = false;
                                                    }
                                                }
                                                this.stageCount = 3;
                                                if (this.sortOrder == SortOrder.POSITION || this.sortOrder == SortOrder.CUSTOM) {
                                                    ++this.stageCount;
                                                }
                                                this.stageId = 0;
                                                this.addToProductionSetItemsStageName = this.iu.getString("AddToProductionSetOperation.Stage.SearchingForItemsInScope");
                                                try {
                                                    HashMap<String, String> searchOptions = new HashMap<String, String>();
                                                    if (this.sortOrder == SortOrder.TOP_LEVEL_ITEM_DATE) {
                                                        searchOptions.put("order", "top-level-item-date ASC,top-level-guid ASC");
                                                    } else if (this.sortOrder == SortOrder.TOP_LEVEL_ITEMS_DESCENDING) {
                                                        searchOptions.put("order", "top-level-item-date DESC,top-level-guid ASC");
                                                    }
                                                    this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.ScopeQuery", (Object)this.scope));
                                                    String scopeQuery = NuixUtils.addAndQuery(this.scope, "has-exclusion:0");
                                                    LOGGER.info("Searching for " + scopeQuery);
                                                    items = this.executionContext.nuixCase.search(scopeQuery, searchOptions);
                                                    this.addExecutionLog(this.iu.getNumeralString("AddToProductionSetOperation.Log.ScopeCount", (long)items.size()));
                                                    MetadataProfile sortingProfile = null;
                                                    if (this.sortOrder == SortOrder.CUSTOM) {
                                                        Object sortOrderRepresentation = "";
                                                        for (Object[] sortFieldDetails : this.sortFields) {
                                                            if (((String)sortOrderRepresentation).length() > 0) {
                                                                sortOrderRepresentation = (String)sortOrderRepresentation + ", ";
                                                            }
                                                            sortOrderRepresentation = (String)sortOrderRepresentation + String.valueOf(sortFieldDetails[0]) + " (" + sortFieldDetails[1].toString().toLowerCase() + ")";
                                                        }
                                                        this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.SortOrder", sortOrderRepresentation));
                                                    } else if (this.sortOrder == SortOrder.METADATA_PROFILE) {
                                                        String evaluatedMetadataProfileName = this.executionContext.evalParameters(this.sortingMetadataProfileName, this);
                                                        this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.CustomSortingMetadataProfile", (Object)evaluatedMetadataProfileName));
                                                        sortingProfile = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, evaluatedMetadataProfileName);
                                                        if (sortingProfile == null) {
                                                            this.exception = new Exception(this.iu.getFormattedString("AddToProductionSetOperation.Warning.CannotFindMetadataProfile", (Object)evaluatedMetadataProfileName));
                                                            this.executionState = ExecutionState.ERROR;
                                                            return;
                                                        }
                                                        this.rubyFieldNames = new TreeSet<String>();
                                                        for (Object metadataItem : sortingProfile.getMetadata()) {
                                                            if (!MetadataItemUtils.isRubyScript((MetadataItem)metadataItem)) continue;
                                                            this.rubyFieldNames.add(metadataItem.getName());
                                                            LOGGER.info("Field " + metadataItem.getName() + " is scripted Ruby field");
                                                        }
                                                        if (this.rubyFieldNames.size() > 0) {
                                                            this.addWarning(this.iu.getFormattedString("MetadataExportOperation.Warning.RubyFields", (Object)String.join((CharSequence)", ", this.rubyFieldNames)));
                                                        }
                                                        StringBuilder sb = new StringBuilder();
                                                        for (MetadataItem metadataField : sortingProfile.getMetadata()) {
                                                            if (sb.length() > 0) {
                                                                sb.append(", ");
                                                            }
                                                            sb.append(metadataField.getName()).append("(").append(SortDirection.ASCENDING.toString().toLowerCase()).append(")");
                                                        }
                                                        this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.SortOrder", (Object)sb.toString()));
                                                    } else {
                                                        this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.SortOrder", (Object)this.sortOrder));
                                                    }
                                                    if (this.sortOrder == SortOrder.POSITION) {
                                                        ++this.stageId;
                                                        LOGGER.info("Sorting items");
                                                        this.addToProductionSetItemsStageName = this.iu.getString("AddToProductionSetOperation.Stage.SortingItems");
                                                        items = this.executionContext.versionGreaterOrEqualTo("8.0.0") ? this.executionContext.nuixUtilities.getItemUtility().sortItems((Collection)items, (ItemExpression)new ItemSortablePathNameExpression()) : this.executionContext.nuixUtilities.getItemSorter().sortItems(items, (ItemExpression)new ItemSortablePathNameExpression());
                                                    }
                                                    if (this.sortOrder == SortOrder.CUSTOM) {
                                                        ++this.stageId;
                                                        LOGGER.info("Sorting items");
                                                        this.addToProductionSetItemsStageName = this.iu.getString("AddToProductionSetOperation.Stage.SortingItems");
                                                        items = this.executionContext.versionGreaterOrEqualTo("8.0.0") ? this.executionContext.nuixUtilities.getItemUtility().sortItems((Collection)items, (ItemExpression)new CustomFieldsItemExpression(this.sortFields)) : this.executionContext.nuixUtilities.getItemSorter().sortItems(items, (ItemExpression)new CustomFieldsItemExpression(this.sortFields));
                                                    }
                                                    if (this.sortOrder == SortOrder.METADATA_PROFILE) {
                                                        ++this.stageId;
                                                        LOGGER.info("Sorting items");
                                                        this.addToProductionSetItemsStageName = this.iu.getString("AddToProductionSetOperation.Stage.SortingItems");
                                                        List profileMetadataItems = sortingProfile.getMetadata();
                                                        items = this.executionContext.versionGreaterOrEqualTo("8.0.0") ? this.executionContext.nuixUtilities.getItemUtility().sortItems((Collection)items, item -> new ComparableMetadataFieldItem(item, profileMetadataItems, this.rubyFieldNames)) : this.executionContext.nuixUtilities.getItemSorter().sortItems(items, item -> new ComparableMetadataFieldItem(item, profileMetadataItems, this.rubyFieldNames));
                                                    }
                                                }
                                                catch (IOException e) {
                                                    LOGGER.error("Error searching scope items: " + this.scope, (Throwable)e);
                                                    this.exception = e;
                                                    this.executionState = ExecutionState.ERROR;
                                                    return;
                                                }
                                                LOGGER.info("Scope items: " + items.size());
                                                addOptions = new HashMap<String, Object>();
                                                ItemEventCallback callback = itemEventInfo -> {
                                                    this.addToProductionSetItemsStageName = itemEventInfo.getStage();
                                                    this.countItemsProcessed.set(itemEventInfo.getStageCount());
                                                };
                                                addOptions.put("progress", callback);
                                                this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.InclusionStrategy", (Object)this.inclusionStrategy));
                                                switch (this.inclusionStrategy) {
                                                    case SELECTED_ITEMS: {
                                                        break;
                                                    }
                                                    case SELECTED_ITEMS_AND_DESCENDANTS: {
                                                        throw new NotImplementedException(this.iu.getString("AddToProductionSetOperation.Exception.InclusionStrategyNotSupported"));
                                                    }
                                                    case TOP_LEVEL_ITEMS: {
                                                        throw new NotImplementedException(this.iu.getString("AddToProductionSetOperation.Exception.InclusionStrategyNotSupported"));
                                                    }
                                                    case TOP_LEVEL_ITEMS_AND_DESCENDANTS: {
                                                        throw new NotImplementedException(this.iu.getString("AddToProductionSetOperation.Exception.InclusionStrategyNotSupported"));
                                                    }
                                                }
                                                ++this.stageId;
                                                this.countItemsProcessed = new AtomicLong();
                                                this.countTotalItems = items.size();
                                                this.addToProductionSetItemsStageName = "";
                                                detectedProductionSetsWithIncompatibleNames = false;
                                                if (!this.familyNumbering && !this.filenameNumbering) break block124;
                                                this.addToProductionSetItemsStageName = this.iu.getString("AddToProductionSetOperation.Stage.BuildingNumberingScheme");
                                                itemGuidToDocID = new HashMap<String, Object>();
                                                docIdNumber = this.startNumberingAt - 1;
                                                previousTopLevelGuid = "";
                                                if (!this.familyNumbering) break block125;
                                                this.addExecutionLog(this.iu.getString("AddToProductionSetOperation.Log.FamilyDocumentIDNumberingScheme"));
                                                familyCount = 1;
                                                iterator2 = items.iterator();
                                                break block126;
                                            }
                                            if (!this.filenameNumbering) throw new NotImplementedException(this.iu.getString("AddToProductionSetOperation.Exception.UnexpectedNumberingScheme"));
                                            this.addExecutionLog(this.iu.getString("AddToProductionSetOperation.Log.FilenameNumberingScheme"));
                                            duplicateDocIdsDetected = false;
                                            docIdsWithoutNumberDetected = false;
                                            docIdToGuid = new HashMap<Object, String>();
                                            docId2 = items.iterator();
                                            break block127;
                                        }
                                        if (!this.prefixFolderPageNumbering) break block128;
                                        this.addExecutionLog(this.iu.getString("AddToProductionSetOperation.Log.PrefixFolder"));
                                        if (createdProductionSet) {
                                            this.effectiveFistDocumentId = "";
                                            int nextFolderStart = this.documentIdFolderStart;
                                            int nextPageStart = this.documentIdPageStart;
                                            if (this.continuedNumbering && (previousProductionSet = this.findHighestNumberProductionSet(new HashSet<String>(Arrays.asList("PREFIX", "FOLDER", "PAGE")), new HashSet<String>(Arrays.asList("BOX")))) != null) {
                                                this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.ContinuingNumberingFrom", (Object)previousProductionSet.getName()));
                                                InternalDocumentNumber correctNextDocumentNumber = this.getCorrectNextDocumentNumberFolderPage(previousProductionSet);
                                                nextFolderStart = correctNextDocumentNumber.folder;
                                                nextPageStart = correctNextDocumentNumber.page;
                                            }
                                            Object sampleOutcomeTopLevel = this.effectiveDocumentIdPrefix;
                                            sampleOutcomeTopLevel = (String)sampleOutcomeTopLevel + this.pageDelimiter;
                                            sampleOutcomeTopLevel = (String)sampleOutcomeTopLevel + String.format("%0" + (1 + (int)Math.floor(Math.log10(this.documentIdFolderCycleTo))) + "d", nextFolderStart);
                                            sampleOutcomeTopLevel = (String)sampleOutcomeTopLevel + this.pageDelimiter;
                                            this.effectiveFistDocumentId = sampleOutcomeTopLevel = (String)sampleOutcomeTopLevel + String.format("%0" + (1 + (int)Math.floor(Math.log10(this.documentIdPageCycleTo))) + "d", nextPageStart);
                                            HashMap<String, Object> numberingOptions = new HashMap<String, Object>();
                                            numberingOptions.put("prefix", this.effectiveDocumentIdPrefix);
                                            numberingOptions.put("delimiter", this.pageDelimiter);
                                            numberingOptions.put("groupDocumentPages", true);
                                            numberingOptions.put("groupFamilyItems", true);
                                            HashMap<String, Integer> folderOptions = new HashMap<String, Integer>();
                                            folderOptions.put("minWidth", 1 + (int)Math.floor(Math.log10(this.documentIdFolderCycleTo)));
                                            folderOptions.put("from", this.documentIdFolderCycleFrom);
                                            folderOptions.put("to", this.documentIdFolderCycleTo);
                                            folderOptions.put("startAt", nextFolderStart);
                                            numberingOptions.put("folder", folderOptions);
                                            HashMap<String, Integer> pageOptions = new HashMap<String, Integer>();
                                            pageOptions.put("minWidth", 1 + (int)Math.floor(Math.log10(this.documentIdPageCycleTo)));
                                            pageOptions.put("from", this.documentIdPageCycleFrom);
                                            pageOptions.put("to", this.documentIdPageCycleTo);
                                            pageOptions.put("startAt", nextPageStart);
                                            numberingOptions.put("page", pageOptions);
                                            this.handleGroupFamilyItemsParameter(numberingOptions);
                                            this.productionSet.setNumberingOptions(numberingOptions);
                                        }
                                        break block129;
                                    }
                                    if (!this.prefixBoxFolderPageNumbering) break block130;
                                    this.addExecutionLog(this.iu.getString("AddToProductionSetOperation.Log.PrefixMultiple"));
                                    if (createdProductionSet) {
                                        ProductionSet previousProductionSet2;
                                        this.effectiveFistDocumentId = "";
                                        int nextBoxStart = this.documentIdBoxStart;
                                        int nextFolderStart = this.documentIdFolderStart;
                                        int nextPageStart = this.documentIdPageStart;
                                        if (this.continuedNumbering && (previousProductionSet2 = this.findHighestNumberProductionSet(new HashSet<String>(Arrays.asList("PREFIX", "BOX", "FOLDER", "PAGE")), new HashSet<String>(Arrays.asList(new String[0])))) != null) {
                                            this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.ContinuingNumberingFrom", (Object)previousProductionSet2.getName()));
                                            InternalDocumentNumber correctNextDocumentNumber = this.getCorrectNextDocumentNumberBoxFolderPage(previousProductionSet2);
                                            nextBoxStart = correctNextDocumentNumber.box;
                                            nextFolderStart = correctNextDocumentNumber.folder;
                                            nextPageStart = correctNextDocumentNumber.page;
                                        }
                                        Object sampleOutcomeTopLevel = this.effectiveDocumentIdPrefix;
                                        sampleOutcomeTopLevel = (String)sampleOutcomeTopLevel + this.pageDelimiter;
                                        sampleOutcomeTopLevel = (String)sampleOutcomeTopLevel + String.format("%0" + (1 + (int)Math.floor(Math.log10(this.documentIdBoxCycleTo))) + "d", nextBoxStart);
                                        sampleOutcomeTopLevel = (String)sampleOutcomeTopLevel + this.pageDelimiter;
                                        sampleOutcomeTopLevel = (String)sampleOutcomeTopLevel + String.format("%0" + (1 + (int)Math.floor(Math.log10(this.documentIdFolderCycleTo))) + "d", nextFolderStart);
                                        sampleOutcomeTopLevel = (String)sampleOutcomeTopLevel + this.pageDelimiter;
                                        this.effectiveFistDocumentId = sampleOutcomeTopLevel = (String)sampleOutcomeTopLevel + String.format("%0" + (1 + (int)Math.floor(Math.log10(this.documentIdPageCycleTo))) + "d", nextPageStart);
                                        HashMap<String, Object> numberingOptions = new HashMap<String, Object>();
                                        numberingOptions.put("prefix", this.effectiveDocumentIdPrefix);
                                        numberingOptions.put("delimiter", this.pageDelimiter);
                                        numberingOptions.put("groupDocumentPages", true);
                                        numberingOptions.put("groupFamilyItems", true);
                                        HashMap<String, Integer> boxOptions = new HashMap<String, Integer>();
                                        boxOptions.put("minWidth", 1 + (int)Math.floor(Math.log10(this.documentIdBoxCycleTo)));
                                        boxOptions.put("from", this.documentIdBoxCycleFrom);
                                        boxOptions.put("to", this.documentIdBoxCycleTo);
                                        boxOptions.put("startAt", nextBoxStart);
                                        numberingOptions.put("box", boxOptions);
                                        HashMap<String, Integer> folderOptions = new HashMap<String, Integer>();
                                        folderOptions.put("minWidth", 1 + (int)Math.floor(Math.log10(this.documentIdFolderCycleTo)));
                                        folderOptions.put("from", this.documentIdFolderCycleFrom);
                                        folderOptions.put("to", this.documentIdFolderCycleTo);
                                        folderOptions.put("startAt", nextFolderStart);
                                        numberingOptions.put("folder", folderOptions);
                                        HashMap<String, Integer> pageOptions = new HashMap<String, Integer>();
                                        pageOptions.put("minWidth", 1 + (int)Math.floor(Math.log10(this.documentIdPageCycleTo)));
                                        pageOptions.put("from", this.documentIdPageCycleFrom);
                                        pageOptions.put("to", this.documentIdPageCycleTo);
                                        pageOptions.put("startAt", nextPageStart);
                                        numberingOptions.put("page", pageOptions);
                                        this.handleGroupFamilyItemsParameter(numberingOptions);
                                        this.productionSet.setNumberingOptions(numberingOptions);
                                    }
                                    break block129;
                                }
                                if (this.prefixPageNumbering) {
                                    this.addExecutionLog(this.iu.getString("AddToProductionSetOperation.Log.PrefixBase"));
                                    if (createdProductionSet) {
                                        ProductionSet previousProductionSet3;
                                        int nextStartNumberingAt = this.startNumberingAt;
                                        if (this.continuedNumbering && (previousProductionSet3 = this.findHighestNumberProductionSet(new HashSet<String>(Arrays.asList("PREFIX", "PAGE")), new HashSet<String>(Arrays.asList("BOX", "FOLDER")))) != null) {
                                            this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.ContinuingNumberingFrom", (Object)previousProductionSet3.getName()));
                                            nextStartNumberingAt = (Integer)previousProductionSet3.getNextDocumentNumber().getComponent("PAGE");
                                        }
                                        HashMap<String, Object> numberingOptions = new HashMap<String, Object>();
                                        numberingOptions.put("delimiter", "");
                                        numberingOptions.put("prefix", this.effectiveDocumentIdPrefix);
                                        long maxDocId = (long)(Math.pow(10.0, this.documentIdDigits) - 1.0);
                                        HashMap<String, Number> pageOptions = new HashMap<String, Number>();
                                        pageOptions.put("minWidth", this.documentIdDigits);
                                        pageOptions.put("from", nextStartNumberingAt);
                                        pageOptions.put("to", maxDocId);
                                        pageOptions.put("startAt", nextStartNumberingAt);
                                        numberingOptions.put("page", pageOptions);
                                        this.handleGroupFamilyItemsParameter(numberingOptions);
                                        this.productionSet.setNumberingOptions(numberingOptions);
                                    }
                                    break block129;
                                } else {
                                    this.addExecutionLog(this.iu.getString("AddToProductionSetOperation.Log.DocumentIDNumberingScheme"));
                                    if (createdProductionSet) {
                                        int documentIdNumberPadding = this.documentIdDigits;
                                        int nextStartNumberingAt = this.startNumberingAt;
                                        if (this.continuedNumbering && (previousProductionSet = this.findHighestNumberProductionSet(new HashSet<String>(Arrays.asList("PREFIX", "DOCUMENT_ID")), new HashSet<String>(Arrays.asList("PAGE", "BOX", "FOLDER")))) != null) {
                                            this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.ContinuingNumberingFrom", (Object)previousProductionSet.getName()));
                                            nextStartNumberingAt = ((Long)previousProductionSet.getNextDocumentNumber().getComponent("DOCUMENT_ID")).intValue();
                                        }
                                        LOGGER.info("promptForNumberingAtExecution: " + this.promptForNumberingAtExecution);
                                        HashMap<String, Object> numberingOptions = new HashMap<String, Object>();
                                        HashMap<String, Object> documentId = new HashMap<String, Object>();
                                        numberingOptions.put("prefix", this.effectiveDocumentIdPrefix);
                                        documentId.put("documentId", String.format("%0" + documentIdNumberPadding + "d", nextStartNumberingAt));
                                        documentId.put("minWidth", documentIdNumberPadding);
                                        documentId.put("startAt", nextStartNumberingAt);
                                        numberingOptions.put("documentId", documentId);
                                        LOGGER.info("Setting numbering options " + String.valueOf(numberingOptions));
                                        this.productionSet.setNumberingOptions(numberingOptions);
                                    }
                                    this.stageCount -= 2;
                                }
                                break block129;
                            }
                            while (iterator2.hasNext()) {
                                Item item2 = (Item)iterator2.next();
                                if (this.stopRequested) {
                                    this.trackStopped();
                                    return;
                                }
                                if (!item2.getTopLevelItem().getGuid().equals(previousTopLevelGuid)) {
                                    previousTopLevelGuid = item2.getTopLevelItem().getGuid();
                                    ++docIdNumber;
                                    familyCount = 1;
                                }
                                Object docId2 = "";
                                if (item2.isTopLevel()) {
                                    docId2 = this.effectiveDocumentIdPrefix + String.format("%0" + this.documentIdDigits + "d", docIdNumber);
                                } else {
                                    docId2 = this.effectiveDocumentIdPrefix + String.format("%0" + this.documentIdDigits + "d", docIdNumber) + this.familySeparator + String.format("%0" + this.familyDigits + "d", familyCount);
                                    ++familyCount;
                                }
                                if (this.effectiveFistDocumentId == null) {
                                    this.effectiveFistDocumentId = docId2;
                                }
                                this.effectiveLastDocumentId = docId2;
                                itemGuidToDocID.put(item2.getGuid(), docId2);
                                this.countItemsProcessed.incrementAndGet();
                            }
                            break block131;
                        }
                        while (docId2.hasNext()) {
                            Item item3 = (Item)docId2.next();
                            if (this.stopRequested) {
                                this.trackStopped();
                                return;
                            }
                            String fileName = item3.getName();
                            try {
                                Item parent = (Item)item3.getParent();
                                if (parent.getType().getName().equals("application/vnd.ms-outlook-msg")) {
                                    fileName = parent.getName();
                                }
                            }
                            catch (Exception e) {
                                LOGGER.warn("Cannot get MSG name from parent");
                            }
                            int i = fileName.lastIndexOf(46);
                            Object docId3 = i > 0 ? fileName.substring(0, i) : fileName;
                            if (((String)docId3).length() == 0) {
                                docId3 = "DOC";
                            }
                            int number = 1;
                            Object prefix = "DOC";
                            String originalDocId = docId3;
                            Pattern pattern = Pattern.compile(".{0,32}(\\d+)");
                            Matcher matcher = pattern.matcher((CharSequence)docId3);
                            if (!matcher.matches()) {
                                docIdsWithoutNumberDetected = true;
                                prefix = docId3 = originalDocId + ".001";
                            } else {
                                String sNumber = matcher.group(1);
                                number = Integer.parseInt(sNumber);
                                prefix = ((String)docId3).substring(0, ((String)docId3).length() - sNumber.length());
                            }
                            if (LOGGER.isDebugEnabled()) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("GUID:: " + item3.getGuid());
                                }
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("fileName: " + fileName);
                                }
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("DocID: " + (String)docId3);
                                }
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("DocID with number: " + originalDocId);
                                }
                            }
                            boolean duplicateDocId = false;
                            if (docIdToGuid.containsKey(originalDocId)) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Unique: No");
                                }
                                duplicateDocId = true;
                                String previousDocId = originalDocId;
                                String previousGuid = (String)docIdToGuid.get(previousDocId);
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Previous GUID: " + previousGuid);
                                }
                                docIdToGuid.put(previousDocId + ".001", previousGuid);
                                itemGuidToDocID.remove(previousGuid);
                                itemGuidToDocID.put(previousGuid, previousDocId + ".001");
                            } else if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Unique: Yes");
                            }
                            int counter = 2;
                            while (duplicateDocId || docIdToGuid.containsKey(docId3)) {
                                duplicateDocId = false;
                                duplicateDocIdsDetected = true;
                                docId3 = originalDocId + "." + String.format("%03d", counter);
                                ++counter;
                            }
                            docIdToGuid.put(docId3, item3.getGuid());
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Final DocID: " + (String)docId3);
                            }
                            itemGuidToDocID.put(item3.getGuid(), docId3);
                            this.countItemsProcessed.incrementAndGet();
                            if (!LOGGER.isDebugEnabled()) continue;
                            LOGGER.debug("---");
                        }
                        if (duplicateDocIdsDetected) {
                            this.addWarning(this.iu.getString("AddToProductionSetOperation.Warning.DuplicateDocIDsDetected"));
                        }
                        if (docIdsWithoutNumberDetected) {
                            this.addWarning(this.iu.getString("AddToProductionSetOperation.Warning.DocIDsWithNoNumbersDetected"));
                        }
                    }
                    ++this.stageId;
                    this.countItemsProcessed = new AtomicLong();
                    this.addToProductionSetItemsStageName = this.iu.getString("AddToProductionSetOperation.Stage.AssigningNumbers");
                    FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)items, ItemsUtils.getPartitionerChunkSize(1000, this));
                    Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        while (iterator.hasNext()) {
                            Item item = (Item)iterator.next();
                            ItemCustomMetadataMap itemCustomMetadataMap = item.getCustomMetadata();
                            itemCustomMetadataMap.put((Object)"Item Number", itemGuidToDocID.get(item.getGuid()));
                            this.countItemsProcessed.incrementAndGet();
                        }
                    }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                    if (this.stopRequested) {
                        this.trackStopped();
                        return;
                    }
                    ++this.stageId;
                    this.addToProductionSetItemsStageName = "";
                    this.countItemsProcessed = new AtomicLong();
                    if (createdProductionSet) {
                        HashMap numberingOptions = new HashMap();
                        numberingOptions.put("imported", new HashMap());
                        this.productionSet.setNumberingOptions(numberingOptions);
                        addOptions.put("importFromItemNumber", true);
                    }
                }
                if (this.promptedForNumberingAtExecution) {
                    this.addExecutionLog(this.iu.getString("AddToProductionSetOperation.Log.PromptedUserForNumbering"));
                }
                if (detectedProductionSetsWithIncompatibleNames) {
                    this.addWarning(this.iu.getString("AddToProductionSetOperation.Warning.DetectedAtLeastOneProductionSet"));
                }
                if (items.size() == 0) {
                    this.addWarning(this.iu.getString("AddToProductionSetOperation.Warning.NoItemsMatchedSearchQuery"));
                } else {
                    this.productionSet.addItems((Collection)items, addOptions);
                    if (this.freezeProductionSet) {
                        LOGGER.info("Freezing production set");
                        this.productionSet.freeze();
                    }
                }
                String firstDocument = this.effectiveFistDocumentId;
                if (firstDocument == null) {
                    try {
                        firstDocument = this.productionSet.getFirstDocumentNumber().toString();
                    }
                    catch (Exception nextStartNumberingAt) {
                        // empty catch block
                    }
                }
                if (firstDocument != null) {
                    this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.FirstDocumentID", (Object)firstDocument));
                }
                String nextDocument = "N/A";
                try {
                    nextDocument = this.productionSet.getNextDocumentNumber().toString();
                    this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.NextDocumentID", (Object)nextDocument));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.effectiveLastDocumentId != null) {
                    this.addExecutionLog(this.iu.getFormattedString("AddToProductionSetOperation.Log.LastDocumentID", (Object)this.effectiveLastDocumentId));
                }
                if (this.productionSet != null) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{automate_add_to_production_set}", this.productionSet.getName())));
                }
                this.trackFinished();
                return;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private ProductionSet getNextProductionSet() throws IOException, ParameterException {
        this.effectiveProductionSetName = this.productionSetName.length() == 0 ? "Production {date} 1" : this.productionSetName;
        String productionSetNamePrefix = this.effectiveProductionSetName = this.executionContext.evalParameters(this.effectiveProductionSetName, this);
        ProductionSet existingProductionSet = this.executionContext.nuixCase.findProductionSetByName(this.effectiveProductionSetName);
        boolean productionSetNameValid = existingProductionSet == null || !existingProductionSet.isFrozen();
        int productionSetNameCounter = 1;
        String[] splits = this.effectiveProductionSetName.split(" ");
        if (splits.length > 1) {
            String lastSplit = splits[splits.length - 1];
            try {
                String tempProductionSetNamePrefix = this.effectiveProductionSetName.substring(0, this.effectiveProductionSetName.length() - lastSplit.length() - 1);
                productionSetNameCounter = Integer.parseInt(lastSplit);
                productionSetNamePrefix = tempProductionSetNamePrefix;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        while (!productionSetNameValid) {
            LOGGER.warn("Production Set name '" + this.effectiveProductionSetName + "' is not unique");
            this.effectiveProductionSetName = productionSetNamePrefix + " " + ++productionSetNameCounter;
            existingProductionSet = this.executionContext.nuixCase.findProductionSetByName(this.effectiveProductionSetName);
            productionSetNameValid = existingProductionSet == null || !existingProductionSet.isFrozen();
        }
        return existingProductionSet;
    }

    private ProductionSet findHighestNumberProductionSet(Set<String> requiredComponents, Set<String> forbiddenComponents) {
        ProductionSet candidate = null;
        if (this.continuedNumbering) {
            LOGGER.info("Attempting to extract previous DocumentID");
            List existingProductionSets = null;
            try {
                existingProductionSets = this.executionContext.nuixCase.getProductionSets();
                for (ProductionSet existingProductionSet : existingProductionSets) {
                    try {
                        if (existingProductionSet.getName().equals(this.productionSet.getName())) continue;
                        DocumentNumber documentNumber = null;
                        documentNumber = existingProductionSet.getNextDocumentNumber();
                        LOGGER.info("Testing " + existingProductionSet.getName() + " next number " + String.valueOf(documentNumber));
                        boolean eligible = true;
                        String existingPrefix = (String)documentNumber.getComponent("PREFIX");
                        if (!existingPrefix.equals(this.effectiveDocumentIdPrefix)) {
                            LOGGER.info("\tPrefix mismatch, got " + existingPrefix + " vs. expected " + this.effectiveDocumentIdPrefix);
                            eligible = false;
                        }
                        HashSet componentNames = new HashSet(documentNumber.getComponentNames());
                        if (eligible) {
                            for (String componentName : componentNames) {
                                if (!forbiddenComponents.contains(componentName)) continue;
                                eligible = false;
                                LOGGER.info("\tUnexpected component " + componentName);
                                break;
                            }
                        }
                        if (eligible) {
                            for (String componentName : requiredComponents) {
                                if (componentNames.contains(componentName)) continue;
                                LOGGER.info("\tMissing required component " + componentName);
                                eligible = false;
                                break;
                            }
                        }
                        if (!eligible) continue;
                        LOGGER.info("\tMatch");
                        if (candidate == null) {
                            LOGGER.info("\tTracking number");
                            candidate = existingProductionSet;
                            continue;
                        }
                        if (existingProductionSet.getNextDocumentNumber().toString().compareTo(candidate.getNextDocumentNumber().toString()) > 0) {
                            LOGGER.info("\tTracking number");
                            candidate = existingProductionSet;
                            continue;
                        }
                        LOGGER.info("\tNumber lower than previous highest");
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not extract next Document ID number from Production Set " + existingProductionSet.getName(), (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warn("Could not get Production Sets", (Throwable)e);
            }
        }
        return candidate;
    }

    private InternalDocumentNumber getCorrectNextDocumentNumberBoxFolderPage(ProductionSet previousProductionSet) {
        boolean nextDocumentNumberOverflowed;
        Integer nextPageNumber;
        Integer nextFolderNumber;
        int nextBoxStart = this.documentIdBoxStart;
        int nextFolderStart = this.documentIdFolderStart;
        int nextPageStart = this.documentIdPageStart;
        DocumentNumber nextDocumentNumber = previousProductionSet.getNextDocumentNumber();
        Integer nextBoxNumber = (Integer)nextDocumentNumber.getComponent("BOX");
        if (nextBoxNumber != null) {
            nextBoxStart = nextBoxNumber;
        }
        if ((nextFolderNumber = (Integer)nextDocumentNumber.getComponent("FOLDER")) != null) {
            nextFolderStart = nextFolderNumber;
        }
        if ((nextPageNumber = (Integer)nextDocumentNumber.getComponent("PAGE")) != null) {
            nextPageStart = nextPageNumber;
        }
        boolean bl = nextDocumentNumberOverflowed = nextPageStart > this.documentIdPageCycleTo || nextFolderStart > this.documentIdFolderCycleTo || nextBoxStart > this.documentIdBoxCycleTo;
        if (nextDocumentNumberOverflowed) {
            LOGGER.info("Detected next document ID numbering overflow: " + String.valueOf(previousProductionSet.getNextDocumentNumber()) + ", determining correct next document ID numbering");
            for (ProductionSetItem productionSetItem : previousProductionSet.getProductionSetItems()) {
                DocumentNumber documentNumber = productionSetItem.getDocumentNumber();
                Integer boxNumber = (Integer)documentNumber.getComponent("BOX");
                Integer folderNumber = (Integer)documentNumber.getComponent("FOLDER");
                Integer pageNumber = (Integer)documentNumber.getComponent("PAGE");
                if (boxNumber != null && boxNumber > nextBoxStart) {
                    nextBoxStart = boxNumber;
                    nextFolderStart = -1;
                }
                if (boxNumber == null || boxNumber != nextBoxStart) continue;
                if (folderNumber != null && folderNumber > nextFolderStart) {
                    nextFolderStart = folderNumber;
                    nextPageStart = -1;
                }
                if (folderNumber == null || folderNumber != nextFolderStart || pageNumber == null || pageNumber <= nextPageStart) continue;
                nextPageStart = pageNumber;
            }
            ++nextPageStart;
        }
        if (nextPageStart > this.documentIdPageCycleTo) {
            nextPageStart = this.documentIdPageStart;
            ++nextFolderStart;
        }
        if (nextFolderStart > this.documentIdFolderCycleTo) {
            nextFolderStart = this.documentIdFolderStart;
            ++nextBoxStart;
        }
        if (nextBoxStart > this.documentIdBoxCycleTo) {
            LOGGER.warn("Overflowed production set document box number");
        }
        LOGGER.info("Correct next document ID numbering: " + this.effectiveDocumentIdPrefix + this.pageDelimiter + nextBoxNumber + this.pageDelimiter + nextFolderStart + this.pageDelimiter + nextPageStart);
        return new InternalDocumentNumber(nextBoxStart, nextFolderStart, nextPageStart);
    }

    private InternalDocumentNumber getCorrectNextDocumentNumberFolderPage(ProductionSet previousProductionSet) {
        boolean nextDocumentNumberOverflowed;
        Integer nextPageNumber;
        int nextFolderStart = this.documentIdFolderStart;
        int nextPageStart = this.documentIdPageStart;
        DocumentNumber nextDocumentNumber = previousProductionSet.getNextDocumentNumber();
        Integer nextFolderNumber = (Integer)nextDocumentNumber.getComponent("FOLDER");
        if (nextFolderNumber != null) {
            nextFolderStart = nextFolderNumber;
        }
        if ((nextPageNumber = (Integer)nextDocumentNumber.getComponent("PAGE")) != null) {
            nextPageStart = nextPageNumber;
        }
        boolean bl = nextDocumentNumberOverflowed = nextPageStart > this.documentIdPageCycleTo || nextFolderStart > this.documentIdFolderCycleTo;
        if (nextDocumentNumberOverflowed) {
            LOGGER.info("Detected next document ID numbering overflow: " + String.valueOf(previousProductionSet.getNextDocumentNumber()) + ", determining correct next document ID numbering");
            for (ProductionSetItem productionSetItem : previousProductionSet.getProductionSetItems()) {
                DocumentNumber documentNumber = productionSetItem.getDocumentNumber();
                Integer folderNumber = (Integer)documentNumber.getComponent("FOLDER");
                Integer pageNumber = (Integer)documentNumber.getComponent("PAGE");
                if (folderNumber != null && folderNumber > nextFolderStart) {
                    nextFolderStart = folderNumber;
                    nextPageStart = -1;
                }
                if (folderNumber == null || folderNumber != nextFolderStart || pageNumber == null || pageNumber <= nextPageStart) continue;
                nextPageStart = pageNumber;
            }
            ++nextPageStart;
        }
        if (nextPageStart > this.documentIdPageCycleTo) {
            nextPageStart = this.documentIdPageStart;
            ++nextFolderStart;
        }
        if (nextFolderStart > this.documentIdFolderCycleTo) {
            LOGGER.warn("Overflowed production set document folder number");
        }
        LOGGER.info("Correct next document ID numbering: " + this.effectiveDocumentIdPrefix + this.pageDelimiter + nextFolderStart + this.pageDelimiter + nextPageStart);
        return new InternalDocumentNumber(0, nextFolderStart, nextPageStart);
    }

    private void handleGroupFamilyItemsParameter(Map<String, Object> numberingOptions) throws ParameterException {
        String evaluatedGroupDocumentPagesParameter;
        String groupDocumentPagesParameter;
        String groupFamilyItemsParameter = "{group_family_items}";
        String evaluatedGroupFamilyItemsParameter = this.executionContext.evalParameters(groupFamilyItemsParameter, this);
        if (!groupFamilyItemsParameter.equals(evaluatedGroupFamilyItemsParameter)) {
            try {
                boolean groupFamilyItems = Boolean.parseBoolean(evaluatedGroupFamilyItemsParameter);
                numberingOptions.put("groupFamilyItems", groupFamilyItems);
                this.addExecutionLog(this.iu.getFormattedString("ProductionSetOperation.Log.CustomGroupFamilyItems", new Object[]{groupFamilyItemsParameter, groupFamilyItems}));
            }
            catch (Exception e) {
                LOGGER.warn("Parameter " + groupFamilyItemsParameter + " value " + evaluatedGroupFamilyItemsParameter + " cannot be parsed as boolean");
            }
        }
        if (!(groupDocumentPagesParameter = "{group_document_pages}").equals(evaluatedGroupDocumentPagesParameter = this.executionContext.evalParameters(groupDocumentPagesParameter, this))) {
            try {
                boolean groupDocumentPages = Boolean.parseBoolean(evaluatedGroupDocumentPagesParameter);
                numberingOptions.put("groupDocumentPages", groupDocumentPages);
                this.addExecutionLog(this.iu.getFormattedString("ProductionSetOperation.Log.CustomGroupDocumentPages", new Object[]{groupDocumentPagesParameter, groupDocumentPages}));
            }
            catch (Exception e) {
                LOGGER.warn("Parameter " + groupDocumentPagesParameter + " value " + evaluatedGroupDocumentPagesParameter + " cannot be parsed as boolean");
            }
        }
    }

    @Override
    public void stopTriggered() {
        this.stopRequested = true;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        result = String.format("%.2f%%", percentageComplete * 100.0);
        if (this.addToProductionSetItemsStageName != null && this.addToProductionSetItemsStageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + FormattingUtils.stageToString((String)this.addToProductionSetItemsStageName);
        }
        if (this.countItemsProcessed != null && this.countItemsProcessed.get() > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("AddToProductionSetOperation.Progress.ItemsProcessed", this.countItemsProcessed.get());
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        double percentage = 0.0;
        double stagePercentage = 0.0;
        if (this.countTotalItems > 0L && this.countItemsProcessed != null) {
            stagePercentage = (double)this.countItemsProcessed.get() / (double)this.countTotalItems;
            stagePercentage = Math.min(stagePercentage, 0.9999);
        }
        double addToProductionSetStageCount = this.familyNumbering ? (double)(this.stageCount + 1) : (double)(this.stageCount + 2);
        if (this.addToProductionSetItemsStageName != null) {
            switch (this.addToProductionSetItemsStageName) {
                case "export_item_discovering": {
                    percentage = ((double)this.stageId + 0.0) / addToProductionSetStageCount + stagePercentage / addToProductionSetStageCount;
                    break;
                }
                case "item_set_assigning": {
                    percentage = ((double)this.stageId + 1.0) / addToProductionSetStageCount + stagePercentage / addToProductionSetStageCount;
                    break;
                }
                default: {
                    percentage = ((double)this.stageId + 0.0) / addToProductionSetStageCount + stagePercentage / addToProductionSetStageCount;
                }
            }
        }
        return percentage;
    }

    private static class InternalDocumentNumber {
        private int box;
        private int folder;
        private int page;

        private InternalDocumentNumber(int box, int folder, int page) {
            this.box = box;
            this.folder = folder;
            this.page = page;
        }
    }
}

