/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureNlpConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.GraphConfigureConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.MetadataExportOperationImplementation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import java.util.List;

@OperationMetadata(alias=OperationAlias.ANALYZE_WITH_NLP, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE", "NUIX_NLP"}), @OperationTag(name="Category", value={"METADATA"})})
@FormFieldRow(name="useLanguageCodeRow", children={"useLanguageCode", "languageCode"})
@OperationLicenseModule(module=ModuleType.NLP)
public class AnalyzeWithNlpOperation
extends Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MetadataExportOperationImplementation.class);
    @FormField(required=false)
    public String scope = "content:* AND has-exclusion:0";
    @FormField
    public double dictionaryProximityThreshold = 0.2;
    @FormField
    public double skillsetProximityThreshold = 0.4;
    @FormField
    public boolean updateDuplicates = false;
    @FormField
    public boolean includeNamedEntities = false;
    @FormField
    public boolean useLanguageCode = true;
    @FormField(enableOn={@OnField(name="useLanguageCode")})
    public String languageCode = "en";
    @FormField
    public boolean sendEnrichmentToGraph = false;
    @FormField
    public boolean sendAdditionalMetadata = true;

    @Override
    public String getOperationName() {
        return this.iu.getString("AnalyseWithNlpOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.ANALYZE_WITH_NLP;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigureNlpOperation = false;
        boolean detectedConfigureGraphOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureNlpConnectionOperation) {
                detectedConfigureNlpOperation = true;
            }
            if (o instanceof GraphConfigureConnectionOperation) {
                detectedConfigureGraphOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureNlpOperation) {
            prerequisites.add(this.iu.getString("AnalyseWithNlpOperation.Prerequisites.MissingConfigureNlpOperation"));
        }
        if (this.sendEnrichmentToGraph && !detectedConfigureGraphOperation) {
            prerequisites.add(this.iu.getString("GraphPromoteOperation.Prerequisites.MissingConfigureOperation"));
        }
        if ((activity == Operation.PrerequisitesActivity.RUN_INTERACTIVE || activity == Operation.PrerequisitesActivity.RUN_UNATTENDED) && this.executionContext.nuixVersion.compareTo(new Version("9.11")) < 0) {
            prerequisites.add(this.iu.getString("AnalyseWithNlpOperation.Prerequisites.UpdateNuixVersion"));
        }
        return prerequisites;
    }
}

