/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.LocalizableEnumUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.AssignCustomMetadataOperation;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;
import nuix.ItemCustomMetadataMap;
import nuix.ProductionSetItem;
import org.joda.time.DateTime;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class AssignCustomMetadataOperationImplementation
extends AssignCustomMetadataOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AssignCustomMetadataOperation.class);
    private transient String stageName;
    private transient long stageItems;
    private transient AtomicLong unreferencedItems;
    private transient AtomicLong invalidTypeItems;
    private transient AtomicLong processedItems;
    private transient AtomicLong docIdSkippedItems;
    private transient long stageTotalItems;
    private transient int stageId;
    private transient int stageCount;
    private transient Map<String, String[]> indexedLines;
    private transient String[] header;
    private transient FieldType[] fieldTypes;
    private transient MatchType matchType;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.metadataFile = this.executionContext.evalParameters(this.metadataFile, this);
        this.separator = this.executionContext.evalParameters(this.separator, this);
        this.executionContext.closeAllTabs();
        this.stageCount = 1;
        this.stageId = 0;
        this.stageItems = 0L;
        this.startTriggerThread = new Thread(() -> {
            try {
                long invalidFormatCount;
                int i;
                String[] typesHeader;
                List lines;
                if (this.appendToPreviousMetadata) {
                    this.addExecutionLog(this.iu.getString("AssignCustomMetadataOperation.Log.MethodAppendToPreviousMetadata"));
                    this.addExecutionLog(this.iu.getFormattedString("AssignCustomMetadataOperation.Log.Separator", (Object)this.separator));
                    this.addExecutionLog(this.iu.getFormattedString("AssignCustomMetadataOperation.Log.MaxFieldLength", (Object)this.maxFieldsLength));
                } else {
                    this.addExecutionLog(this.iu.getString("AssignCustomMetadataOperation.Log.MethodOverwritePreviousMetadata"));
                }
                this.stageName = this.iu.getString("AssignCustomMetadataOperation.Stage.ReadingMetadataFile");
                LOGGER.info("Read metadata file");
                if (this.metadataFile.toLowerCase().endsWith(".csv")) {
                    this.addExecutionLog(this.iu.getFormattedString("AssignCustomMetadataOperation.Log.CsvMetadataFileLocation", (Object)this.metadataFile));
                    lines = FileUtils.loadVariableColumnCsv((File)new File(this.metadataFile));
                } else {
                    this.addExecutionLog(this.iu.getFormattedString("AssignCustomMetadataOperation.Log.TsvMetadataFileLocation", (Object)this.metadataFile));
                    lines = FileUtils.loadVariableColumnTsv((File)new File(this.metadataFile));
                }
                this.header = (String[])lines.get(0);
                if (this.header.length < 2) {
                    throw new Exception(this.iu.getString("AssignCustomMetadataOperation.Exception.MetadataFileMustContainTwoColumn"));
                }
                this.matchType = null;
                if (this.header[0].equalsIgnoreCase("guid")) {
                    this.matchType = MatchType.GUID;
                } else if (this.header[0].equalsIgnoreCase("docid")) {
                    this.matchType = MatchType.DOC_ID;
                } else if (this.header[0].equalsIgnoreCase("itemname")) {
                    this.matchType = MatchType.ITEM_NAME;
                } else if (this.header[0].equalsIgnoreCase("key")) {
                    this.matchType = MatchType.KEY;
                }
                if (this.matchType == null) {
                    throw new Exception(this.iu.getString("AssignCustomMetadataOperation.Exception.FirstColumnMustBeGUID"));
                }
                if (this.header[0].equalsIgnoreCase("docid") && this.executionContext.nuixVersion.compareTo(new Version("7.4.0")) < 0) {
                    this.addWarning(this.iu.getNumeralString("AssignCustomMetadataOperation.Warning.ItemsSkipped", (long)(lines.size() - 1)));
                }
                this.indexedLines = new HashMap<String, String[]>();
                long lineId = 0L;
                lines.remove(0);
                if (lines.size() > 1 && (typesHeader = (String[])lines.get(0))[0].toLowerCase().equals("type")) {
                    lines.remove(0);
                    this.addExecutionLog(this.iu.getString("AssignDataSetMetadataOperation.Log.AssigningFieldTypes"));
                    this.fieldTypes = new FieldType[this.header.length];
                    this.fieldTypes[0] = FieldType.TYPE;
                    for (i = 1; i < typesHeader.length; ++i) {
                        this.fieldTypes[i] = typesHeader[i].equalsIgnoreCase("Float") ? FieldType.FLOAT : (typesHeader[i].equalsIgnoreCase("Boolean") ? FieldType.BOOLEAN : (typesHeader[i].equalsIgnoreCase("Date") ? FieldType.DATE : (typesHeader[i].equalsIgnoreCase("Integer") ? FieldType.INTEGER : (typesHeader[i].equalsIgnoreCase("Text") ? FieldType.TEXT : FieldType.TEXT))));
                    }
                    for (i = 1; i < this.header.length; ++i) {
                        this.addExecutionLog(this.iu.getFormattedString("AssignDataSetMetadataOperation.Log.AssigningFieldType", new Object[]{this.header[i], LocalizableEnumUtils.getLocalizedString((Enum)this.fieldTypes[i])}));
                    }
                    if (this.appendToPreviousMetadata) {
                        this.addWarning(this.iu.getString("AssignCustomMetadataOperation.Warning.CannotAppendWithExplicitFormats"));
                    }
                }
                for (Object[] line : lines) {
                    ++lineId;
                    if (line == null || line.length == 0 || line[0] == null) continue;
                    String index = ((String)line[0]).trim();
                    if (index.length() > 0 && this.indexedLines.containsKey(index)) {
                        throw new Exception(this.iu.getFormattedString("AssignCustomMetadataOperation.Exception.NotUnique", new Object[]{line[0], lineId}));
                    }
                    this.indexedLines.put((String)line[0], (String[])line);
                }
                LOGGER.info("Read " + lines.size() + " lines");
                this.addExecutionLog(this.iu.getNumeralString("AssignCustomMetadataOperation.Log.MetadataFileSize", (long)this.indexedLines.size()));
                StringBuilder fields = new StringBuilder();
                for (i = 1; i < this.header.length; ++i) {
                    if (fields.length() > 0) {
                        fields.append(", ");
                    }
                    fields.append(this.header[i]);
                }
                this.addExecutionLog(this.iu.getFormattedString("AssignCustomMetadataOperation.Log.Fields", (Object)fields.toString()));
                this.addExecutionLog(this.iu.getFormattedString("AssignCustomMetadataOperation.Log.ScopeQuery", (Object)this.scope));
                this.stageName = this.iu.getString("AssignCustomMetadataOperation.Stage.SearchingForItemsToUpdate");
                LOGGER.info("Searching for items to update: " + this.scope);
                Set itemsToUpdate = this.executionContext.nuixCase.searchUnsorted(this.scope);
                long itemsToUpdateSize = itemsToUpdate.size();
                LOGGER.info("Got " + itemsToUpdateSize + " items");
                this.addExecutionLog(this.iu.getNumeralString("AssignCustomMetadataOperation.Log.ScopeCount", itemsToUpdateSize));
                this.stageName = this.iu.getString("AssignCustomMetadataOperation.Stage.AssigningFieldValues");
                this.stageTotalItems = itemsToUpdateSize;
                LOGGER.info("Assigning field values to " + itemsToUpdateSize + " items");
                this.unreferencedItems = new AtomicLong();
                this.invalidTypeItems = new AtomicLong();
                this.processedItems = new AtomicLong();
                FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)itemsToUpdate, ItemsUtils.getPartitionerChunkSize(1000, this));
                try {
                    Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        while (iterator.hasNext()) {
                            Item itemToUpdate = (Item)iterator.next();
                            if (this.stopRequested) {
                                throw new WorkflowExecutionStopRequested();
                            }
                            this.processedItems.incrementAndGet();
                            this.updateItemsCustomMetadataFields(itemToUpdate);
                        }
                    }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                }
                catch (WorkflowExecutionStopRequested e) {
                    this.trackStopped();
                    return;
                }
                catch (Exception e) {
                    LOGGER.warn("Exception thrown while processing items", (Throwable)e);
                }
                long unreferencedItemsCount = this.unreferencedItems.get();
                if (unreferencedItemsCount > 0L) {
                    this.addExecutionLog(this.iu.getNumeralString("AssignCustomMetadataOperation.Log.SkippedDueToMissingReferenceInMetadataFile", unreferencedItemsCount));
                }
                if ((invalidFormatCount = this.invalidTypeItems.get()) > 0L) {
                    this.addWarning(this.iu.getNumeralString("AssignCustomMetadataOperation.Log.SkippedDueToInvalidDataFormat", invalidFormatCount));
                }
                this.addExecutionLog(this.iu.getNumeralString("AssignCustomMetadataOperation.Log.EffectiveCount", itemsToUpdateSize - unreferencedItemsCount - invalidFormatCount));
                ++this.stageId;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void updateItemCustomMetadataMap(ItemCustomMetadataMap itemCustomMetadataMap, String fieldName, String additionalValue) {
        TreeSet<String> previousValues = new TreeSet<String>();
        if (itemCustomMetadataMap.containsKey((Object)fieldName)) {
            String[] splits;
            String previousValuesString = (String)itemCustomMetadataMap.get((Object)fieldName);
            for (String split : splits = previousValuesString.split(this.separator)) {
                if (split.length() <= 0) continue;
                previousValues.add(split);
            }
        }
        previousValues.add(additionalValue);
        String result = FormattingUtils.join(previousValues, (String)this.separator, (int)this.maxFieldsLength);
        itemCustomMetadataMap.put((Object)fieldName, (Object)result);
    }

    private void updateItemsCustomMetadataFields(Item itemToUpdate) {
        ++this.stageItems;
        try {
            String key = null;
            String[] metadata = null;
            if ((this.matchType.equals((Object)MatchType.GUID) || this.matchType.equals((Object)MatchType.KEY)) && this.indexedLines.containsKey(key = itemToUpdate.getGuid())) {
                metadata = this.indexedLines.get(key);
            }
            if (metadata == null && (this.matchType.equals((Object)MatchType.ITEM_NAME) || this.matchType.equals((Object)MatchType.KEY)) && this.indexedLines.containsKey(key = itemToUpdate.getName())) {
                metadata = this.indexedLines.get(key);
            }
            if (metadata == null && (this.matchType.equals((Object)MatchType.DOC_ID) || this.matchType.equals((Object)MatchType.KEY)) && this.executionContext.nuixVersion.compareTo(new Version("7.4.0")) >= 0) {
                Set productionSetItems = itemToUpdate.getProductionSetItems();
                for (ProductionSetItem productionSetItem : productionSetItems) {
                    key = productionSetItem.getDocumentNumber().toString();
                    if (!this.indexedLines.containsKey(key)) continue;
                    metadata = this.indexedLines.get(key);
                    break;
                }
            }
            if (metadata == null) {
                this.unreferencedItems.incrementAndGet();
            } else {
                boolean invalidFieldFormat = false;
                for (int i = 1; i < this.header.length; ++i) {
                    String metadataFieldName = this.header[i];
                    String metadataValue = "";
                    if (metadata.length > i) {
                        metadataValue = metadata[i];
                    }
                    ItemCustomMetadataMap itemCustomMetadataMap = itemToUpdate.getCustomMetadata();
                    if (this.fieldTypes != null) {
                        try {
                            switch (this.fieldTypes[i].ordinal()) {
                                case 1: {
                                    itemCustomMetadataMap.putFloat(metadataFieldName, (Object)Double.parseDouble(metadataValue));
                                    break;
                                }
                                case 3: {
                                    itemCustomMetadataMap.putDate(metadataFieldName, (Object)DateTime.parse((String)metadataValue));
                                    break;
                                }
                                case 2: {
                                    itemCustomMetadataMap.putBoolean(metadataFieldName, (Object)Boolean.parseBoolean(metadataValue));
                                    break;
                                }
                                case 4: {
                                    itemCustomMetadataMap.putInteger(metadataFieldName, (Object)Integer.parseInt(metadataValue));
                                    break;
                                }
                                default: {
                                    itemCustomMetadataMap.put((Object)metadataFieldName, (Object)metadataValue);
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Cannot parse value " + metadataValue + " as " + String.valueOf((Object)this.fieldTypes[i]), (Throwable)e);
                            invalidFieldFormat = true;
                        }
                        continue;
                    }
                    if (this.appendToPreviousMetadata) {
                        this.updateItemCustomMetadataMap(itemCustomMetadataMap, metadataFieldName, metadataValue);
                        continue;
                    }
                    itemCustomMetadataMap.put((Object)metadataFieldName, (Object)metadataValue);
                }
                if (invalidFieldFormat) {
                    this.invalidTypeItems.incrementAndGet();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot update metadata.", (Throwable)e);
        }
    }

    @Override
    public void stopTriggered() {
        this.stopRequested = true;
    }

    @Override
    protected double getPercentageComplete() {
        double stageProgress = 0.0;
        if (this.processedItems != null) {
            stageProgress = (double)this.processedItems.get() / (double)this.stageTotalItems;
        }
        double percentageComplete = (stageProgress + (double)this.stageId) / (double)this.stageCount;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.stageItems > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("AssignCustomMetadataOperation.Progress.ItemsProcessed", this.stageItems);
        }
        return result;
    }

    static enum MatchType {
        DOC_ID,
        GUID,
        ITEM_NAME,
        KEY;

    }

    static enum FieldType {
        TYPE,
        FLOAT,
        BOOLEAN,
        DATE,
        INTEGER,
        TEXT;

    }
}

