/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.models.api.dataset.AzureStorageAccount;
import com.nuix.automate.utils.models.api.dataset.DataRepository;
import com.nuix.automate.utils.models.api.dataset.DatasetType;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.AzureStorageAccountConfigureConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.DataRepositoryOperation;
import com.nuix.automate.workflow.core.utils.azure.AzureStorageAccountInfo;
import com.nuix.automate.workflow.core.utils.azure.AzureStorageAccountOperationException;
import java.util.Map;

public class AzureStorageAccountConfigureConnectionOperationImplementation
extends AzureStorageAccountConfigureConnectionOperation
implements DataRepositoryOperation {
    private transient Map<String, DataRepository> dataRepositories;

    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.stageName = this.iu.getString("AzureStorageAccountConfigureConnectionOperation.Stage.InitializingRestClient");
            this.azureStorageAccountId = this.executionContext.evalParameters(this.azureStorageAccountId, this);
            DataRepository dataRepository = this.dataRepositories.get(this.azureStorageAccountId);
            if (dataRepository == null || dataRepository.getType() != DatasetType.AZURE_STORAGE_ACCOUNT) {
                throw new AzureStorageAccountOperationException(this.iu.getFormattedString("AzureStorageAccountConfigureConnectionOperation.Error.MissingAzureStorageAccount", (Object)this.azureStorageAccountId));
            }
            AzureStorageAccount azureStorageAccount = dataRepository.getAzureStorageAccount();
            if (azureStorageAccount == null) {
                throw new AzureStorageAccountOperationException(this.iu.getFormattedString("AzureStorageAccountConfigureConnectionOperation.Error.MissingAzureStorageAccount", (Object)this.azureStorageAccountId));
            }
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{azure_storage_account_url}", azureStorageAccount.getAccountUrl())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{azure_storage_account_name}", azureStorageAccount.getAccountName())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{azure_storage_account_key_protected}", azureStorageAccount.getAccountKey())));
            this.initializeRestClient();
            this.stageName = this.iu.getString("AzureStorageAccountConfigureConnectionOperation.Stage.TestingRestClient");
            this.percentageComplete = 0.3;
            AzureStorageAccountInfo accountInfo = this.storageAccountRestClient.getAccountInfo();
            this.addExecutionLog(this.iu.getFormattedString("AzureStorageAccountConfigureConnectionOperation.Log.AccountUrl", (Object)azureStorageAccount.getAccountUrl()));
            this.addExecutionLog(this.iu.getFormattedString("AzureStorageAccountConfigureConnectionOperation.Log.AccountName", (Object)azureStorageAccount.getAccountName()));
            this.addExecutionLog(this.iu.getFormattedString("AzureStorageAccountConfigureConnectionOperation.Log.AccountKind", (Object)accountInfo.getAccountKind()));
            this.addExecutionLog(this.iu.getFormattedString("AzureStorageAccountConfigureConnectionOperation.Log.AccountSkuName", (Object)accountInfo.getSkuName()));
            this.percentageComplete = 0.6;
            this.addExecutionLog(this.iu.getFormattedString("AzureStorageAccountConfigureConnectionOperation.Log.BlobStorageVersion", (Object)accountInfo.getVersion()));
        });
    }

    @Override
    public void setDataRepositories(Map<String, DataRepository> dataRepositories) {
        this.dataRepositories = dataRepositories;
    }
}

