/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.AzureStorageAccountCreateContainerOperation;

public class AzureStorageAccountCreateContainerOperationImplementation
extends AzureStorageAccountCreateContainerOperation {
    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.initializeRestClient();
            this.containerName = this.executionContext.evalParameters(this.containerName, this);
            this.containerName = this.containerName.toLowerCase();
            this.containerName = this.containerName.replaceAll("[^a-z0-9]+", "-");
            this.containerName = this.containerName.replaceAll("--", "-");
            this.containerName = this.containerName.replaceAll("^-*([a-z0-9\\-]+[a-z0-9]+)-*$", "$1");
            this.stageName = this.iu.getString("AzureStorageAccountCreateContainerOperation.Stage.CreatingContainer");
            this.percentageComplete = 0.1;
            this.storageAccountRestClient.createContainer(this.containerName);
            String containerUrl = this.storageAccountUrl + "/" + this.containerName;
            this.addExecutionLog(this.iu.getFormattedString("AzureStorageAccountCreateContainerOperation.Log.ContainerUrl", (Object)containerUrl));
            this.addExecutionLog(this.iu.getFormattedString("AzureStorageAccountCreateContainerOperation.Log.ContainerName", (Object)this.containerName));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{azure_storage_account_container_url}", containerUrl)));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{azure_storage_account_container_name}", this.containerName)));
        });
    }
}

